/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.jd;

import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.resp.model.jd.JDPageNum;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JDApiSkuSetProc
implements Runnable {
    private String token;
    private String apiuri;
    private JdbcTemplate jdbcTemplate;
    private static final Logger log = LoggerFactory.getLogger(JDApiSkuSetProc.class);
    private JDPageNum jdpagenum;

    public JDApiSkuSetProc(String token, JdbcTemplate jdbcTemplate, JDPageNum jdpagenum) {
        this.token = token;
        this.apiuri = "https://bizapi.jd.com/api/product/getSku";
        this.jdbcTemplate = jdbcTemplate;
        this.jdpagenum = jdpagenum;
    }

    @Override
    public void run() {
        log.info(this.apiuri + this.token);
        log.info(this.jdpagenum.getPage_num() + this.jdpagenum.getPage_num() + " start ");
        String org_json = HttpRequest.sendPost(this.apiuri, "token=" + this.token + "&pageNum=" + this.jdpagenum.getPage_num());
        JsonParser parse = new JsonParser();
        try {
            if (!parse.parse(org_json).getAsJsonObject().get("result").isJsonNull()) {
                String sku_str = parse.parse(org_json).getAsJsonObject().get("result").getAsString();
                String[] sku_arr = sku_str.split(",");
                ArrayList<Object[]> sku_set_list = new ArrayList<Object[]>();
                for (int i = 0; i < sku_arr.length; ++i) {
                    try {
                        Object[] obj = new Object[]{this.jdpagenum.getName(), this.jdpagenum.getPage_num(), Long.parseLong(sku_arr[i])};
                        sku_set_list.add(obj);
                        continue;
                    }
                    catch (Exception e) {
                        log.info(e.toString() + "error_sku:" + sku_arr[i]);
                        System.out.println(e.toString());
                    }
                }
                log.info("page_num-" + this.jdpagenum.getPage_num() + ":" + sku_arr.length);
                this.jdbcTemplate.batchUpdate("INSERT INTO jd_sku_set (name,page_num,sku) VALUES (?,?,?)", sku_set_list);
                log.info(this.jdpagenum.getPage_num() + " end_INDB");
            }
        }
        catch (Exception e1) {
            log.info(e1.toString() + "error_pageNum = " + this.jdpagenum.getPage_num() + " error_json: " + org_json);
            System.out.println(e1.toString());
        }
    }
}

