/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.jd;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.resp.model.jd.JDSkuDetail;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class JDApiSkuStateProc
implements Runnable {
    private String token;
    private String apiuri;
    private JdbcTemplate jdbcTemplate;
    private int channel_id;
    private int channel_count;
    private static final Logger log = LoggerFactory.getLogger(JDApiSkuStateProc.class);
    private String supplierCode;

    public JDApiSkuStateProc(String token, JdbcTemplate jdbcTemplate, int channel_id, int channel_count, String supplierCode) {
        this.token = token;
        this.apiuri = "https://bizapi.jd.com/api/product/skuState";
        this.jdbcTemplate = jdbcTemplate;
        this.channel_id = channel_id;
        this.channel_count = channel_count;
        this.supplierCode = supplierCode;
    }

    @Override
    public void run() {
        log.info("channel_id = [" + this.channel_id + "] start");
        log.info(this.apiuri + this.token);
        List rows = this.jdbcTemplate.queryForList("select page_num,sku from EXTERNAL_SKU_SET where mod(sku,?) = ?  and sku not in (select sku from EXTERNAL_SKU_STATE where SUPPLIER_CODE=?) and SUPPLIER_CODE=? ", new Object[]{this.channel_count, this.channel_id, this.supplierCode, this.supplierCode});
        ArrayList<Object[]> sku_detail_list_obj = new ArrayList<Object[]>();
        ArrayList<JDSkuDetail> sku_detail_list = new ArrayList<JDSkuDetail>();
        JsonParser parse = new JsonParser();
        String org_json = null;
        int batch_count = 0;
        for (Map map : rows) {
            long sku = Long.parseLong(map.get("sku").toString());
            try {
                org_json = HttpRequest.sendPost(this.apiuri, "token=" + this.token + "&sku=" + sku);
                if (parse.parse(org_json).getAsJsonObject().get("result") != null) {
                    JsonArray json_main = parse.parse(org_json).getAsJsonObject().get("result").getAsJsonArray();
                    JDSkuDetail jdskudetail = new JDSkuDetail();
                    for (JsonElement je : json_main) {
                        jdskudetail.setState(je.getAsJsonObject().get("state").isJsonNull() ? -1 : je.getAsJsonObject().get("state").getAsInt());
                        jdskudetail.setSku(je.getAsJsonObject().get("sku").isJsonNull() ? -1L : je.getAsJsonObject().get("sku").getAsLong());
                        Object[] obj = new Object[]{jdskudetail.getState(), jdskudetail.getSku(), this.supplierCode};
                        sku_detail_list_obj.add(obj);
                        sku_detail_list.add(jdskudetail);
                    }
                    log.info("GET jdskustatus:" + jdskudetail.getSku() + "");
                } else {
                    log.info("channel_id = [" + this.channel_id + "] sku = " + sku + " ERROR JSON :" + org_json);
                }
                if (batch_count == 10) {
                    this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_SKU_STATE (state,sku,SUPPLIER_CODE) VALUES (?,?,?)", sku_detail_list_obj);
                    log.info("batch commit 500 :" + sku_detail_list_obj.size());
                    sku_detail_list_obj.clear();
                    batch_count = 0;
                }
                ++batch_count;
            }
            catch (Exception e) {
                log.info(e.toString() + "error_sku:" + sku);
                log.info(e.toString() + " error_json: " + org_json);
                System.out.println(e.toString());
            }
        }
        this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_SKU_STATE (state,sku,SUPPLIER_CODE) VALUES (?,?,?)", sku_detail_list_obj);
        log.info("batch commit rest :" + sku_detail_list_obj.size());
        sku_detail_list_obj.clear();
        log.info("channel_id = [" + this.channel_id + "] end");
    }
}

