/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.linkedmall;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.tydic.commodity.atom.BO.UccGetItemBO;
import com.tydic.commodity.atom.BO.UccGetItemDetailBO;
import com.tydic.commodity.atom.BO.UccGetItemDetailRespBO;
import com.tydic.commodity.atom.BO.UccGetItemRespBO;
import com.tydic.commodity.atom.BO.UccGetItemStockBO;
import com.tydic.commodity.atom.BO.UccGetItemStockRespBO;
import com.tydic.commodity.atom.BO.UccGetSkuDetailBO;
import com.tydic.commodity.atom.BO.UccGetStockItemReqBO;
import com.tydic.commodity.batchimp.initialize.utils.DataPool;
import com.tydic.commodity.utils.HttpTool;
import com.tydic.commodity.utils.SignUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class LinkedMallGetItemsProc
implements Runnable {
    public static final String appSecret = "da9d575d25824ef191298a104023f825";
    public static final Long appKey = 56231899L;
    public static final Integer PAGE_SIZE = 20;
    private static final Logger log = LoggerFactory.getLogger(LinkedMallGetItemsProc.class);
    private static final String GET_ITEM_LIST_URL = "http://47.103.143.190:10000/query/item/list";
    private static final String GET_ITEM_DETAIL = "http://47.103.143.190:10000/query/item/detail";
    private static final String GET_ITEM_STOCK = "http://47.103.143.190:10000/query/item/stock";
    private JdbcTemplate jdbcTemplate;
    private String supplierCode;

    public LinkedMallGetItemsProc(JdbcTemplate jdbcTemplate, String supplierCode) {
        this.jdbcTemplate = jdbcTemplate;
        this.supplierCode = supplierCode;
    }

    @Override
    public void run() {
        this.getItems();
    }

    public Integer calculateTotalPageCount(Integer totalCount) {
        return (int)Math.ceil((double)totalCount.intValue() / (double)PAGE_SIZE.intValue());
    }

    public void getItems() {
        Integer totalPageNumber = 1;
        boolean initFlag = true;
        try {
            for (int i = 1; i <= totalPageNumber; ++i) {
                LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
                params.put("appKey", appKey);
                params.put("pageNum", i);
                params.put("pageSize", PAGE_SIZE);
                String str = this.sendHttp(GET_ITEM_LIST_URL, params);
                UccGetItemRespBO uccGetItemRespBO = (UccGetItemRespBO)JSONObject.parseObject((String)str, UccGetItemRespBO.class);
                String code = uccGetItemRespBO.getCode();
                if ("0000".equals(code)) {
                    if (initFlag) {
                        Integer totalCount = uccGetItemRespBO.getData().getRotalCount();
                        totalPageNumber = this.calculateTotalPageCount(totalCount);
                        initFlag = false;
                    }
                    List itemList = uccGetItemRespBO.getData().getItemList();
                    this.dealItems(itemList, i);
                    continue;
                }
                log.error("\u83b7\u53d6\u5217\u8868\u6570\u636e\u5931\u8d25");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dealItems(List<UccGetItemBO> itemList, Integer pageNumber) {
        if (!CollectionUtils.isEmpty(itemList)) {
            for (UccGetItemBO item : itemList) {
                List maps = this.jdbcTemplate.queryForList("select 1 from external_commodity_detail where sku=?", new Object[]{item.getItemId()});
                if (!CollectionUtils.isEmpty((Collection)maps)) continue;
                try {
                    this.getDtial(item.getItemId(), pageNumber);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.error("\u5904\u7406\u5f02\u5e38:" + item.getItemId());
                }
            }
        }
    }

    public void getDtial(Long itemId, Integer pageNumber) {
        log.info("\u5f00\u59cb\u83b7\u53d6\u5546\u54c1\u8be6\u60c5itemId:" + itemId);
        LinkedHashMap<String, Object> params = new LinkedHashMap<String, Object>();
        params.put("appKey", appKey);
        params.put("itemId", itemId);
        String str = this.sendHttp(GET_ITEM_DETAIL, params);
        log.info("\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u6570\u636e\u4e3a:" + str);
        UccGetItemDetailRespBO uccGetItemDetailRespBO = (UccGetItemDetailRespBO)JSONObject.parseObject((String)str, UccGetItemDetailRespBO.class);
        String code = uccGetItemDetailRespBO.getCode();
        if ("0000".equals(code)) {
            UccGetItemDetailBO item = uccGetItemDetailRespBO.getData().getItem();
            this.dealItem(item, pageNumber);
        }
    }

    public void dealItem(UccGetItemDetailBO item, Integer pageNumber) {
        String key;
        String properties = item.getPropertiesJson();
        Gson gson = new Gson();
        JsonObject jsonObject = (JsonObject)gson.fromJson(properties, JsonObject.class);
        Iterator iterator1 = jsonObject.entrySet().iterator();
        String product = "";
        String brandName = "";
        while (iterator1.hasNext()) {
            Map.Entry next = (Map.Entry)iterator1.next();
            String key2 = (String)next.getKey();
            JsonElement value = (JsonElement)next.getValue();
            if (key2.contentEquals("\u4ea7\u5730") && value != null) {
                product = value.getAsString();
            }
            if (!key2.contentEquals("\u54c1\u724c") || value == null) continue;
            brandName = value.getAsString();
        }
        String iforestProps = item.getIforestProps();
        JsonArray ifProp = null;
        if (!StringUtils.isEmpty((Object)iforestProps)) {
            ifProp = (JsonArray)gson.fromJson(iforestProps, JsonArray.class);
        }
        Object[] commodityParm = new Object[]{"empty", "empty", product, "empty", "https:" + item.getMainPicUrl(), null, null, item.getCanSell(), null, brandName, item.getItemId(), null, null, item.getItemTitle(), null, item.getDescPath(), null, null, null, item.getCatId(), this.supplierCode, item.getTotalSoldQuantity(), item.getPostFee(), item.getSellerId(), item.getTbShopName(), item.getIsPost()};
        this.jdbcTemplate.update("INSERT INTO external_commodity_detail (SALE_UNIT,weight,PRODUCT_AREA,WARE_QD,IMAGE_PATH,BRAND_PIC,param,state,moq,BRAND_NAME,sku,MFG_SKU,upc,name,DELIVERY_TIME,introduction,sku_cate1,sku_cate2,sku_cate3,sku_cate4,SUPPLIER_CODE,quantity,post_fee,SELLER_ID,TB_SHOP_NAME,is_post) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", commodityParm);
        Object[] pageParm = new Object[]{0, item.getItemId(), pageNumber, "linkedmall"};
        this.jdbcTemplate.update("insert into external_sku_set(PAGE_NUM,SKU,PAGE_NO,SUPPLIER_CODE) values(?,?,?,?)", pageParm);
        ArrayList<Object[]> attrList = new ArrayList<Object[]>();
        ArrayList<Object[]> picList = new ArrayList<Object[]>();
        if (jsonObject != null) {
            for (Map.Entry next : jsonObject.entrySet()) {
                key = (String)next.getKey();
                JsonArray valueArray = jsonObject.get(key).getAsJsonArray();
                for (int j = 0; j < valueArray.size(); ++j) {
                    String value = valueArray.get(j).getAsString();
                    Object[] attrparm = new Object[]{item.getItemId(), "empty", "empty", "empty", "empty", key, 1, value, this.supplierCode, 0};
                    attrList.add(attrparm);
                }
            }
        }
        if (ifProp != null) {
            for (int i = 0; i < ifProp.size(); ++i) {
                JsonObject asJsonObject = ifProp.get(i).getAsJsonObject();
                key = asJsonObject.get("key").getAsString();
                String[] value = asJsonObject.get("value").getAsString();
                Object[] attrparm = new Object[]{item.getItemId(), "empty", "empty", "empty", "empty", key, 1, value, this.supplierCode, 2};
                attrList.add(attrparm);
            }
        }
        Object[] mainPicParm = new Object[]{item.getItemId(), 1, 0, "https:" + item.getMainPicUrl(), this.supplierCode, item.getItemId()};
        picList.add(mainPicParm);
        String itemImagesStr = item.getItemImages();
        String[] split = itemImagesStr.split(",");
        if (split != null && split.length != 0) {
            for (String path : split) {
                Object[] picParm = new Object[]{item.getItemId(), 0, 0, "https:" + path, this.supplierCode, item.getItemId()};
                picList.add(picParm);
            }
        }
        List skus = item.getSkus();
        Integer totalSoldQuantity = item.getTotalSoldQuantity();
        ArrayList<Long> skuIds = new ArrayList<Long>();
        if (!CollectionUtils.isEmpty((Collection)skus)) {
            ArrayList<Object[]> skuList = new ArrayList<Object[]>();
            ArrayList<Object[]> priceList = new ArrayList<Object[]>();
            for (UccGetSkuDetailBO sku : skus) {
                Long skuId = sku.getSkuId();
                skuIds.add(skuId);
                Integer skuSoled = totalSoldQuantity;
                if (skuId == -1L) {
                    skuId = item.getItemId();
                }
                String skuName = "";
                skuName = !StringUtils.isEmpty((Object)sku.getSkuTitle()) ? item.getItemTitle() + " " + sku.getSkuTitle() : item.getItemTitle();
                Object[] skuParm = new Object[]{"empty", "empty", product, "empty", "https:" + item.getMainPicUrl(), null, null, 1, null, brandName, skuId, null, null, skuName, null, item.getDescPath(), null, null, null, item.getCatId(), this.supplierCode, item.getItemId(), skuSoled};
                skuList.add(skuParm);
                String skuPropertiesJson = sku.getSkuProperties();
                JsonObject skuPropertiesObject = (JsonObject)gson.fromJson(skuPropertiesJson, JsonObject.class);
                if (skuPropertiesObject != null) {
                    for (Map.Entry next : skuPropertiesObject.entrySet()) {
                        String key3 = (String)next.getKey();
                        String value = skuPropertiesObject.get(key3).getAsString();
                        Object[] attrparm = new Object[]{skuId, "empty", "empty", "empty", "empty", key3, 1, value, this.supplierCode, 1};
                        attrList.add(attrparm);
                    }
                }
                Object[] priceParm = new Object[]{item.getItemId(), skuId, this.fen2Yuan(item.getCurrentPrice()), this.fen2Yuan(sku.getPriceBid()), this.fen2Yuan(sku.getPriceCent()), this.supplierCode};
                priceList.add(priceParm);
            }
            this.jdbcTemplate.batchUpdate("INSERT INTO external_sku_detail (SALE_UNIT,weight,PRODUCT_AREA,WARE_QD,IMAGE_PATH,BRAND_PIC,param,state,moq,BRAND_NAME,sku,MFG_SKU,upc,name,DELIVERY_TIME,introduction,sku_cate1,sku_cate2,sku_cate3,sku_cate4,SUPPLIER_CODE,item_id,quantity) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", skuList);
            this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_SKU_ATTR (sku,ATTR_CODE,ATTR_GROUP_CODE,ATTR_GROUP_NAME,ATTR_GROUP_SEQ,ATTR_NAME,ATTR_SEQ,ATTR_VALUE,SUPPLIER_CODE,ATTR_TYPE) VALUES (?,?,?,?,?,?,?,?,?,?)", attrList);
            this.jdbcTemplate.batchUpdate("INSERT INTO EXTERNAL_PRICE (ITEM_ID,sku,EXTERNAL_PRICE,CON_PRICE,SELL_PRICE,SUPPLIER_CODE) VALUES (?,?,?,?)", priceList);
        }
        this.jdbcTemplate.batchUpdate("insert into EXTERNAL_SKU_PIC(SKU,IS_PRIMARY,ORDER_SORT,PATH,SUPPLIER_CODE,ITEM_ID) values (?,?,?,?,?,?)", picList);
        this.queryItemInventory(item.getItemId(), skuIds);
    }

    public void queryItemInventory(Long itemId, List<Long> skuId) {
        HashMap<String, Object> params = new HashMap<String, Object>(1);
        params.put("appKey", appKey);
        ArrayList<UccGetStockItemReqBO> itemLists = new ArrayList<UccGetStockItemReqBO>();
        UccGetStockItemReqBO uccGetStockItemReqBO = new UccGetStockItemReqBO();
        uccGetStockItemReqBO.setSkuIdLists(skuId);
        uccGetStockItemReqBO.setItemId(itemId);
        itemLists.add(uccGetStockItemReqBO);
        params.put("itemList", itemLists);
        params.put("divisionCode", "440300");
        String str = this.sendHttp(GET_ITEM_STOCK, params);
        UccGetItemStockRespBO uccGetItemStockRespBO = (UccGetItemStockRespBO)JSONObject.parseObject((String)str, UccGetItemStockRespBO.class);
        String code = uccGetItemStockRespBO.getCode();
        if ("0000".equals(code)) {
            List sockList = uccGetItemStockRespBO.getData().getItemList();
            this.dealItemInventory(sockList);
        }
    }

    public void dealItemInventory(List<UccGetItemStockBO> sockList) {
        if (!CollectionUtils.isEmpty(sockList)) {
            ArrayList<Object[]> parmList = new ArrayList<Object[]>();
            for (UccGetItemStockBO item : sockList) {
                List skuStockList = item.getSkuInfos();
                if (CollectionUtils.isEmpty((Collection)skuStockList)) continue;
                for (UccGetItemStockBO.SkuStock sku : skuStockList) {
                    Object[] parm = new Object[]{sku.getSkuId(), item.getItemId(), sku.getStock(), this.supplierCode};
                    parmList.add(parm);
                }
            }
            this.jdbcTemplate.batchUpdate("insert into external_sku_stock(sku_id,item_id,quantity,SUPPLIER_CODE) values(?,?,?,?)", parmList);
        }
    }

    public BigDecimal fen2Yuan(Long parm) {
        BigDecimal bigDecimal = BigDecimal.ZERO;
        if (parm == null) {
            return bigDecimal;
        }
        BigDecimal ParmBigDecimal = BigDecimal.valueOf(parm);
        bigDecimal = ParmBigDecimal.divide(new BigDecimal(100));
        return bigDecimal;
    }

    public String sendHttp(String url, Map<String, Object> postParm) {
        String signMp = "";
        try {
            signMp = SignUtil.getSignMp(postParm, appSecret);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        postParm.put("sign", signMp);
        String respJson = HttpTool.sendPostJson(url, JSON.toJSONString(postParm));
        return respJson;
    }

    public static void main(String[] args) {
        JdbcTemplate jdbcTemplate = DataPool.getJdbcTemplatePre();
        LinkedMallGetItemsProc linkedMallGetItemsProc = new LinkedMallGetItemsProc(jdbcTemplate, "linkedmall");
        Thread t1 = new Thread(linkedMallGetItemsProc);
        t1.start();
    }
}

