/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.linkedmall;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.tydic.commodity.batchimp.initialize.req.processor.linkedmall.LinkedMallCreateCatalogProc;
import com.tydic.commodity.batchimp.initialize.req.processor.linkedmall.LinkedMallRunableTask;
import com.tydic.commodity.batchimp.initialize.utils.DataPool;
import com.tydic.commodity.utils.SequenceMem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.CollectionUtils;

public class LinkedMallSkuPushProc {
    private static final Logger log = LoggerFactory.getLogger(LinkedMallCreateCatalogProc.class);
    private JdbcTemplate jdbcTemplate;
    private static final Long FROM_SUPPLIER_SHOP_ID = 10025L;
    private Long TO_SUPPLIER_SHOP_ID;
    private SequenceMem sequenceMem;
    private int channel_count;
    private int channel_id;
    private PlatformTransactionManager platformTransactionManager;
    private TransactionStatus status;

    public void initData(JdbcTemplate jdbcTemplate, int channel_id, int channel_count, Long toSupId, PlatformTransactionManager platformTransactionManager) {
        this.jdbcTemplate = jdbcTemplate;
        this.channel_count = channel_count;
        this.channel_id = channel_id;
        this.TO_SUPPLIER_SHOP_ID = toSupId;
        this.sequenceMem = new SequenceMem();
        this.platformTransactionManager = platformTransactionManager;
        this.sequenceMem.initData(jdbcTemplate, platformTransactionManager);
    }

    public void beginTransaction() {
        DefaultTransactionDefinition def = new DefaultTransactionDefinition();
        def.setPropagationBehavior(0);
        this.status = this.platformTransactionManager.getTransaction((TransactionDefinition)def);
    }

    public void endTransaction() {
        try {
            this.platformTransactionManager.commit(this.status);
        }
        catch (Exception ex) {
            this.platformTransactionManager.rollback(this.status);
        }
    }

    public void run() {
        log.info("\u5206\u7247:" + this.channel_id + " \u542f\u52a8");
        Date now = new Date();
        List fromCommodityList = this.jdbcTemplate.queryForList("select commodity_id, commodity_code, commodity_name, commodity_type_id, commodity_source, commodity_status, supplier_shop_id, shop_name, commodity_banner, commodity_link_char, commodity_link_url, brand_id, brand_name, agreement_id, serven_reject_allow, commodity_pc_detail_url, commodity_pc_detail_char, commodity_phone_detail_url, commodity_phone_detail_char, material_id, ext_sku_id, upc_code, store_get_type, create_oper_id, create_time, update_oper_id, update_time, remark, approval_status, freight_price, view_order, free_shipping, vendor_id, post_fee,VENDOR_SHOP_ID from ucc_commodity where SUPPLIER_SHOP_ID=? and mod(commodity_id,?)=?", new Object[]{FROM_SUPPLIER_SHOP_ID, this.channel_count, this.channel_id});
        if (!CollectionUtils.isEmpty((Collection)fromCommodityList)) {
            for (Map fromCommodityParmMap : fromCommodityList) {
                log.info("\u5206\u7247:" + this.channel_id + " \u5f00\u59cb\u5904\u7406\u5546\u54c1:" + fromCommodityParmMap.get("commodity_id"));
                try {
                    List fromCommodityPackageList;
                    List fromCommodityPicList;
                    this.beginTransaction();
                    ArrayList<Object[]> toCommoditySpceParmList = new ArrayList<Object[]>();
                    ArrayList<Object[]> toCommodityPicList = new ArrayList<Object[]>();
                    ArrayList<Object[]> toCommodityPackageList = new ArrayList<Object[]>();
                    Object[] toCommodityParm = this.mapToObjectArray(fromCommodityParmMap);
                    Long seq_ucc_commodity = this.sequenceMem.getSeq("SEQ_UCC_COMMODITY");
                    toCommodityParm[0] = seq_ucc_commodity;
                    toCommodityParm[6] = this.TO_SUPPLIER_SHOP_ID;
                    toCommodityParm[24] = now;
                    List commoditySpceList = this.jdbcTemplate.queryForList("select commodity_spec_id, commodity_id, supplier_shop_id, commodity_prop_grp_id, commodity_prop_grp_name, commodity_prop_def_id, prop_name, prop_show_name, prop_value_list_id, prop_value, create_oper_id, create_time, update_oper_id, update_time, remark from ucc_spu_spec where COMMODITY_ID=?", new Object[]{fromCommodityParmMap.get("commodity_id")});
                    if (!CollectionUtils.isEmpty((Collection)commoditySpceList)) {
                        for (Object fromCommoditySpceParmMap : commoditySpceList) {
                            Object[] fromCommoditySpceParm = this.mapToObjectArray((Map<String, Object>)fromCommoditySpceParmMap);
                            fromCommoditySpceParm[0] = this.sequenceMem.getSeq("SEQ_UCC_SPU_SPEC_ID");
                            fromCommoditySpceParm[1] = seq_ucc_commodity;
                            fromCommoditySpceParm[2] = this.TO_SUPPLIER_SHOP_ID;
                            fromCommoditySpceParm[11] = now;
                            toCommoditySpceParmList.add(fromCommoditySpceParm);
                        }
                    }
                    if (!CollectionUtils.isEmpty((Collection)(fromCommodityPicList = this.jdbcTemplate.queryForList("select commodity_pic_id, commodity_id, commodity_pic_type, commodity_pic_url, supplier_shop_id, create_oper_id, create_time, update_oper_id, update_time, remark from ucc_commodity_pic where COMMODITY_ID=?", new Object[]{fromCommodityParmMap.get("commodity_id")})))) {
                        Object fromCommoditySpceParmMap;
                        fromCommoditySpceParmMap = fromCommodityPicList.iterator();
                        while (fromCommoditySpceParmMap.hasNext()) {
                            Map fromCommodityPicParmMap = (Map)fromCommoditySpceParmMap.next();
                            Object[] fromCommodityPicParm = this.mapToObjectArray(fromCommodityPicParmMap);
                            fromCommodityPicParm[0] = this.sequenceMem.getSeq("SEQ_UCC_COMMODITY_PIC_ID");
                            fromCommodityPicParm[1] = seq_ucc_commodity;
                            fromCommodityPicParm[6] = now;
                            fromCommodityPicParm[4] = this.TO_SUPPLIER_SHOP_ID;
                            toCommodityPicList.add(fromCommodityPicParm);
                        }
                    }
                    List fromSkuList = this.jdbcTemplate.queryForList("select sku_id, commodity_id, supplier_shop_id, shop_name, commodity_type_id, sku_price, sku_code, sku_source, sku_name, sku_long_name, sku_pc_detail_url, sku_pc_detail_char, sku_phone_detail_url, sku_phone_detail_char, sku_status, pre_deliver_day, brand_id, brand_name, agreement_id, measure_id, measure_name, moq, mfgsku, is_supplier_agreement, material_id, ext_sku_id, upc_code, on_shelve_time, on_shelve_way, pre_on_shelve_day, create_oper_id, create_time, update_oper_id, update_time, remark from ucc_sku where COMMODITY_ID=?", new Object[]{fromCommodityParmMap.get("commodity_id")});
                    ArrayList<Object[]> toSkuList = new ArrayList<Object[]>();
                    ArrayList<Object[]> toSkuSpecList = new ArrayList<Object[]>();
                    ArrayList<Object[]> toSkuPriceList = new ArrayList<Object[]>();
                    ArrayList<Object[]> toRelCommodityPushList = new ArrayList<Object[]>();
                    ArrayList<Object[]> toSaleNumList = new ArrayList<Object[]>();
                    ArrayList<Object[]> toSkuStockList = new ArrayList<Object[]>();
                    if (!CollectionUtils.isEmpty((Collection)fromSkuList)) {
                        for (Map fromSkuMap : fromSkuList) {
                            List fromSkuStockList;
                            List fromSkuPriceList;
                            Object[] fromSkuParm = this.mapToObjectArray(fromSkuMap);
                            Long seq_ucc_sku = this.sequenceMem.getSeq("SEQ_UCC_SKU");
                            fromSkuParm[0] = seq_ucc_sku;
                            fromSkuParm[1] = seq_ucc_commodity;
                            fromSkuParm[2] = this.TO_SUPPLIER_SHOP_ID;
                            fromSkuParm[27] = now;
                            fromSkuParm[31] = now;
                            toSkuList.add(fromSkuParm);
                            List fromSkuSpecList = this.jdbcTemplate.queryForList("select sku_spec_id, sku_id, commodity_id, supplier_shop_id, commodity_prop_grp_id, commodity_prop_grp_name, commodity_prop_def_id, prop_name, prop_show_name, prop_value_list_id, prop_value, create_oper_id, create_time, update_oper_id, update_time, remark from UCC_SKU_SPEC where SKU_ID=?", new Object[]{fromSkuMap.get("sku_id")});
                            if (!CollectionUtils.isEmpty((Collection)fromSkuSpecList)) {
                                for (Object fromSkuSpecMap : fromSkuSpecList) {
                                    Object[] fromSkuSpecParm = this.mapToObjectArray((Map<String, Object>)fromSkuSpecMap);
                                    fromSkuSpecParm[0] = this.sequenceMem.getSeq("SEQ_UCC_SPU_SPEC_ID");
                                    fromSkuSpecParm[1] = seq_ucc_sku;
                                    fromSkuSpecParm[2] = seq_ucc_commodity;
                                    fromSkuSpecParm[3] = this.TO_SUPPLIER_SHOP_ID;
                                    fromSkuSpecParm[12] = now;
                                    toSkuSpecList.add(fromSkuSpecParm);
                                }
                            }
                            if (!CollectionUtils.isEmpty((Collection)(fromSkuPriceList = this.jdbcTemplate.queryForList("select sku_price_id, sku_id, supplier_shop_id, market_price, agreement_price, sale_price, member_price1, member_price2, member_price3, member_price4, member_price5, currency_type, create_oper_id, create_time, update_oper_id, update_time, remark from ucc_sku_price where SKU_ID=?", new Object[]{fromSkuMap.get("sku_id")})))) {
                                Object fromSkuSpecMap;
                                fromSkuSpecMap = fromSkuPriceList.iterator();
                                while (fromSkuSpecMap.hasNext()) {
                                    Map fromSkuPriceMap = (Map)fromSkuSpecMap.next();
                                    Object[] fromSkuPriceParm = this.mapToObjectArray(fromSkuPriceMap);
                                    fromSkuPriceParm[0] = this.sequenceMem.getSeq("SEQ_UCC_SKU_PRICE_ID");
                                    fromSkuPriceParm[1] = seq_ucc_sku;
                                    fromSkuPriceParm[2] = this.TO_SUPPLIER_SHOP_ID;
                                    fromSkuPriceParm[13] = now;
                                    toSkuPriceList.add(fromSkuPriceParm);
                                }
                            }
                            Object[] relCommodityPushParm = new Object[]{fromSkuMap.get("supplier_shop_id"), fromSkuMap.get("supplier_shop_id"), fromCommodityParmMap.get("commodity_id"), fromSkuMap.get("sku_id"), this.TO_SUPPLIER_SHOP_ID, this.TO_SUPPLIER_SHOP_ID, seq_ucc_commodity, seq_ucc_sku, now, "sys"};
                            toRelCommodityPushList.add(relCommodityPushParm);
                            List fromSaleNumList = this.jdbcTemplate.queryForList("select sale_id, sku_id, supplier_shop_id, sold_number, create_oper_id, create_time, update_oper_id, update_time, remark, ecommerce_sale from UCC_SALE_NUM where SKU_ID=?", new Object[]{fromSkuMap.get("sku_id")});
                            if (!CollectionUtils.isEmpty((Collection)fromSaleNumList)) {
                                for (Map fromSaleNumMap : fromSaleNumList) {
                                    Object[] fromSaleNumParm = this.mapToObjectArray(fromSaleNumMap);
                                    fromSaleNumParm[0] = this.sequenceMem.getSeq("SEQ_UCC_SALE_NUM_ID");
                                    fromSaleNumParm[1] = seq_ucc_sku;
                                    fromSaleNumParm[2] = this.TO_SUPPLIER_SHOP_ID;
                                    fromSaleNumParm[5] = now;
                                    toSaleNumList.add(fromSaleNumParm);
                                }
                            }
                            if (CollectionUtils.isEmpty((Collection)(fromSkuStockList = this.jdbcTemplate.queryForList("select stock_id, sku_id, supplier_shop_id, stock_status, stock_num, create_oper_id, create_time, update_oper_id, update_time, remark from UCC_SKU_STOCK where SKU_ID=?", new Object[]{fromSkuMap.get("sku_id")})))) continue;
                            for (Map fromSkuStockMap : fromSkuStockList) {
                                Object[] fromSkuStockParm = this.mapToObjectArray(fromSkuStockMap);
                                fromSkuStockParm[0] = this.sequenceMem.getSeq("SEQ_UCC_SKU_STOCK_ID");
                                fromSkuStockParm[1] = seq_ucc_sku;
                                fromSkuStockParm[2] = this.TO_SUPPLIER_SHOP_ID;
                                fromSkuStockParm[6] = now;
                                toSkuStockList.add(fromSkuStockParm);
                            }
                        }
                    }
                    if (!CollectionUtils.isEmpty((Collection)(fromCommodityPackageList = this.jdbcTemplate.queryForList("select package_id, commodity_id, supplier_shop_id, pack_param, after_service, instalment_flag, place_delivery, freight_template_id, invoice_type, create_oper_id, create_time, update_oper_id, update_time, remark from ucc_commodity_package where COMMODITY_ID=?", new Object[]{fromCommodityParmMap.get("commodity_id")})))) {
                        for (Map fromCommodityPackageMap : fromCommodityPackageList) {
                            Object[] fromCommodityPackageParm = this.mapToObjectArray(fromCommodityPackageMap);
                            fromCommodityPackageParm[0] = this.sequenceMem.getSeq("SEQ_UCC_PACKAGE_ID");
                            fromCommodityPackageParm[1] = seq_ucc_commodity;
                            fromCommodityPackageParm[2] = this.TO_SUPPLIER_SHOP_ID;
                            toCommodityPackageList.add(fromCommodityPackageParm);
                        }
                    }
                    this.jdbcTemplate.update("insert into ucc_commodity(commodity_id, commodity_code, commodity_name, commodity_type_id, commodity_source, commodity_status, supplier_shop_id, shop_name, commodity_banner, commodity_link_char, commodity_link_url, brand_id, brand_name, agreement_id, serven_reject_allow, commodity_pc_detail_url, commodity_pc_detail_char, commodity_phone_detail_url, commodity_phone_detail_char, material_id, ext_sku_id, upc_code, store_get_type, create_oper_id, create_time, update_oper_id, update_time, remark, approval_status, freight_price, view_order, free_shipping, vendor_id, post_fee,VENDOR_SHOP_ID) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", toCommodityParm);
                    this.jdbcTemplate.batchUpdate("insert into ucc_spu_spec(commodity_spec_id, commodity_id, supplier_shop_id, commodity_prop_grp_id, commodity_prop_grp_name, commodity_prop_def_id, prop_name, prop_show_name, prop_value_list_id, prop_value, create_oper_id, create_time, update_oper_id, update_time, remark) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", toCommoditySpceParmList);
                    this.jdbcTemplate.batchUpdate("insert into ucc_commodity_pic(commodity_pic_id, commodity_id, commodity_pic_type, commodity_pic_url, supplier_shop_id, create_oper_id, create_time, update_oper_id, update_time, remark) values(?,?,?,?,?,?,?,?,?,?)", toCommodityPicList);
                    this.jdbcTemplate.batchUpdate("insert into ucc_sku(sku_id, commodity_id, supplier_shop_id, shop_name, commodity_type_id, sku_price, sku_code, sku_source, sku_name, sku_long_name, sku_pc_detail_url, sku_pc_detail_char, sku_phone_detail_url, sku_phone_detail_char, sku_status, pre_deliver_day, brand_id, brand_name, agreement_id, measure_id, measure_name, moq, mfgsku, is_supplier_agreement, material_id, ext_sku_id, upc_code, on_shelve_time, on_shelve_way, pre_on_shelve_day, create_oper_id, create_time, update_oper_id, update_time, remark) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", toSkuList);
                    this.jdbcTemplate.batchUpdate("insert into UCC_SKU_SPEC(sku_spec_id, sku_id, commodity_id, supplier_shop_id, commodity_prop_grp_id, commodity_prop_grp_name, commodity_prop_def_id, prop_name, prop_show_name, prop_value_list_id, prop_value, create_oper_id, create_time, update_oper_id, update_time, remark) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", toSkuSpecList);
                    this.jdbcTemplate.batchUpdate("insert into ucc_sku_price(sku_price_id, sku_id, supplier_shop_id, market_price, agreement_price, sale_price, member_price1, member_price2, member_price3, member_price4, member_price5, currency_type, create_oper_id, create_time, update_oper_id, update_time, remark) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", toSkuPriceList);
                    this.jdbcTemplate.batchUpdate("insert into ucc_rel_commodity_push(org_supplier_id, org_supplier_shop_id, org_commodity_id, org_sku_id, supplier_id, supplier_shop_id, commodity_id, sku_id, create_time, oper_id) values(?,?,?,?,?,?,?,?,?,?)", toRelCommodityPushList);
                    this.jdbcTemplate.batchUpdate("insert into ucc_sale_num(sale_id, sku_id, supplier_shop_id, sold_number, create_oper_id, create_time, update_oper_id, update_time, remark, ecommerce_sale) values(?,?,?,?,?,?,?,?,?,?)", toSaleNumList);
                    this.jdbcTemplate.batchUpdate("insert into ucc_sku_stock(stock_id, sku_id, supplier_shop_id, stock_status, stock_num, create_oper_id, create_time, update_oper_id, update_time, remark) values(?,?,?,?,?,?,?,?,?,?)", toSkuStockList);
                    this.jdbcTemplate.batchUpdate("insert into ucc_commodity_package(package_id, commodity_id, supplier_shop_id, pack_param, after_service, instalment_flag, place_delivery, freight_template_id, invoice_type, create_oper_id, create_time, update_oper_id, update_time, remark) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?)", toCommodityPackageList);
                    this.endTransaction();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                log.info("\u5206\u7247:" + this.channel_id + " \u5904\u7406\u5546\u54c1:" + fromCommodityParmMap.get("commodity_id") + " \u7ed3\u675f!");
            }
        }
    }

    public Object[] mapToObjectArray(Map<String, Object> parmMap) {
        Object[] parm = null;
        if (parmMap != null && parmMap.size() > 0) {
            int size = parmMap.size();
            parm = new Object[size];
            Iterator<Map.Entry<String, Object>> iterator = parmMap.entrySet().iterator();
            int pos = 0;
            while (iterator.hasNext()) {
                parm[pos] = iterator.next().getValue();
                ++pos;
            }
        }
        return parm;
    }

    public static void main(String[] args) throws Exception {
        JdbcTemplate jdbcTemplate = DataPool.getJdbcTemplatePre();
        ThreadFactory namedThreadFactory = new ThreadFactoryBuilder().setNameFormat("thread-call-runner-%d").build();
        ThreadPoolExecutor fixedThreadPool = new ThreadPoolExecutor(50, 50, 2000L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), namedThreadFactory);
        System.out.println("\u5546\u54c1\u63a8\u9001\u5f00\u59cb\uff01");
        long start = System.currentTimeMillis();
        int total = 50;
        for (int i = 0; i < total; ++i) {
            LinkedMallRunableTask linkedMallRunableTask = new LinkedMallRunableTask();
            linkedMallRunableTask.setThreadNumber(i);
            linkedMallRunableTask.setThreadTotal(total);
            linkedMallRunableTask.setJdbcTemplate(jdbcTemplate);
            linkedMallRunableTask.setToSupId(363326790830874624L);
            fixedThreadPool.submit(linkedMallRunableTask);
        }
        fixedThreadPool.shutdown();
        while (true) {
            if (fixedThreadPool.isTerminated()) break;
            Thread.sleep(1000L);
        }
        System.out.println("\u5546\u54c1\u63a8\u9001\u6267\u884c\u7ed3\u675f\uff01");
        long end = System.currentTimeMillis();
        long l = (end - start) / 1000L;
        System.out.println("\u5546\u54c1\u63a8\u9001\u7528\u65f6:" + l);
    }
}

