/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.qst;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.tydic.commodity.batchimp.initialize.req.model.qst.QstGetSellPriceReq;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliToken;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.StringUtils;

public class QstApiGetSellPrice
implements Runnable {
    private String apiuri = "http://60.191.15.50:8014/getSellPrice";
    private JdbcTemplate jdbcTemplate;
    private DeliToken token;
    private int channel_id;
    private int total;
    private String pageNums;
    private static final Logger log = LoggerFactory.getLogger(QstApiGetSellPrice.class);
    private String supplierCode;

    public QstApiGetSellPrice(JdbcTemplate jdbcTemplate, DeliToken token, int channel_id, int total, String supplierCode, String pageNums) {
        this.jdbcTemplate = jdbcTemplate;
        this.token = token;
        this.channel_id = channel_id;
        this.total = total;
        this.supplierCode = supplierCode;
        this.pageNums = pageNums;
    }

    @Override
    public void run() {
        String dealPageNum = "";
        if (StringUtils.hasText((String)this.pageNums)) {
            dealPageNum = " and a.PAGE_NUM IN (" + this.pageNums + ")";
        }
        List rows = this.jdbcTemplate.queryForList("select a.sku from EXTERNAL_SKU_SET a where mod(a.id,?) = ? and a.sku not in(select sku from EXTERNAL_PRICE where SUPPLIER_CODE=?) and a.SUPPLIER_CODE=?" + dealPageNum, new Object[]{this.total, this.channel_id, this.supplierCode, this.supplierCode});
        Iterator it = rows.iterator();
        HttpRequest http = new HttpRequest();
        while (it.hasNext()) {
            Map map = (Map)it.next();
            String sku = map.get("sku").toString();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String timestamp = df.format(new Date());
            ArrayList<String> skulist = new ArrayList<String>();
            skulist.add(sku);
            QstGetSellPriceReq qstGetSellPriceReq = new QstGetSellPriceReq();
            qstGetSellPriceReq.setSku(skulist);
            qstGetSellPriceReq.setToken(this.token.getAccess_token());
            qstGetSellPriceReq.setTimestamp(timestamp);
            String org_info = "";
            try {
                Gson gson = new Gson();
                log.info("org_req = " + gson.toJson((Object)qstGetSellPriceReq));
                org_info = http.sendPostJsoneshy(this.apiuri, gson.toJson((Object)qstGetSellPriceReq));
                log.info("org_info = " + org_info);
                JsonParser parser = new JsonParser();
                if (parser.parse(org_info).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject().isJsonNull()) continue;
                JsonObject json_result = parser.parse(org_info).getAsJsonObject().get("result").getAsJsonArray().get(0).getAsJsonObject();
                this.jdbcTemplate.update("INSERT INTO EXTERNAL_PRICE (sku,EXTERNAL_PRICE,CON_PRICE,SUPPLIER_CODE) VALUES (?,?,?,?)", new Object[]{sku, json_result.get("ecPrice").getAsDouble(), json_result.get("price").getAsDouble(), this.supplierCode});
                log.info("sku + attr in db = " + qstGetSellPriceReq.getSku());
            }
            catch (Exception e) {
                log.info(e.toString() + "error_sku:" + sku);
                log.info(e.toString() + " error_json: " + org_info);
                System.out.println(e.toString());
            }
        }
    }
}

