/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.batchimp.initialize.req.processor.zkh;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.batchimp.initialize.req.model.zhk.ZkhPageNumReq;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliPageNum;
import com.tydic.commodity.batchimp.initialize.resp.model.deli.DeliToken;
import com.tydic.commodity.batchimp.initialize.utils.HttpRequest;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class ZkhApiGetPageNumProc {
    private String token;
    private String apiuri;
    private JdbcTemplate jdbcTemplate;
    private String clientId;
    private static final Logger log = LoggerFactory.getLogger(ZkhApiGetPageNumProc.class);
    private String supplierCode;

    public ZkhApiGetPageNumProc(JdbcTemplate jdbcTemplate, DeliToken token, String supplierCode) {
        this.token = token.getAccess_token();
        this.apiuri = "http://openapi.uat.zkh360.com/getPageNum";
        this.jdbcTemplate = jdbcTemplate;
        this.clientId = token.getClientId();
        this.supplierCode = supplierCode;
    }

    public void run() throws Exception {
        log.info(this.apiuri);
        log.info(this.token);
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String timestamp = df.format(new Date());
        ZkhPageNumReq zkhPageNumReq = new ZkhPageNumReq();
        zkhPageNumReq.setAppkey("A23378");
        zkhPageNumReq.setSerialnumber("sjd79and83cgem");
        zkhPageNumReq.setTimestamp(timestamp);
        zkhPageNumReq.setToken(this.token);
        Gson gson = new Gson();
        log.info("req_json = " + gson.toJson((Object)zkhPageNumReq));
        HttpRequest http = new HttpRequest();
        String org_json = http.sendPostJsonZkh(this.apiuri, gson.toJson((Object)zkhPageNumReq));
        log.info(org_json);
        JsonParser parse = new JsonParser();
        ArrayList<Object[]> skupoollist = new ArrayList<Object[]>();
        JsonArray jsonArr = parse.parse(org_json).getAsJsonObject().get("result").getAsJsonArray();
        for (JsonElement je : jsonArr) {
            DeliPageNum sp = new DeliPageNum();
            sp.setName(je.getAsJsonObject().get("name").getAsString());
            sp.setPage_num(je.getAsJsonObject().get("page_num").getAsString());
            log.info(je.getAsJsonObject().get("name").getAsString());
            log.info(je.getAsJsonObject().get("page_num").getAsString());
            Object[] obj = new Object[]{Sequence.getInstance().nextId(), sp.getName(), sp.getPage_num(), this.supplierCode};
            skupoollist.add(obj);
        }
        this.jdbcTemplate.batchUpdate("INSERT INTO UCC_COMMODITY_PAGE_NUM(id, name, page_num,SUPPLIER_CODE) VALUES (?,?,?,?)", skupoollist);
        this.jdbcTemplate.update("UPDATE UCC_COMMODITY_PAGE_NUM SET curr_page_no = 0,flag = 0,total_page_count = 1 where SUPPLIER_CODE = ?", new Object[]{this.supplierCode});
    }
}

