/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccAddAttributesReqBO;
import com.tydic.commodity.bo.busi.UccAddAttributesRspBO;
import com.tydic.commodity.busi.api.UccAddAttributesBusiService;
import com.tydic.commodity.dao.UccCommodityPropDefMapper;
import com.tydic.commodity.dao.po.UccCommdPropDefPo;
import com.tydic.commodity.enumType.CommodityPropDefEnum;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccAddAttributesBusiService.class)
public class UccAddAttributesBusiServiceImpl
implements UccAddAttributesBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccAddAttributesBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropDefMapper uccCommodityPropDefMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    private Sequence uccAttributesSequence = Sequence.getInstance();

    public UccAddAttributesRspBO addAttributes(UccAddAttributesReqBO reqBO) {
        UccAddAttributesRspBO rspBO = new UccAddAttributesRspBO();
        String errMsg = this.verify(reqBO);
        if (!"".equals(errMsg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMsg);
            return rspBO;
        }
        UccCommdPropDefPo po = new UccCommdPropDefPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        int count = 0;
        try {
            Long id = this.uccAttributesSequence.nextId();
            System.out.println("\u6dfb\u52a0\u5c5e\u6027\u7ec4\u4fe1\u606f\u751f\u6210 ID = " + id);
            po.setCommodityPropDefId(id);
            System.out.println("\u6dfb\u52a0\u5c5e\u6027\u7ec4\u4fe1\u606f\u751f\u6210 po  = " + JSONObject.toJSONString((Object)po));
            count = this.uccCommodityPropDefMapper.addAttributes(po);
            if (count < 1) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5c5e\u6027\u65b0\u589e\u5931\u8d25");
                return rspBO;
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u5c5e\u6027\u65b0\u589e\u6210\u529f");
            rspBO.setCommodityPropDefId(po.getCommodityPropDefId());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMessage());
            return rspBO;
        }
        return rspBO;
    }

    private String verify(UccAddAttributesReqBO reqBO) {
        String errMsg = "";
        if (StringUtils.isEmpty((CharSequence)reqBO.getPropCode())) {
            errMsg = "\u5c5e\u6027\u7f16\u7801\u5fc5\u4f20";
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getPropName())) {
            errMsg = "\u5c5e\u6027\u540d\u79f0\u5fc5\u4f20";
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getShowName())) {
            errMsg = "\u5c5e\u6027\u5c55\u793a\u540d\u79f0\u5fc5\u4f20";
        }
        if (reqBO.getFilterFlag() == null) {
            errMsg = "\u662f\u5426\u4e3a\u68c0\u7d22\u9879\u5fc5\u4f20";
        }
        if (reqBO.getRequiredFlag() == null) {
            errMsg = "\u662f\u5426\u5fc5\u586b\u9879\u5fc5\u4f20";
        }
        if (reqBO.getMultiFlag() == null) {
            errMsg = "\u662f\u5426\u591a\u9009\u9879\u5fc5\u4f20";
        }
        if (reqBO.getPropertyLink() == null) {
            errMsg = "\u5426\u5173\u8054\u9879\u5fc5\u4f20";
        }
        if ("".equals(errMsg)) {
            errMsg = this.enumVerify(reqBO);
        }
        return errMsg;
    }

    private String enumVerify(UccAddAttributesReqBO reqBO) {
        String errMsg = "";
        Map<String, String> map = null;
        if (reqBO.getPropTag() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_PROP_TAG.toString())).containsKey(reqBO.getPropTag().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 propTag\u503c";
        }
        if (reqBO.getPropType() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_PROP_TYPE.toString())).containsKey(reqBO.getPropType().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 propType";
        }
        if (reqBO.getInputType() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_INPUT_TYPE.toString())).containsKey(reqBO.getInputType().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 inputType";
        }
        if (reqBO.getFilterFlag() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_FILTER_FLAG.toString())).containsKey(reqBO.getFilterFlag().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 filterFlag\u503c";
        }
        if (reqBO.getRequiredFlag() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_REQUIRED_FLAG.toString())).containsKey(reqBO.getRequiredFlag().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 requiredFlag \u503c";
        }
        if (reqBO.getMultiFlag() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_MULTI_FLAG.toString())).containsKey(reqBO.getMultiFlag().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 multiFlag \u503c";
        }
        if (reqBO.getPropertyLink() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityPropDefEnum.COMMODITY_PROP_DEF_PROPERTY_LINK.toString())).containsKey(reqBO.getPropertyLink().toString())) {
            errMsg = "\u8bf7\u8f93\u5165\u6b63\u786e\u7684 propertyLink \u503c";
        }
        return errMsg;
    }
}

