/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.bo.busi.ApprovalPassReqBO;
import com.tydic.commodity.bo.busi.ApprovalPassRspBO;
import com.tydic.commodity.bo.busi.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.bo.busi.ProcessStepGroupReqBO;
import com.tydic.commodity.bo.busi.ProcessStepGroupRspBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.busi.api.UccApprovalPassService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccApprovalPassService.class)
public class UccApprovalPassServiceImpl
implements UccApprovalPassService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccApprovalPassServiceImpl.class);
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService auditOrderAuditAbilityService;
    @Value(value="${PROCESS_DEF_ID}")
    private String processDefId;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Reference(interfaceClass=BatchUpdateCommoStatusForMarketService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private BatchUpdateCommoStatusForMarketService statusForMarketService;

    public ApprovalPassRspBO approvalPass(ApprovalPassReqBO approvalPassReqBO) {
        ApprovalPassRspBO approvalPassRspBO = new ApprovalPassRspBO();
        try {
            ValidatorUtil.validator((Object)approvalPassReqBO);
        }
        catch (BusinessException e) {
            approvalPassRspBO.setRespDesc(e.getMsgInfo());
            approvalPassRspBO.setRespCode("8888");
            return approvalPassRspBO;
        }
        if (CollectionUtils.isEmpty((Collection)approvalPassReqBO.getCommodityId())) {
            approvalPassRspBO.setRespCode("8888");
            approvalPassRspBO.setRespDesc("\u5546\u54c1ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return approvalPassRspBO;
        }
        if (approvalPassReqBO.getUsername() == null) {
            approvalPassRspBO.setRespCode("8888");
            approvalPassRspBO.setRespDesc("\u64cd\u4f5c\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            return approvalPassRspBO;
        }
        ProcessStepGroupReqBO processStepGroupReqBO = new ProcessStepGroupReqBO();
        processStepGroupReqBO.setCommodityIds(approvalPassReqBO.getCommodityId());
        ProcessStepGroupRspBO processStepGroupRspBO = this.processStepGroup(processStepGroupReqBO);
        HashMap<String, String> ext = new HashMap<String, String>(1);
        ext.put("dealStepName", "\u5ba1\u6838\u901a\u8fc7");
        UacNoTaskAuditOrderAuditReqBO uocAuditAbilityAuditReqBO = null;
        try {
            for (Map.Entry stringListEntry : processStepGroupRspBO.getCommodityIdMaps().entrySet()) {
                UacNoTaskAuditOrderAuditRspBO uocAuditAbilityAuditRspBO;
                uocAuditAbilityAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
                uocAuditAbilityAuditReqBO.setObjType(Integer.valueOf(2));
                uocAuditAbilityAuditReqBO.setObjId((List)stringListEntry.getValue());
                uocAuditAbilityAuditReqBO.setStepId((String)stringListEntry.getKey());
                uocAuditAbilityAuditReqBO.setAuditResult(Integer.valueOf(1));
                uocAuditAbilityAuditReqBO.setOperId(approvalPassReqBO.getUsername());
                uocAuditAbilityAuditReqBO.setUsername(approvalPassReqBO.getUsername());
                uocAuditAbilityAuditReqBO.setExt(ext);
                LOGGER.info("\u5ba1\u6838\u4fe1\u606f\uff1a" + JSON.toJSON((Object)uocAuditAbilityAuditReqBO) + "");
                try {
                    uocAuditAbilityAuditRspBO = this.auditOrderAuditAbilityService.dealAudit(uocAuditAbilityAuditReqBO);
                    LOGGER.info("\u5ba1\u6838\u540c\u6b65\u54cd\u5e94\u6570\u636e\uff1a" + JSON.toJSON((Object)uocAuditAbilityAuditRspBO));
                }
                catch (BusinessException e) {
                    LOGGER.error("\u5904\u7406\u6d41\u7a0b\u5f02\u5e38\uff0c\u539f\u56e0\uff1a" + (Object)((Object)e));
                    approvalPassRspBO.setRespCode("8888");
                    approvalPassRspBO.setRespDesc(e.getMsgInfo());
                    return approvalPassRspBO;
                }
                if ("0000".equals(uocAuditAbilityAuditRspBO.getRespCode())) {
                    try {
                        UccCommodityPo uccCommodityPo = new UccCommodityPo();
                        uccCommodityPo.setApprovalStatus(uocAuditAbilityAuditRspBO.getNoneInstanceBO().getStepId());
                        this.uccCommodityMapper.batchUpdateById((List)stringListEntry.getValue(), uccCommodityPo);
                    }
                    catch (Exception e) {
                        LOGGER.error("\u53d8\u66f4\u5ba1\u6838\u72b6\u6001\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
                        approvalPassRspBO.setRespCode("8888");
                        approvalPassRspBO.setRespDesc("\u53d8\u66f4\u5ba1\u6838\u72b6\u6001\u5931\u8d25");
                        return approvalPassRspBO;
                    }
                    if (!uocAuditAbilityAuditRspBO.getNoneInstanceBO().getFinish().booleanValue()) continue;
                    BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
                    Long[] businessId = new Long[((List)stringListEntry.getValue()).size()];
                    for (int i = 0; i < ((List)stringListEntry.getValue()).size(); ++i) {
                        businessId[i] = (Long)((List)stringListEntry.getValue()).get(i);
                    }
                    batchUpdateCommoStatusForMarketBO.setReason("\u7535\u5546\u4e0a\u67b6\u5ba1\u6279");
                    batchUpdateCommoStatusForMarketBO.setBusinessId(businessId);
                    this.statusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.EFFECTIVE_STATUS, SkuStatusEnum.ON_SHELVES_STATUS);
                    continue;
                }
                LOGGER.error("\u5904\u7406\u6d41\u7a0b\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + uocAuditAbilityAuditRspBO.getRespDesc());
                approvalPassRspBO.setRespCode("8888");
                approvalPassRspBO.setRespDesc(uocAuditAbilityAuditRspBO.getRespDesc());
                return approvalPassRspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5ba1\u6838\u5546\u54c1\uff0c\u5904\u7406\u6d41\u7a0b\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
            approvalPassRspBO.setRespCode("8888");
            approvalPassRspBO.setRespDesc(e.getMessage());
            return approvalPassRspBO;
        }
        approvalPassRspBO.setRespCode("0000");
        approvalPassRspBO.setRespDesc("\u6210\u529f");
        return approvalPassRspBO;
    }

    public ProcessStepGroupRspBO processStepGroup(ProcessStepGroupReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityIds())) {
            throw new BusinessException("8888", "\u5546\u54c1id \u6570\u636e\u4e3a\u7a7a");
        }
        ProcessStepGroupRspBO processStepGroupRspBO = new ProcessStepGroupRspBO();
        List<UccCommodityPo> uccCommodityPoList = this.uccCommodityMapper.queryByCommodityIdLists(reqBO.getCommodityIds());
        List commodityPos = uccCommodityPoList.stream().filter(poList -> poList.getApprovalStatus() == null).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(commodityPos)) {
            throw new BusinessException("8888", "\u5ba1\u6279\u72b6\u6001\u4e3a\u7a7a,\u6570\u636e\u4e0d\u80fd\u5904\u7406");
        }
        Map<String, List<UccCommodityPo>> commodityMaps = uccCommodityPoList.stream().filter(poList -> poList.getApprovalStatus() != null).collect(Collectors.groupingBy(UccCommodityPo::getApprovalStatus));
        HashMap commodityIdMaps = new HashMap(commodityMaps.size());
        for (Map.Entry<String, List<UccCommodityPo>> stringListEntry : commodityMaps.entrySet()) {
            List commodityids = stringListEntry.getValue().stream().map(UccCommodityPo::getCommodityId).collect(Collectors.toList());
            commodityIdMaps.put(stringListEntry.getKey(), commodityids);
        }
        processStepGroupRspBO.setCommodityIdMaps(commodityIdMaps);
        return processStepGroupRspBO;
    }
}

