/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccBrandDateBO;
import com.tydic.commodity.bo.busi.UccBrandSelectReqBO;
import com.tydic.commodity.bo.busi.UccBrandSelectRspBO;
import com.tydic.commodity.busi.api.UccBrandSelectBusiService;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.enumType.Brand;
import com.tydic.commodity.exception.BusinessException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccBrandSelectBusiService.class)
public class UccBrandSelectBusiServiceImpl
implements UccBrandSelectBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccBrandSelectBusiServiceImpl.class);
    @Autowired
    private UccBrandDealMapper mapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    UccBrandSelectRspBO rspBO = new UccBrandSelectRspBO();

    public UccBrandSelectRspBO selectBrand(UccBrandSelectReqBO reqBO) {
        log.info("UccBrandSelectBusiService::selectBrand\u5165\u53c2::reqBO=" + reqBO);
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRows(null);
            return this.rspBO;
        }
        this.rspBO = new UccBrandSelectRspBO();
        UccBrandDealPO brandDealPO = new UccBrandDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)brandDealPO);
        Page page = new Page();
        log.info("UccBrandSelectBusiService:\u67e5\u8be2\u54c1\u724c\u5165\u53c2page\u5bf9\u8c61\u8d4b\u503c:reqBO.getPageSize()=" + reqBO.getPageSize());
        log.info("UccBrandSelectBusiService:\u67e5\u8be2\u54c1\u724c\u5165\u53c2page\u5bf9\u8c61\u8d4b\u503c:reqBO.getPageNo()=" + reqBO.getPageNo());
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getPageNo());
        List<UccBrandDealPO> result = null;
        try {
            result = this.mapper.selectBrandNew(brandDealPO, (Page<UccBrandDealPO>)page);
        }
        catch (Exception e2) {
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u67e5\u8be2\u5f02\u5e38");
        }
        if (result != null && result.size() > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u6210\u529f");
            log.info("UccBrandSelectBusiService::mapper.selectBrand::result.size()=" + result.size());
            List dataList = result.stream().map(e -> {
                UccBrandDateBO nodeLogBO = new UccBrandDateBO();
                BeanUtils.copyProperties((Object)e, (Object)nodeLogBO);
                return nodeLogBO;
            }).collect(Collectors.toList());
            log.info("UccBrandSelectBusiService::mapper.selectBrand::page.getPageNo()=" + page.getPageNo());
            log.info("UccBrandSelectBusiService::mapper.selectBrand::page.getTotalCount()=" + page.getTotalCount());
            log.info("UccBrandSelectBusiService::mapper.selectBrand::page.getTotalPages()=" + page.getTotalPages());
            this.rspBO.setPageNo(page.getPageNo());
            this.rspBO.setRecordsTotal(page.getTotalCount());
            this.rspBO.setTotal(page.getTotalPages());
            this.rspBO.setRows(dataList);
        } else {
            this.rspBO.setRows(null);
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u54c1\u724c\u4fe1\u606f\u6210\u529f");
        }
        log.info("UccBrandSelectBusiService::selectBrand\u51fa\u53c2::rspBO=" + this.rspBO);
        return this.rspBO;
    }

    public boolean judge(UccBrandSelectReqBO reqBO) {
        Map<String, String> map = null;
        log.info("UccBrandSelectBusiService::judge\u65b9\u6cd5::reqBO.getBrandStatus()=" + reqBO.getBrandStatus());
        if (reqBO.getBrandStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(Brand.BRAND_STATUS.toString())).containsKey(String.valueOf(reqBO.getBrandStatus()))) {
            this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u54c1\u724c\u72b6\u6001");
            return false;
        }
        return true;
    }
}

