/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccCatalogUpdateReqBO;
import com.tydic.commodity.bo.busi.UccCatalogUpdateRspBO;
import com.tydic.commodity.busi.api.UccCatalogUpdateBusiService;
import com.tydic.commodity.busi.impl.UccCatalogAddBusiServiceImpl;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.enumType.GuideCatalogEnum;
import com.tydic.commodity.exception.BusinessException;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccCatalogUpdateBusiService.class)
public class UccCatalogUpdateBusiServiceImpl
implements UccCatalogUpdateBusiService {
    @Autowired
    private UccCatalogDealMapper mapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCatalogAddBusiServiceImpl.class);
    UccCatalogUpdateRspBO rspBO = new UccCatalogUpdateRspBO();

    public UccCatalogUpdateRspBO updateCatalog(UccCatalogUpdateReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        if (reqBO.getViewOrder() != null) {
            this.modifyOrder(reqBO);
        }
        this.rspBO = new UccCatalogUpdateRspBO();
        UccCatalogDealPO catalogDealPO = new UccCatalogDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)catalogDealPO);
        int result = 0;
        try {
            result = this.mapper.updateCatalog(catalogDealPO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u4fee\u6539\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (result > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u4fee\u6539\u7c7b\u76ee\u6210\u529f");
        } else {
            this.rspBO.setRespCode("8888");
            this.rspBO.setRespDesc("\u4fee\u6539\u7c7b\u76ee\u5931\u8d25");
        }
        return this.rspBO;
    }

    public boolean judge(UccCatalogUpdateReqBO reqBO) {
        Map<String, String> map = null;
        if (reqBO.getGuideCatalogId() == null) {
            this.rspBO.setRespDesc("\u7c7b\u76eeID\u4e0d\u80fd\u4e3a\u7a7a");
            return false;
        }
        UccCatalogDealPO po = new UccCatalogDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        if (this.mapper.selectCatalogById(po) == null) {
            this.rspBO.setRespDesc("\u7c7b\u76eeID\u4e0d\u5b58\u5728");
            return false;
        }
        if (reqBO.getCatalogStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(GuideCatalogEnum.GUIDE_CATALOG_STATUS.toString())).containsKey(String.valueOf(reqBO.getCatalogStatus()))) {
            this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u72b6\u6001");
            return false;
        }
        return true;
    }

    public void modifyOrder(UccCatalogUpdateReqBO reqBO) {
        try {
            UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
            uccCatalogDealPO.setGuideCatalogId(reqBO.getGuideCatalogId());
            uccCatalogDealPO = this.mapper.selectCatalogById(uccCatalogDealPO);
            if (uccCatalogDealPO != null) {
                Integer viewOrder = uccCatalogDealPO.getViewOrder();
                if (reqBO.getOrderConfSolution() != null) {
                    uccCatalogDealPO = new UccCatalogDealPO();
                    uccCatalogDealPO.setUpperCatalogId(reqBO.getUpperCatalogId());
                    uccCatalogDealPO.setViewOrder(reqBO.getViewOrder());
                    uccCatalogDealPO.setChannelId(reqBO.getChannelId());
                    if (reqBO.getOrderConfSolution() == 0) {
                        this.mapper.modifyOrder(uccCatalogDealPO);
                    } else if (reqBO.getOrderConfSolution() == 1) {
                        this.mapper.modifyOrderByViewOrder(reqBO.getViewOrder(), viewOrder, uccCatalogDealPO);
                    } else {
                        reqBO.setViewOrder(null);
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }
}

