/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccChannelAddReqBO;
import com.tydic.commodity.bo.busi.UccChannelAddRspBO;
import com.tydic.commodity.busi.api.UccChannelAddBusiService;
import com.tydic.commodity.dao.UccChannelDealMapper;
import com.tydic.commodity.dao.po.UccChannelDealPO;
import com.tydic.commodity.enumType.Channel;
import com.tydic.commodity.exception.BusinessException;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccChannelAddBusiService.class)
public class UccChannelAddBusiServiceImpl
implements UccChannelAddBusiService {
    @Autowired
    private UccChannelDealMapper mapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    private Sequence uccBrandSequence = Sequence.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(UccChannelAddBusiServiceImpl.class);

    public UccChannelAddRspBO addChannel(UccChannelAddReqBO reqBO) {
        UccChannelAddRspBO rspBO = new UccChannelAddRspBO();
        UccChannelDealPO channelDealPO = new UccChannelDealPO();
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(s);
            return rspBO;
        }
        BeanUtils.copyProperties((Object)reqBO, (Object)channelDealPO);
        int result = 0;
        try {
            channelDealPO.setChannelId(this.uccBrandSequence.nextId());
            Integer maxOrder = this.mapper.queryMaxOrder();
            if (channelDealPO.getViewOrder() == null) {
                channelDealPO.setViewOrder(maxOrder + 1);
            }
            result = this.mapper.addChannel(channelDealPO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u6dfb\u52a0\u5f02\u5e38");
        }
        if (result > 0) {
            rspBO.setChannelId(channelDealPO.getChannelId());
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u63d2\u5165\u9891\u9053\u6210\u529f");
        } else {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u63d2\u5165\u9891\u9053\u5931\u8d25");
        }
        return rspBO;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String judge(UccChannelAddReqBO reqBO) {
        List<UccChannelDealPO> result;
        String s = "";
        if (reqBO.getChannelName() == null) return "\u63d2\u5165\u9891\u9053\u540d\u4e0d\u80fd\u4e3a\u7a7a";
        if (reqBO.getChannelName().equals("")) {
            return "\u63d2\u5165\u9891\u9053\u540d\u4e0d\u80fd\u4e3a\u7a7a";
        }
        if (!reqBO.getChannelName().matches("^[\u4e00-\u9fa5a-zA-Z0-9]+$")) {
            return "\u9891\u9053\u540d\u79f0\u4e0d\u89c4\u8303\uff0c\u53ea\u80fd\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e2d\u6587\u7ec4\u6210";
        }
        if (reqBO.getChannelCode() == null) return "\u63d2\u5165\u9891\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        if (reqBO.getChannelCode().equals("")) return "\u63d2\u5165\u9891\u9053\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a";
        String code = reqBO.getChannelCode();
        UccChannelDealPO channelDealPO = new UccChannelDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)channelDealPO);
        try {
            result = this.mapper.selectByChannelCode(channelDealPO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u67e5\u8be2\u6570\u636e\u5f02\u5e38");
        }
        if (result.size() != 0) {
            if (result != null) return "\u9891\u9053\u7f16\u7801\u5df2\u5b58\u5728";
        }
        if (!code.matches("^[0-9a-zA-Z_]+$")) {
            return "\u9891\u9053\u7f16\u7801\u4e0d\u89c4\u8303\uff0c\u53ea\u80fd\u7531\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\u7ec4\u6210";
        }
        if (reqBO.getChannelStatus() == null) {
            return "\u9891\u9053\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a";
        }
        Map<String, String> map = this.uccDictionaryAtomService.queryBypCodeBackMap(Channel.CHANNEL_STATUS.toString());
        if (map.containsKey(String.valueOf(reqBO.getChannelStatus()))) return s;
        return "\u8bf7\u8f93\u5165\u6b63\u786e\u72b6\u6001";
    }
}

