/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccChannelDateBO;
import com.tydic.commodity.bo.busi.UccChannelSelectReqBO;
import com.tydic.commodity.bo.busi.UccChannelSelectRspBO;
import com.tydic.commodity.busi.api.UccChannelSelectBusiService;
import com.tydic.commodity.dao.UccChannelDealMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccChannelDealPO;
import com.tydic.commodity.enumType.Channel;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccChannelSelectBusiService.class)
public class UccChannelSelectBusiServiceImpl
implements UccChannelSelectBusiService {
    @Autowired
    private UccChannelDealMapper mapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccChannelSelectBusiServiceImpl.class);
    UccChannelSelectRspBO rspBO = new UccChannelSelectRspBO();

    public UccChannelSelectRspBO selectChannel(UccChannelSelectReqBO reqBO) {
        if (!this.judge(reqBO)) {
            this.rspBO.setRespCode("8888");
            return this.rspBO;
        }
        this.rspBO = new UccChannelSelectRspBO();
        UccChannelDealPO channelDealPO = new UccChannelDealPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)channelDealPO);
        Page page = new Page();
        page.setPageSize(reqBO.getPageSize());
        page.setPageNo(reqBO.getPageNo());
        List<UccChannelDealPO> result = null;
        try {
            result = this.mapper.selectChannel(channelDealPO, page);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u6570\u636e\u5e93\u67e5\u8be2\u5f02\u5e38");
        }
        if (result != null && result.size() > 0) {
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u9891\u9053\u4fe1\u606f\u6210\u529f");
            ArrayList<UccChannelDateBO> dataList = new ArrayList<UccChannelDateBO>();
            DicDictionaryPo dicDictionaryPo = null;
            UccChannelDateBO result1 = null;
            for (UccChannelDealPO po : result) {
                result1 = new UccChannelDateBO();
                BeanUtils.copyProperties((Object)po, (Object)result1);
                dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(String.valueOf(po.getChannelStatus()), Channel.CHANNEL_STATUS.toString());
                if (dicDictionaryPo != null) {
                    result1.setChannelStatusTranslation(dicDictionaryPo.getTitle());
                }
                dataList.add(result1);
            }
            this.rspBO.setPageNo(page.getPageNo());
            this.rspBO.setRecordsTotal(page.getTotalCount());
            this.rspBO.setTotal(page.getTotalPages());
            this.rspBO.setRows(dataList);
        } else {
            this.rspBO.setRows(null);
            this.rspBO.setRespCode("0000");
            this.rspBO.setRespDesc("\u67e5\u8be2\u9891\u9053\u4fe1\u606f\u6210\u529f");
        }
        return this.rspBO;
    }

    public boolean judge(UccChannelSelectReqBO reqBO) {
        Map<String, String> map = null;
        if (reqBO.getChannelStatus() != null && !(map = this.uccDictionaryAtomService.queryBypCodeBackMap(Channel.CHANNEL_STATUS.toString())).containsKey(String.valueOf(reqBO.getChannelStatus()))) {
            this.rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u72b6\u6001");
            return false;
        }
        return true;
    }
}

