/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.busi.UccCommodityBaseInfoUpdateReqBO;
import com.tydic.commodity.bo.busi.UccCommodityBaseInfoUpdateRspBO;
import com.tydic.commodity.busi.api.UccCommodityBaseInfoUpdateBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityLogMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityLogPO;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccCommodityBaseInfoUpdateBusiService.class)
public class UccCommodityBaseInfoUpdateBusiServiceImpl
implements UccCommodityBaseInfoUpdateBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityBaseInfoUpdateBusiServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityLogMapper commodityLogMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();

    public UccCommodityBaseInfoUpdateRspBO updateCommodityInfo(UccCommodityBaseInfoUpdateReqBO reqBO) {
        List<SupplierShopPo> supplierShopPos;
        UccCommodityBaseInfoUpdateRspBO rspBO = new UccCommodityBaseInfoUpdateRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMsgInfo());
            return rspBO;
        }
        UccCommodityPo commodityPo = new UccCommodityPo();
        commodityPo.setCommodityId(reqBO.getCommodityId());
        commodityPo.setFreeFhipping(reqBO.getFreeShipping());
        commodityPo.setFreightPrice(reqBO.getFreightPrice());
        commodityPo.setViewOrder(reqBO.getViewOrder());
        commodityPo.setSupplierShopId(reqBO.getShopId());
        commodityPo.setCommodityName(reqBO.getCommodityName());
        commodityPo.setCommodityPhoneDetailChar(reqBO.getCommodityDetail());
        if (null != reqBO.getOrgIdIn() && CollectionUtils.isNotEmpty(supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getOrgIdIn()))) {
            commodityPo.setSupplierShopId(supplierShopPos.get(0).getSupplierShopId());
        }
        Long batchId = null;
        batchId = this.uccBatchSequence.nextId();
        try {
            this.uccCommodityMapper.updateCommodity(commodityPo);
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(reqBO.getCommodityId());
            UccCommodityLogPO commodityLogPO = new UccCommodityLogPO();
            commodityLogPO.setBatchId(batchId);
            BeanUtils.copyProperties((Object)uccCommodityPo, (Object)commodityLogPO);
            this.commodityLogMapper.insert(commodityLogPO);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

