/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.atom.UccSkuUpLogAtomService;
import com.tydic.commodity.atom.bo.UccSkuUpLogReqBO;
import com.tydic.commodity.atom.bo.UccSkuUpLogRspBO;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccCommodityDownReqBO;
import com.tydic.commodity.bo.busi.UccCommodityDownRspBO;
import com.tydic.commodity.bo.busi.UccCommodityUpRspBO;
import com.tydic.commodity.busi.api.UccCommodityDownBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPutCirPo;
import com.tydic.commodity.enumType.SkuPutCirEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccCommodityDownBusiService.class)
public class UccCommodityDownBusiServiceImpl
implements UccCommodityDownBusiService {
    @Autowired
    private UccSkuUpLogAtomService uccSkuUpLogAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityDownBusiServiceImpl.class);
    private Sequence coefficientSequence = Sequence.getInstance();
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    public UccCommodityDownRspBO dealCommodityDown(UccCommodityDownReqBO reqBO) {
        UccCommodityDownRspBO rspBO = new UccCommodityDownRspBO();
        String s = this.judge(reqBO);
        if (!"".equals(s)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(s);
            return rspBO;
        }
        List skuIds = reqBO.getSkuIds();
        try {
            String s1 = this.addLog(reqBO);
            if (!"".equals(s1)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc(s1);
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new ZTBusinessException("\u6dfb\u52a0\u65e5\u5fd7\u5f02\u5e38");
        }
        for (Long skuId : skuIds) {
            List<UccSkuPutCirPo> CirPoList;
            UccSkuPutCirPo skuPutCirPo = new UccSkuPutCirPo();
            skuPutCirPo.setState(1);
            reqBO.setSkuId(skuId);
            skuPutCirPo.setSkuId(skuId);
            boolean i = false;
            try {
                CirPoList = this.uccSkuPutCirMapper.querySkuPutCir(skuPutCirPo);
            }
            catch (Exception e) {
                throw new ZTBusinessException(e.getMessage());
            }
            if (CirPoList.size() != 0) {
                UccSkuPutCirPo cirPoResult = CirPoList.get(0);
                BeanUtils.copyProperties((Object)cirPoResult, (Object)skuPutCirPo);
                skuPutCirPo.setDownType(reqBO.getDownType());
                skuPutCirPo.setRealDownTime(new Date());
                skuPutCirPo.setState(1);
            } else {
                skuPutCirPo.setDownType(reqBO.getDownType());
                skuPutCirPo.setRealDownTime(new Date());
                skuPutCirPo.setState(1);
                skuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
                skuPutCirPo.setSkuId(skuId);
            }
            try {
                UccSkuPutCirPo oldCirPo = new UccSkuPutCirPo();
                oldCirPo.setState(2);
                oldCirPo.setSkuId(skuId);
                oldCirPo.setSupplierShopId(reqBO.getSupplierShopId());
                if (CirPoList != null && CirPoList.size() != 0) {
                    try {
                        this.uccSkuPutCirMapper.modifyBySkuId(oldCirPo);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                        throw new ZTBusinessException("\u4fee\u6539\u539f\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u6570\u636e\u5f02\u5e38");
                    }
                }
                try {
                    skuPutCirPo.setId(this.coefficientSequence.nextId());
                    this.uccSkuPutCirMapper.addSkuPutCir(skuPutCirPo);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new ZTBusinessException(e.getMessage());
                }
            }
            catch (IllegalArgumentException e) {
                LOGGER.error(e.getMessage());
                throw new ZTBusinessException(e.getMessage());
            }
            if (this.modifySkuStatus(reqBO)) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5355\u54c1\u72b6\u6001\u4fee\u6539\u5931\u8d25");
            return rspBO;
        }
        ArrayList<Long> skus = new ArrayList<Long>();
        skus.add(reqBO.getSkuId());
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds(skus);
        syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierShopId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
        this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u5546\u54c1\u4e0b\u67b6\u6210\u529f");
        return rspBO;
    }

    public String judge(UccCommodityDownReqBO reqBO) {
        String s = "";
        if (reqBO != null) {
            Map<String, String> map;
            if (reqBO.getSkuIds().size() == 0) {
                s = "\u8bf7\u9009\u62e9\u5355\u54c1";
                return s;
            }
            if (reqBO.getSupplierShopId() == null) {
                s = "\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a";
                return s;
            }
            List skuIds = reqBO.getSkuIds();
            UccSkuPo skuPo = new UccSkuPo();
            skuPo.setSupplierShopId(reqBO.getSupplierShopId());
            for (Long skuId : skuIds) {
                skuPo.setSkuId(skuId);
                List<UccSkuPo> skuPos = this.uccSkuMapper.qerySku(skuPo);
                if (skuPos.size() <= 0 || skuPos.get(0).getSkuStatus() == 3) continue;
                s = "\u6b64\u5355\u54c1ID" + skuId + "\u5355\u54c1\u72b6\u6001\u4e0d\u4e3a\u5df2\u4e0a\u67b6";
                return s;
            }
            if (!(reqBO.getDownType() == null || (map = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuPutCirEnum.DOWN_TYPE.toString())) != null && map.containsKey(String.valueOf(reqBO.getDownType())))) {
                s = "\u4e0b\u67b6\u65b9\u5f0f\u9519\u8bef";
                return s;
            }
        } else {
            s = "\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a";
            return s;
        }
        return s;
    }

    public boolean modifySkuStatus(UccCommodityDownReqBO reqBO) {
        if (reqBO != null) {
            UccCommodityUpRspBO rspBO = new UccCommodityUpRspBO();
            UccSkuPo skuPo = new UccSkuPo();
            skuPo.setSupplierShopId(reqBO.getSupplierShopId());
            skuPo.setSkuStatus(5);
            skuPo.setSkuId(reqBO.getSkuId());
            skuPo.setRemark(reqBO.getReason());
            int i = 0;
            try {
                i = this.uccSkuMapper.modifySku(skuPo);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u4fee\u6539\u5355\u54c1\u72b6\u6001\u5f02\u5e38");
            }
            if (i == 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5355\u54c1\u72b6\u6001\u4fee\u6539\u5931\u8d25");
                return false;
            }
        }
        return true;
    }

    public String addLog(UccCommodityDownReqBO reqBO) {
        String s = "";
        UccSkuUpLogReqBO logReqBO = new UccSkuUpLogReqBO();
        logReqBO.setSupplierShopId(reqBO.getSupplierShopId());
        logReqBO.setSkuIds(reqBO.getSkuIds());
        logReqBO.setReason(reqBO.getReason());
        UccSkuUpLogRspBO logRspBO = null;
        try {
            logRspBO = this.uccSkuUpLogAtomService.dealSkuUpLog(logReqBO);
            if ("8888".equals(logRspBO.getRespCode())) {
                s = logRspBO.getRespDesc();
            }
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
        return s;
    }
}

