/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.busi.CommodityPicDeleteReqBO;
import com.tydic.commodity.bo.busi.CommodityPicDeleteRspBO;
import com.tydic.commodity.busi.api.UccCommodityPicDeleteBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccCommodityPicDeleteBusiService.class)
public class UccCommodityPicDeleteBusiServiceImpl
implements UccCommodityPicDeleteBusiService {
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    public CommodityPicDeleteRspBO deleteCommodityPic(CommodityPicDeleteReqBO reqBO) {
        Object supplierShopPos;
        CommodityPicDeleteRspBO rspBO = new CommodityPicDeleteRspBO();
        try {
            ValidatorUtil.validator((Object)reqBO);
        }
        catch (BusinessException e) {
            rspBO.setRespCode("8888");
            rspBO.setRespCode(e.getMsgInfo());
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityPicId())) {
            rspBO.setRespCode("8888");
            rspBO.setRespCode("\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null != reqBO.getOrgIdIn() && CollectionUtils.isNotEmpty((Collection)(supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getOrgIdIn())))) {
            reqBO.setSupplierShopId(((SupplierShopPo)supplierShopPos.get(0)).getSupplierShopId());
        }
        try {
            for (Long commodityPicId : reqBO.getCommodityPicId()) {
                this.uccCommodityPicMapper.deleteByPrimaryKey(commodityPicId, reqBO.getSupplierShopId());
            }
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespCode("\u5220\u9664\u56fe\u7247\u5931\u8d25");
            return rspBO;
        }
        rspBO.setRespCode("0000");
        rspBO.setRespCode("\u6210\u529f");
        return rspBO;
    }
}

