/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.atom.BO.UccDealSkuDetailReqBO;
import com.tydic.commodity.atom.BO.UccDealSkuDetailRespBO;
import com.tydic.commodity.atom.BO.UccDealSkuPriceReqBO;
import com.tydic.commodity.atom.BO.UccDealSkuPriceRespBO;
import com.tydic.commodity.atom.UccDealSkuDetailAtomService;
import com.tydic.commodity.atom.UccDealSkuPriceAtomService;
import com.tydic.commodity.busi.UccDealSkuExternalBusiService;
import com.tydic.commodity.busi.bo.UccDealSkuExternalBusiReqBO;
import com.tydic.commodity.busi.bo.UccDealSkuExternalBusiRspBO;
import com.tydic.commodity.exception.BusinessException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class UccDealSkuExternalBusiServiceImpl
implements UccDealSkuExternalBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccDealSkuExternalBusiServiceImpl.class);
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private UccDealSkuDetailAtomService uccDealSkuDetailAtomService;
    @Autowired
    private UccDealSkuPriceAtomService uccDealSkuPriceAtomService;
    private static final String SUCCESS_RESP_CODE = "0000";
    private static final String ERROR_RESP_CODE = "8888";

    @Override
    public UccDealSkuExternalBusiRspBO dealSkuDetailExternal(UccDealSkuExternalBusiReqBO reqBO) {
        UccDealSkuExternalBusiRspBO rspBO = new UccDealSkuExternalBusiRspBO();
        try {
            UccDealSkuDetailReqBO uccDealSkuDetailReqBO = new UccDealSkuDetailReqBO();
            uccDealSkuDetailReqBO.setJdbcTemplate(this.jdbcTemplate);
            uccDealSkuDetailReqBO.setSkuCodeList(reqBO.getSkuList());
            uccDealSkuDetailReqBO.setSkuListStr(this.buildSkuIdList(reqBO.getSkuList()));
            uccDealSkuDetailReqBO.setSupplierCode(reqBO.getSupplierCode());
            UccDealSkuDetailRespBO uccDealSkuDetailRespBO = this.uccDealSkuDetailAtomService.dealSkuDetail(uccDealSkuDetailReqBO);
            if (!SUCCESS_RESP_CODE.equals(uccDealSkuDetailRespBO.getRespCode())) {
                throw new BusinessException(ERROR_RESP_CODE, "\u83b7\u53d6\u5546\u54c1\u8be6\u60c5\u5931\u8d25:" + uccDealSkuDetailRespBO.getRespDesc());
            }
        }
        catch (BusinessException e) {
            throw new BusinessException(ERROR_RESP_CODE, e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException(ERROR_RESP_CODE, "\u5904\u7406\u5546\u54c1\u5916\u90e8\u63a5\u53e3\u5931\u8d25!");
        }
        rspBO.setRespCode(SUCCESS_RESP_CODE);
        rspBO.setRespDesc("\u5904\u7406\u5546\u54c1\u5916\u90e8\u63a5\u53e3\u6210\u529f");
        return rspBO;
    }

    @Override
    public UccDealSkuExternalBusiRspBO dealSkuPriceExternal(UccDealSkuExternalBusiReqBO reqBO) {
        UccDealSkuExternalBusiRspBO rspBO = new UccDealSkuExternalBusiRspBO();
        try {
            UccDealSkuPriceReqBO uccDealSkuPriceReqBO = new UccDealSkuPriceReqBO();
            uccDealSkuPriceReqBO.setJdbcTemplate(this.jdbcTemplate);
            uccDealSkuPriceReqBO.setSkuCodeList(reqBO.getSkuList());
            uccDealSkuPriceReqBO.setSkuListStr(this.buildSkuIdList(reqBO.getSkuList()));
            uccDealSkuPriceReqBO.setSupplierCode(reqBO.getSupplierCode());
            UccDealSkuPriceRespBO uccDealSkuPriceRespBO = this.uccDealSkuPriceAtomService.dealSkuPrice(uccDealSkuPriceReqBO);
            if (!SUCCESS_RESP_CODE.equals(uccDealSkuPriceRespBO.getRespCode())) {
                throw new BusinessException(ERROR_RESP_CODE, "\u83b7\u53d6\u5546\u54c1\u4ef7\u683c\u5931\u8d25:" + uccDealSkuPriceRespBO.getRespDesc());
            }
        }
        catch (BusinessException e) {
            throw new BusinessException(ERROR_RESP_CODE, e.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage());
            throw new BusinessException(ERROR_RESP_CODE, "\u5904\u7406\u5546\u54c1\u5916\u90e8\u63a5\u53e3\u5931\u8d25!");
        }
        rspBO.setRespCode(SUCCESS_RESP_CODE);
        rspBO.setRespDesc("\u5904\u7406\u5546\u54c1\u5916\u90e8\u63a5\u53e3\u6210\u529f");
        return rspBO;
    }

    private String buildSkuIdList(List<String> skuList) {
        StringBuilder builder = new StringBuilder();
        if (CollectionUtils.isEmpty(skuList)) {
            return null;
        }
        if (skuList.size() == 1) {
            builder.append("'");
            builder.append(skuList.get(0));
            builder.append("'");
        } else {
            for (int i = 0; i < skuList.size(); ++i) {
                if (i != skuList.size() - 1) {
                    builder.append("'");
                    builder.append(skuList.get(i));
                    builder.append("'");
                    builder.append(",");
                    continue;
                }
                builder.append("'");
                builder.append(skuList.get(i));
                builder.append("'");
            }
        }
        return builder.toString();
    }
}

