/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.bo.UmcStationWebBO;
import com.tydic.commodity.bo.busi.ApprovalAuthorBO;
import com.tydic.commodity.bo.busi.ApprovalCommoAuthor;
import com.tydic.commodity.bo.busi.EclCommdQryListReqBo;
import com.tydic.commodity.bo.busi.EclCommdQryListRspBo;
import com.tydic.commodity.bo.busi.UccQryCommodityForEclBO;
import com.tydic.commodity.busi.api.ApprovalCommoAuthorService;
import com.tydic.commodity.busi.api.UccElcCommdQryListBusiservice;
import com.tydic.commodity.dao.UccCommodityLogMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.UccCommodityLogPO;
import com.tydic.commodity.dao.po.UccQryCommodityForEclPO;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.ListCloneUtils;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uac.ability.UacQryAuditLogAbilityService;
import com.tydic.uac.ability.bo.UacQryAuditLogReqBO;
import com.tydic.uac.ability.bo.UacQryAuditLogRspBO;
import com.tydic.uac.bo.common.ApprovalLogBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccElcCommdQryListBusiservice.class)
public class UccElcCommdQryListBusiserviceImpl
implements UccElcCommdQryListBusiservice {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccElcCommdQryListBusiserviceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityLogMapper commodityLogMapper;
    @Reference(interfaceClass=ApprovalCommoAuthorService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private ApprovalCommoAuthorService approvalCommoAuthorService;
    @Autowired
    private UacQryAuditLogAbilityService uocAuditQryLogAbilityService;

    public EclCommdQryListRspBo qry(EclCommdQryListReqBo reqBo) {
        EclCommdQryListRspBo eclCommdQryListRspBo = new EclCommdQryListRspBo();
        try {
            ValidatorUtil.validator((Object)reqBo);
        }
        catch (BusinessException e) {
            eclCommdQryListRspBo.setRespCode("8888");
            eclCommdQryListRspBo.setRespDesc(e.getMsgInfo());
            return eclCommdQryListRspBo;
        }
        if (CollectionUtils.isEmpty((Collection)reqBo.getUmcStationsListWebExt())) {
            eclCommdQryListRspBo.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u6743\u9650");
            eclCommdQryListRspBo.setRespCode("0000");
            eclCommdQryListRspBo.setRows(new ArrayList());
            return eclCommdQryListRspBo;
        }
        UccQryCommodityForEclPO uccQryCommodityForEclPO = new UccQryCommodityForEclPO();
        BeanUtils.copyProperties((Object)reqBo, (Object)((Object)uccQryCommodityForEclPO));
        Page poPage = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        ArrayList approvalCommoAuthCode = Lists.newArrayList();
        if (!SkuStatusEnum.ON_SHELVES_STATUS.getStatus().equals(reqBo.getCommodityStatus()) && !SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(reqBo.getCommodityStatus())) {
            for (UmcStationWebBO umcStationWebBO : reqBo.getUmcStationsListWebExt()) {
                approvalCommoAuthCode.add(umcStationWebBO.getStationId().toString());
            }
            uccQryCommodityForEclPO.setAuthCode(approvalCommoAuthCode);
        }
        LOGGER.info("uccQryCommodityForEclPO:" + JSON.toJSON((Object)((Object)uccQryCommodityForEclPO)));
        List<UccQryCommodityForEclPO> commodityForEclPOList = this.uccCommodityMapper.qryCommoListForEcl(uccQryCommodityForEclPO, (Page<UccQryCommodityForEclPO>)poPage);
        if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(reqBo.getCommodityStatus()) && CollectionUtils.isNotEmpty(commodityForEclPOList)) {
            for (UccQryCommodityForEclPO commodityForEclPO : commodityForEclPOList) {
                UacQryAuditLogReqBO uocAuditQryLogAbilityReqBO = new UacQryAuditLogReqBO();
                uocAuditQryLogAbilityReqBO.setObjType(Integer.valueOf(2));
                uocAuditQryLogAbilityReqBO.setObjId(String.valueOf(commodityForEclPO.getCommodityId()));
                uocAuditQryLogAbilityReqBO.setStepName(ApprovalTypeEnum.APPROVAL_DOWN_SHELF.code());
                UacQryAuditLogRspBO uocAuditQryLogAbilityRspBO = this.uocAuditQryLogAbilityService.qryLog(uocAuditQryLogAbilityReqBO);
                List approvalLogBOS = uocAuditQryLogAbilityRspBO.getRows();
                if (!CollectionUtils.isNotEmpty((Collection)approvalLogBOS)) continue;
                commodityForEclPO.setRejectReason(((ApprovalLogBO)approvalLogBOS.get(0)).getAuditAdvice());
            }
        }
        for (UccQryCommodityForEclPO commodityForEclPO : commodityForEclPOList) {
            Integer status = commodityForEclPO.getSkuStatus();
            if (status != null && status.equals(SkuStatusEnum.ON_SHELVES_STATUS.getStatus())) {
                commodityForEclPO.setDownShelfTime(null);
            }
            if (status == null || status.equals(SkuStatusEnum.ON_SHELVES_STATUS.getStatus())) continue;
            commodityForEclPO.setUpShelfTime(null);
        }
        try {
            List commodityForEclBOS = ListCloneUtils.clonePOListToBOListNotDate(commodityForEclPOList, UccQryCommodityForEclBO.class);
            eclCommdQryListRspBo.setRows(commodityForEclBOS);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u5546\u54c1\u4e0a\u4e0b\u67b6\u6570\u636e\u8f6c\u6362\u9519\u8bef");
        }
        eclCommdQryListRspBo.setRespCode("0000");
        eclCommdQryListRspBo.setRespDesc("\u6210\u529f");
        eclCommdQryListRspBo.setPageNo(poPage.getPageNo());
        eclCommdQryListRspBo.setRecordsTotal(poPage.getTotalCount());
        eclCommdQryListRspBo.setTotal(poPage.getTotalPages());
        return eclCommdQryListRspBo;
    }

    public EclCommdQryListRspBo qryForExport(EclCommdQryListReqBo eclCommdQryListReqBo) {
        EclCommdQryListRspBo eclCommdQryListRspBo = new EclCommdQryListRspBo();
        try {
            ValidatorUtil.validator((Object)eclCommdQryListReqBo);
        }
        catch (BusinessException e) {
            eclCommdQryListRspBo.setRespCode("8888");
            eclCommdQryListRspBo.setRespDesc(e.getMsgInfo());
            return eclCommdQryListRspBo;
        }
        UccQryCommodityForEclPO uccQryCommodityForEclPO = new UccQryCommodityForEclPO();
        BeanUtils.copyProperties((Object)eclCommdQryListReqBo, (Object)((Object)uccQryCommodityForEclPO));
        ApprovalAuthorBO approvalAuthorBO = null;
        ArrayList approvalCommoAuthCode = Lists.newArrayList();
        Object approvalCommoAuthDetailEnum = null;
        try {
            if (eclCommdQryListReqBo.getCommodityStatus() != 3 && eclCommdQryListReqBo.getCommodityStatus() != 5) {
                for (Object umcStationWebBO : eclCommdQryListReqBo.getUmcStationsListWebExt()) {
                    approvalCommoAuthCode.add(umcStationWebBO.getStationCode());
                }
                ApprovalCommoAuthor approvalCommoAuthor = null;
                if (approvalCommoAuthDetailEnum != null) {
                    approvalCommoAuthor = this.approvalCommoAuthorService.getApprovalRoleAuth((List)approvalCommoAuthCode);
                }
                if (approvalCommoAuthor == null) {
                    eclCommdQryListRspBo.setRespDesc("\u6ca1\u6709\u67e5\u8be2\u6743\u9650");
                    eclCommdQryListRspBo.setRespCode("0000");
                    return eclCommdQryListRspBo;
                }
                approvalAuthorBO = this.approvalCommoAuthorService.getApprovalStepAuth(approvalCommoAuthor);
                BeanUtils.copyProperties((Object)approvalAuthorBO, (Object)((Object)uccQryCommodityForEclPO));
            }
        }
        catch (BusinessException e) {
            eclCommdQryListRspBo.setRespCode("8888");
            eclCommdQryListRspBo.setRespDesc(e.getMsgInfo());
            return eclCommdQryListRspBo;
        }
        List<UccQryCommodityForEclPO> commodityForEclPOList = this.uccCommodityMapper.qryCommoListForEclExpert(uccQryCommodityForEclPO);
        if (SkuStatusEnum.DOWN_FRAME_STATUS.getStatus().equals(eclCommdQryListReqBo.getCommodityStatus()) && CollectionUtils.isNotEmpty(commodityForEclPOList)) {
            for (UccQryCommodityForEclPO commodityForEclPO : commodityForEclPOList) {
                UccCommodityLogPO uccCommodityLogPO = this.commodityLogMapper.getCommodityLogByCreateTimeNew(commodityForEclPO.getCommodityId());
                commodityForEclPO.setRejectReason(uccCommodityLogPO.getAduitResult());
            }
        }
        try {
            List commodityForEclBOS = ListCloneUtils.clonePOListToBOListNotDate(commodityForEclPOList, UccQryCommodityForEclBO.class);
            eclCommdQryListRspBo.setRows(commodityForEclBOS);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u5546\u54c1\u4e0a\u4e0b\u67b6\u6570\u636e\u8f6c\u6362\u9519\u8bef");
        }
        eclCommdQryListRspBo.setRespCode("0000");
        eclCommdQryListRspBo.setRespDesc("\u6210\u529f");
        return eclCommdQryListRspBo;
    }
}

