/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.atom.UccFreightQryAtomService;
import com.tydic.commodity.atom.bo.UccFreightQryAtomReqBO;
import com.tydic.commodity.atom.bo.UccFreightQryAtomRspBO;
import com.tydic.commodity.atom.impl.UccFreightQryAtomServiceImpl;
import com.tydic.commodity.bo.busi.SkuNumBO_busi;
import com.tydic.commodity.bo.busi.UccFreightQryBusiReqBO;
import com.tydic.commodity.bo.busi.UccFreightQryBusiRspBO;
import com.tydic.commodity.busi.api.UccFreightQryBusiService;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccFreightQryBusiService.class)
public class UccFreightQryBusiServiceImpl
implements UccFreightQryBusiService {
    @Autowired
    private UccFreightQryAtomService uccFreightQryAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccFreightQryAtomServiceImpl.class);

    public UccFreightQryBusiRspBO qryFreightBusi(UccFreightQryBusiReqBO reqBO) {
        UccFreightQryBusiRspBO rspBO = new UccFreightQryBusiRspBO();
        try {
            UccFreightQryAtomReqBO uccFreightQryAtomReqBO = new UccFreightQryAtomReqBO();
            BeanUtils.copyProperties((Object)reqBO, (Object)uccFreightQryAtomReqBO);
            HashMap<Long, Long> skuMap = new HashMap<Long, Long>();
            for (SkuNumBO_busi each : uccFreightQryAtomReqBO.getSku()) {
                if (skuMap.containsKey(each.getSkuId())) {
                    skuMap.put(each.getSkuId(), (Long)skuMap.get(each.getSkuId()) + each.getNum());
                    continue;
                }
                skuMap.put(each.getSkuId(), each.getNum());
            }
            ArrayList<SkuNumBO_busi> sku = new ArrayList<SkuNumBO_busi>();
            for (Map.Entry entry : skuMap.entrySet()) {
                SkuNumBO_busi bo = new SkuNumBO_busi();
                bo.setSkuId((Long)entry.getKey());
                bo.setNum((Long)entry.getValue());
                sku.add(bo);
            }
            if (CollectionUtils.isEmpty(sku)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8bf7\u8f93\u5165\u67e5\u8be2\u8d39\u7528\u7684\u5546\u54c1");
                return rspBO;
            }
            uccFreightQryAtomReqBO.setSku(sku);
            UccFreightQryAtomRspBO uccFreightQryAtomRspBO = this.uccFreightQryAtomService.qryFreight(uccFreightQryAtomReqBO);
            BeanUtils.copyProperties((Object)((Object)uccFreightQryAtomRspBO), (Object)rspBO);
            return rspBO;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u8c03\u7528\u539f\u5b50\u5c42\u9519\u8bef");
        }
    }
}

