/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.busi.UccMerchantsCatAddReqBO;
import com.tydic.commodity.bo.busi.UccMerchantsCatAddRspBO;
import com.tydic.commodity.busi.api.UccMerchantsCatAddBusiService;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.exception.BusinessException;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccMerchantsCatAddBusiService.class)
public class UccMerchantsCatAddBusiServiceImpl
implements UccMerchantsCatAddBusiService {
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    private Sequence uccBatchSequence = Sequence.getInstance();
    private static final Logger LOGGER = LoggerFactory.getLogger(UccMerchantsCatAddBusiServiceImpl.class);

    public UccMerchantsCatAddRspBO addMerchantsCat(UccMerchantsCatAddReqBO reqBO) {
        UccMerchantsCatAddRspBO rspBO = new UccMerchantsCatAddRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6dfb\u52a0\u6210\u529f");
        if (reqBO.getOrgIdIn() == null) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u673a\u6784ID");
        }
        UccCatalogDealPO po = new UccCatalogDealPO();
        po.setCatalogLevel(2);
        po.setSupplierId(reqBO.getOrgIdIn());
        List<UccCatalogDealPO> uccCatalogDealPOList = this.uccCatalogDealMapper.queryCatalog(po);
        UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
        uccCatalogDealPO.setCatalogName(reqBO.getCatalogName());
        uccCatalogDealPO.setCatalogLevel(3);
        uccCatalogDealPO.setSupplierId(reqBO.getOrgIdIn());
        uccCatalogDealPO.setCatalogIdLogo(reqBO.getLogoUrl());
        if (CollectionUtils.isNotEmpty(uccCatalogDealPOList)) {
            uccCatalogDealPO.setUpperCatalogId(uccCatalogDealPOList.get(0).getGuideCatalogId());
            uccCatalogDealPO.setChannelId(uccCatalogDealPOList.get(0).getChannelId());
            uccCatalogDealPO.setShopCatalogType(uccCatalogDealPOList.get(0).getShopCatalogType());
        } else {
            uccCatalogDealPO.setUpperCatalogId(0L);
            uccCatalogDealPO.setChannelId(0L);
            uccCatalogDealPO.setShopCatalogType(0);
        }
        uccCatalogDealPO.setCatalogStatus(1);
        uccCatalogDealPO.setViewOrder(0);
        try {
            uccCatalogDealPO.setGuideCatalogId(this.uccBatchSequence.nextId());
            int i = this.uccCatalogDealMapper.addCatalog(uccCatalogDealPO);
            if (i == 0) {
                throw new BusinessException("8888", "\u6dfb\u52a0\u5931\u8d25");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u6dfb\u52a0\u5931\u8d25");
        }
        return rspBO;
    }
}

