/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.busi.MqSyncCommdPriceBo;
import com.tydic.commodity.bo.busi.MqSyncCommdPriceReqBo;
import com.tydic.commodity.bo.busi.MqSyncCommdPriceRspBo;
import com.tydic.commodity.bo.busi.SkuPriceBo;
import com.tydic.commodity.bo.busi.UccSkuAdjustPriceReqBO;
import com.tydic.commodity.busi.api.QueryDBDateBusiService;
import com.tydic.commodity.busi.api.UccMqSyncCommdPriceBusiService;
import com.tydic.commodity.busi.api.UccSkuAdjustPriceBusiService;
import com.tydic.commodity.dao.ECommercePriceChangeLogMapper;
import com.tydic.commodity.dao.ECommercePriceChangeMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.ECommercePriceChangeLogPO;
import com.tydic.commodity.dao.po.ECommercePriceChangePO;
import com.tydic.commodity.exception.BusinessException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccMqSyncCommdPriceBusiServiceImpl
implements UccMqSyncCommdPriceBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccMqSyncCommdPriceBusiServiceImpl.class);
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private ECommercePriceChangeMapper eCommercePriceChangeMapper;
    @Autowired
    private ECommercePriceChangeLogMapper eCommercePriceChangeLogMapper;
    @Autowired
    private UccSkuAdjustPriceBusiService uccSkuAdjustPriceBusiService;
    @Autowired
    private QueryDBDateBusiService queryDBDateBusiService;
    private Sequence coefficientSequence = Sequence.getInstance();

    public MqSyncCommdPriceRspBo dealSync(MqSyncCommdPriceReqBo mqSyncCommdPriceReqBo) {
        MqSyncCommdPriceRspBo rspBo = new MqSyncCommdPriceRspBo();
        ArrayList<ECommercePriceChangePO> eCommercePriceChangePOList = new ArrayList<ECommercePriceChangePO>();
        ArrayList<ECommercePriceChangeLogPO> eCommercePriceChangeLogPOS = new ArrayList<ECommercePriceChangeLogPO>();
        if (CollectionUtils.isEmpty((Collection)mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList())) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        for (MqSyncCommdPriceBo each : mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList()) {
            UccSkuAdjustPriceReqBO uccSkuAdjustPriceReqBO = new UccSkuAdjustPriceReqBO();
            uccSkuAdjustPriceReqBO.setSkuId(each.getSkuId());
            uccSkuAdjustPriceReqBO.setSupplierShopId(each.getSupplierShopId());
            SkuPriceBo skuPriceBo = new SkuPriceBo();
            uccSkuAdjustPriceReqBO.setUpdateSkuPriceInfo(skuPriceBo);
            skuPriceBo.setSalePrice(each.getSalePrice());
            skuPriceBo.setAgreementPrice(each.getAgreementPrice());
            skuPriceBo.setMarketPrice(each.getMarketPrice());
            try {
                this.uccSkuAdjustPriceBusiService.dealSkuAdjustPrice(uccSkuAdjustPriceReqBO);
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            ECommercePriceChangePO eCommercePriceChangePO = new ECommercePriceChangePO();
            eCommercePriceChangePO.setSkuId(each.getSkuId());
            eCommercePriceChangePO.setSupplierShopId(each.getSupplierShopId());
            List<ECommercePriceChangePO> eCommercePriceChangePOS = this.eCommercePriceChangeMapper.qryECommercePriceChange(eCommercePriceChangePO);
            Date nowDate = this.queryDBDateBusiService.getDBDate();
            Calendar time = Calendar.getInstance();
            time.setTime(each.getOnShelveTime());
            time.add(1, 1);
            Date onShelveTime = time.getTime();
            Date updateTime = null;
            if (nowDate.compareTo(onShelveTime) > 0) {
                time.setTime(nowDate);
                time.set(2, 4);
                time.set(5, 31);
                Date compareTime = time.getTime();
                time = Calendar.getInstance();
                time.setTime(nowDate);
                time.add(1, -1);
                if (nowDate.compareTo(compareTime) > 0) {
                    time.set(2, 5);
                    time.set(5, 1);
                } else {
                    time.set(2, 0);
                    time.set(5, 1);
                }
                updateTime = time.getTime();
            }
            ECommercePriceChangeLogPO eCommercePriceChangeLogHistory = new ECommercePriceChangeLogPO();
            eCommercePriceChangeLogHistory.setSkuId(each.getSkuId());
            eCommercePriceChangeLogHistory.setSupplierShopId(each.getSupplierShopId());
            eCommercePriceChangeLogHistory.setUpdateTime(updateTime);
            eCommercePriceChangeLogHistory = this.eCommercePriceChangeLogMapper.queryCount(eCommercePriceChangeLogHistory);
            if (eCommercePriceChangeLogHistory == null) {
                return null;
            }
            eCommercePriceChangePO.setFrequency(eCommercePriceChangeLogHistory.getFrequency());
            eCommercePriceChangePO.setAveragePrice(eCommercePriceChangeLogHistory.getAveragePrice());
            eCommercePriceChangePO.setExtSkuId(each.getExtSkuId());
            eCommercePriceChangePO.setFrequency(eCommercePriceChangeLogHistory.getFrequency());
            eCommercePriceChangePO.setPrice(each.getOrgSalePrice());
            if (eCommercePriceChangePO.getAveragePrice() != null) {
                if (eCommercePriceChangePO.getAveragePrice().compareTo(new BigDecimal(0)) == 0) {
                    if (each.getOrgSalePrice().compareTo(eCommercePriceChangePO.getAveragePrice()) == 0) {
                        eCommercePriceChangePO.setFloatingRate(new BigDecimal(0.01));
                    } else {
                        eCommercePriceChangePO.setFloatingRate(new BigDecimal(0));
                    }
                } else {
                    eCommercePriceChangePO.setFloatingRate(each.getOrgSalePrice().divide(eCommercePriceChangePO.getAveragePrice(), 2, 0));
                }
            }
            try {
                eCommercePriceChangePO.setId(this.coefficientSequence.nextId());
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            if (eCommercePriceChangePOS == null || eCommercePriceChangePOS.size() == 0) {
                eCommercePriceChangePOList.add(eCommercePriceChangePO);
            } else {
                this.eCommercePriceChangeMapper.modifyECommercePriceChange(eCommercePriceChangePO);
            }
            ECommercePriceChangeLogPO eCommercePriceChangeLogPO = new ECommercePriceChangeLogPO();
            try {
                eCommercePriceChangeLogPO.setBatchId(this.coefficientSequence.nextId());
            }
            catch (Exception e) {
                throw new BusinessException("8888", "\u5931\u8d25");
            }
            BeanUtils.copyProperties((Object)eCommercePriceChangePO, (Object)eCommercePriceChangeLogPO);
            eCommercePriceChangeLogPO.setOnShelveTime(each.getOnShelveTime());
            eCommercePriceChangeLogPOS.add(eCommercePriceChangeLogPO);
        }
        if (eCommercePriceChangePOList.size() > 0) {
            this.eCommercePriceChangeMapper.insertPriceChange(eCommercePriceChangePOList);
        }
        if (eCommercePriceChangeLogPOS.size() > 0) {
            this.eCommercePriceChangeLogMapper.insertECommercePriceChangeLogs(eCommercePriceChangeLogPOS);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

