/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.bo.busi.UccEMdmCatalogBO;
import com.tydic.commodity.bo.busi.UccOnLoadCommoCategoryReqBO;
import com.tydic.commodity.bo.busi.UccOnLoadCommoCategoryRspBO;
import com.tydic.commodity.bo.busi.UccOnLoadToRedisEMdmCatalogBO;
import com.tydic.commodity.busi.api.UccOnLoadCommoCategoryRedisBusiService;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.po.UccEMdmCatalogPO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccOnLoadCommoCategoryRedisBusiService.class)
public class UccOnLoadCommoCategoryRedisBusiServiceImpl
implements UccOnLoadCommoCategoryRedisBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccOnLoadCommoCategoryRedisBusiServiceImpl.class);
    @Autowired
    private UccEMdmCatalogMapper eMdmCatalogMapper;
    @Autowired
    private CacheClient cacheClient;

    public UccOnLoadCommoCategoryRspBO onLoadCommoCategory(UccOnLoadCommoCategoryReqBO reqBO) {
        UccOnLoadCommoCategoryRspBO uccOnLoadCommoCategoryRspBO = new UccOnLoadCommoCategoryRspBO();
        try {
            List<UccOnLoadToRedisEMdmCatalogBO> uccEMdmCatalogPOS = this.eMdmCatalogMapper.qryAllCatalogRelationship();
            if (CollectionUtils.isNotEmpty(uccEMdmCatalogPOS)) {
                this.cacheClient.delete("EMDmCatelog");
            }
            LOGGER.info(JSON.toJSON(uccEMdmCatalogPOS) + "");
            this.cacheClient.set("EMDmCatelog", uccEMdmCatalogPOS);
        }
        catch (Exception e) {
            LOGGER.error("\u5546\u54c1\u5206\u7c7b\u6570\u636e\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        return uccOnLoadCommoCategoryRspBO;
    }

    public List<UccEMdmCatalogBO> getTopCatalog() {
        ArrayList<UccEMdmCatalogBO> uccEMdmCatalogBOS = new ArrayList<UccEMdmCatalogBO>();
        UccEMdmCatalogPO uccEMdmCatalogPO = new UccEMdmCatalogPO();
        uccEMdmCatalogPO.setCatalogLevel(1);
        List<UccEMdmCatalogPO> topUccCatalog = null;
        try {
            topUccCatalog = this.eMdmCatalogMapper.qryUccEMdmCatalog(uccEMdmCatalogPO);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (UccEMdmCatalogPO eMdmCatalogPO : topUccCatalog) {
            UccEMdmCatalogBO catalogBO = this.recursiveTree(eMdmCatalogPO.getCatalogId());
            uccEMdmCatalogBOS.add(catalogBO);
        }
        return uccEMdmCatalogBOS;
    }

    public UccEMdmCatalogBO recursiveTree(Long cid) {
        UccEMdmCatalogBO uccEMdmCatalogBO = new UccEMdmCatalogBO();
        UccEMdmCatalogPO uccEMdmCatalogPO = new UccEMdmCatalogPO();
        uccEMdmCatalogPO.setCatalogId(cid);
        List<UccEMdmCatalogPO> topUccCatalog = this.eMdmCatalogMapper.qryUccEMdmCatalog(uccEMdmCatalogPO);
        UccEMdmCatalogPO catalogPO = topUccCatalog.get(0);
        BeanUtils.copyProperties((Object)catalogPO, (Object)uccEMdmCatalogBO);
        uccEMdmCatalogPO = new UccEMdmCatalogPO();
        uccEMdmCatalogPO.setParentCatalogId(cid);
        List<UccEMdmCatalogPO> childTreeNodes = this.eMdmCatalogMapper.qryUccEMdmCatalog(uccEMdmCatalogPO);
        for (UccEMdmCatalogPO uccEMdmCatalogPO1 : childTreeNodes) {
            UccEMdmCatalogBO n = this.recursiveTree(uccEMdmCatalogPO1.getCatalogId());
            uccEMdmCatalogBO.getChildren().add(n);
        }
        return uccEMdmCatalogBO;
    }
}

