/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.busi.UccQryCommdNumNotRelCategoryReqBO;
import com.tydic.commodity.bo.busi.UccQryCommdNumNotRelCategoryRspBO;
import com.tydic.commodity.busi.api.UccQryCommdNumNotRelCategoryBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.exception.BusinessException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccQryCommdNumNotRelCategoryBusiService.class)
public class UccQryCommdNumNotRelCategoryBusiServiceImpl
implements UccQryCommdNumNotRelCategoryBusiService {
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryCommdNumNotRelCategoryBusiServiceImpl.class);

    public UccQryCommdNumNotRelCategoryRspBO qryamount(UccQryCommdNumNotRelCategoryReqBO reqBO) {
        UccQryCommdNumNotRelCategoryRspBO rspBO = new UccQryCommdNumNotRelCategoryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setAmount(Long.valueOf(0L));
        if (reqBO.getOrgIdIn() == null) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u673a\u6784ID");
        }
        UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
        uccCatalogDealPO.setSupplierId(reqBO.getOrgIdIn());
        List<UccCatalogDealPO> uccCatalogDealPOList = this.uccCatalogDealMapper.queryCatalog(uccCatalogDealPO);
        if (CollectionUtils.isEmpty(uccCatalogDealPOList)) {
            return rspBO;
        }
        ArrayList<Long> catalogIds = new ArrayList<Long>();
        for (UccCatalogDealPO uccCatalogDealPO1 : uccCatalogDealPOList) {
            catalogIds.add(uccCatalogDealPO1.getGuideCatalogId());
        }
        List<Long> commodityTypeIds = this.uccCatRCommdTypeMapper.queryTypeByGuideCatalogIds(catalogIds);
        ArrayList<Long> supplierShopIds = new ArrayList<Long>();
        if (reqBO.getSupplierShopId() != null) {
            supplierShopIds.add(reqBO.getSupplierShopId());
        } else {
            List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getOrgIdIn());
            for (int i = 0; i < supplierShopPos.size(); ++i) {
                supplierShopIds.add(supplierShopPos.get(i).getSupplierShopId());
            }
        }
        Long nums = this.uccCommodityMapper.qryNotInTypeNums(commodityTypeIds, supplierShopIds);
        rspBO.setAmount(nums);
        return rspBO;
    }
}

