/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.PropGrpBo;
import com.tydic.commodity.bo.busi.UccQueryPropGrpReqBO;
import com.tydic.commodity.bo.busi.UccQueryPropGrpRspBO;
import com.tydic.commodity.busi.api.UccQueryPropGroupBusiService;
import com.tydic.commodity.dao.UccCommodityPropGrpMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.po.DicDictionaryPo;
import com.tydic.commodity.dao.po.UccCommodityPropGrpPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.enumType.CommodityPropGrpEnum;
import com.tydic.commodity.util.DateUtils;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccQueryPropGroupBusiService.class)
public class UccQueryPropGroupBusiServiceImpl
implements UccQueryPropGroupBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQueryPropGroupBusiServiceImpl.class);
    @Autowired
    private UccCommodityPropGrpMapper uccCommodityPropGrpMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    public UccQueryPropGrpRspBO queryGroup(UccQueryPropGrpReqBO reqBO) {
        UccCommodityTypePo uccCommodityTypePo;
        UccQueryPropGrpRspBO rspBO = new UccQueryPropGrpRspBO();
        if (reqBO.getCommodityTypeId() != null && reqBO.getCommodityTypeId() != 0L && (uccCommodityTypePo = this.uccCommodityTypeMapper.queryPoByCommodityTypeId(reqBO.getCommodityTypeId())) == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5546\u54c1\u7c7b\u578bID:" + reqBO.getCommodityTypeId());
            return rspBO;
        }
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        UccCommodityPropGrpPo po = new UccCommodityPropGrpPo();
        BeanUtils.copyProperties((Object)reqBO, (Object)po);
        List<UccCommodityPropGrpPo> listPo = this.uccCommodityPropGrpMapper.queryGroup((Page<UccCommodityPropGrpPo>)page, po);
        if (listPo == null || listPo.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6570\u636e");
            rspBO.setPageNo(1);
            rspBO.setTotal(0);
            return rspBO;
        }
        ArrayList<PropGrpBo> propGrpBoList = new ArrayList<PropGrpBo>();
        PropGrpBo propGrpBo = null;
        for (UccCommodityPropGrpPo each : listPo) {
            propGrpBo = new PropGrpBo();
            BeanUtils.copyProperties((Object)each, (Object)propGrpBo);
            if (each.getCreateTime() != null) {
                propGrpBo.setCreateTime(DateUtils.dateToStr((Date)each.getCreateTime()));
            }
            if (each.getUpdateTime() != null) {
                propGrpBo.setUpdateTime(DateUtils.dateToStr((Date)each.getUpdateTime()));
            }
            DicDictionaryPo dicDictionaryPo = null;
            if (each.getPropGrpStatus() != null && (dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getPropGrpStatus().toString(), CommodityPropGrpEnum.COMMODITY_PROP_GRP_STATUS.toString())) != null) {
                propGrpBo.setPropGrpStatusTranslation(dicDictionaryPo.getTitle());
            }
            if (each.getCommodityPropGrpType() == null) continue;
            dicDictionaryPo = this.uccDictionaryAtomService.queryByCodeAndPcode(each.getCommodityPropGrpType().toString(), CommodityPropGrpEnum.COMMODITY_PROP_GRP_TYPE.toString());
            if (dicDictionaryPo != null) {
                propGrpBo.setPropGrpTypeTranslation(dicDictionaryPo.getTitle());
            }
            propGrpBoList.add(propGrpBo);
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setPageNo(page.getPageNo());
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRows(propGrpBoList);
        return rspBO;
    }
}

