/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.bo.busi.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.bo.busi.UccRetrialAdoptReqBO;
import com.tydic.commodity.bo.busi.UccRetrialAdoptRspBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.busi.api.UccRetrialAdoptBusiService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.validate.ValidatorUtil;
import com.tydic.uac.ability.UacNoTaskAuditOrderAuditAbilityService;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditReqBO;
import com.tydic.uac.ability.bo.UacNoTaskAuditOrderAuditRspBO;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccRetrialAdoptBusiService.class)
public class UccRetrialAdoptBusiServiceImpl
implements UccRetrialAdoptBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccRetrialAdoptBusiServiceImpl.class);
    @Reference(interfaceClass=BatchUpdateCommoStatusForMarketService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private BatchUpdateCommoStatusForMarketService batchUpdateCommoStatusForMarketService;
    @Autowired
    private UacNoTaskAuditOrderAuditAbilityService auditOrderAuditAbilityService;
    @Value(value="${PROCESS_DEF_ID}")
    private String processDefId;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;

    public UccRetrialAdoptRspBO retrialAdopt(UccRetrialAdoptReqBO reqBO) {
        UacNoTaskAuditOrderAuditRspBO rspBO;
        ValidatorUtil.validator((Object)reqBO);
        UccRetrialAdoptRspBO uccRetrialAdoptRspBO = new UccRetrialAdoptRspBO();
        if (reqBO.getBusinessId() == null || reqBO.getBusinessId().length < 1) {
            uccRetrialAdoptRspBO.setRespCode("8888");
            uccRetrialAdoptRspBO.setRespDesc("\u4e1a\u52a1ID\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
            return uccRetrialAdoptRspBO;
        }
        if (reqBO.getUserId() == null) {
            uccRetrialAdoptRspBO.setRespCode("8888");
            uccRetrialAdoptRspBO.setRespDesc("\u64cd\u4f5c\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
            return uccRetrialAdoptRspBO;
        }
        UccCommodityPo commodityPo = null;
        try {
            for (int i = 0; i < reqBO.getBusinessId().length; ++i) {
                commodityPo = this.uccCommodityMapper.getCommodityById(reqBO.getBusinessId()[i]);
                if (!StringUtils.isBlank((String)commodityPo.getApprovalStatus()) && !"0".equals(commodityPo.getApprovalStatus())) continue;
                LOGGER.error("\u5546\u54c1\u672a\u901a\u8fc7\u5ba1\u6838\u6821\u9a8c\u4e0d\u80fd\u53d1\u8d77\u91cd\u5ba1\u901a\u8fc7,commodityId:" + reqBO.getBusinessId()[i]);
                throw new BusinessException("8888", "\u5546\u54c1[" + commodityPo.getExtSkuId() + "]\u672a\u901a\u8fc7\u5ba1\u6838\u6821\u9a8c,\u4e0d\u80fd\u53d1\u8d77\u91cd\u5ba1\u901a\u8fc7");
            }
        }
        catch (BusinessException e) {
            uccRetrialAdoptRspBO.setRespCode("8888");
            uccRetrialAdoptRspBO.setRespDesc(e.getMsgInfo());
            return uccRetrialAdoptRspBO;
        }
        UacNoTaskAuditOrderAuditReqBO uocAuditAbilityAuditReqBO = new UacNoTaskAuditOrderAuditReqBO();
        HashMap<String, String> ext = new HashMap<String, String>();
        ext.put("dealStepName", "\u91cd\u5ba1\u901a\u8fc7");
        uocAuditAbilityAuditReqBO.setExt(ext);
        uocAuditAbilityAuditReqBO.setObjType(Integer.valueOf(2));
        uocAuditAbilityAuditReqBO.setObjId(Arrays.asList(reqBO.getBusinessId()));
        uocAuditAbilityAuditReqBO.setStepId(commodityPo != null ? commodityPo.getApprovalStatus() : ApprovalTypeEnum.APPROVAL_REJECT.getStep());
        uocAuditAbilityAuditReqBO.setAuditResult(Integer.valueOf(1));
        uocAuditAbilityAuditReqBO.setOperId(reqBO.getUsername());
        uocAuditAbilityAuditReqBO.setDownload(reqBO.getAnnexFileUrl());
        uocAuditAbilityAuditReqBO.setAuditAdvice(reqBO.getReason());
        uocAuditAbilityAuditReqBO.setUsername(reqBO.getUsername());
        try {
            rspBO = this.auditOrderAuditAbilityService.dealAudit(uocAuditAbilityAuditReqBO);
        }
        catch (Exception e) {
            LOGGER.error("\u91cd\u5ba1\u901a\u8fc7\u5904\u7406\u5ba1\u6838\u5931\u8d25,\u539f\u56e0" + e);
            uccRetrialAdoptRspBO.setRespCode("8888");
            uccRetrialAdoptRspBO.setRespDesc("\u5904\u7406\u6d41\u7a0b\u5931\u8d25");
            return uccRetrialAdoptRspBO;
        }
        try {
            UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(reqBO.getBusinessId()[0]);
            if (uccCommodityPo.getCommodityStatus().intValue() == CommodityStatusEnum.REJECT_STATUS.getStatus().intValue()) {
                BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
                batchUpdateCommoStatusForMarketBO.setBusinessId(reqBO.getBusinessId());
                batchUpdateCommoStatusForMarketBO.setReason("\u91cd\u7533\u901a\u8fc7");
                batchUpdateCommoStatusForMarketBO.setOperId(String.valueOf(reqBO.getUserId()));
                this.batchUpdateCommoStatusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.PENDING_APPROVAL_STATUS, SkuStatusEnum.PENDING_APPROVAL_STATUS);
            }
        }
        catch (Exception e) {
            uccRetrialAdoptRspBO.setRespCode("8888");
            uccRetrialAdoptRspBO.setRespDesc("\u5904\u7406\u6d41\u7a0b\u5931\u8d25");
            return uccRetrialAdoptRspBO;
        }
        try {
            for (int i = 0; i < reqBO.getBusinessId().length; ++i) {
                CommodityBo commodityBo = new CommodityBo();
                UccCommodityPo uccCommodityPo = this.uccCommodityMapper.getCommodityById(reqBO.getBusinessId()[i]);
                BeanUtils.copyProperties((Object)uccCommodityPo, (Object)commodityBo);
                commodityBo.setApprovalStatus(rspBO.getNoneInstanceBO().getStepId());
                this.batchUpdateCommoStatusForMarketService.updateCommoApprovalStatus(commodityBo, AuditResultStatusEnum.Audit_Pass);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5904\u7406\u6d41\u7a0b\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
            uccRetrialAdoptRspBO.setRespCode("8888");
            uccRetrialAdoptRspBO.setRespDesc("\u5904\u7406\u6d41\u7a0b\u5931\u8d25");
            return uccRetrialAdoptRspBO;
        }
        uccRetrialAdoptRspBO.setRespCode("0000");
        uccRetrialAdoptRspBO.setRespDesc("\u6210\u529f");
        return uccRetrialAdoptRspBO;
    }
}

