/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.atom.UccDictionaryAtomService;
import com.tydic.commodity.bo.busi.UccSendChannelReqBO;
import com.tydic.commodity.bo.busi.UccSendChannelRspBO;
import com.tydic.commodity.busi.api.UccSendChannelBusiService;
import com.tydic.commodity.busi.impl.UccQueryRelPropertyBusiServiceImpl;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccChannelDealMapper;
import com.tydic.commodity.dao.UccChannelPutMapper;
import com.tydic.commodity.dao.po.UccChannelDealPO;
import com.tydic.commodity.dao.po.UccChannelPutPo;
import com.tydic.commodity.enumType.ChannelPutEnum;
import java.util.Map;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccSendChannelBusiService.class)
public class UccSendChannelBusiServiceImpl
implements UccSendChannelBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQueryRelPropertyBusiServiceImpl.class);
    @Autowired
    private UccChannelDealMapper uccChannelDealMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccChannelPutMapper uccChannelPutMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    public UccSendChannelRspBO modifyChannel(UccSendChannelReqBO reqBO) {
        UccSendChannelRspBO rspBO = new UccSendChannelRspBO();
        String errMgg = this.verify(reqBO);
        if (!"".equals(errMgg)) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(errMgg);
            return rspBO;
        }
        UccChannelPutPo uccChannelPutPo = new UccChannelPutPo();
        uccChannelPutPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccChannelPutPo.setPutObjType(reqBO.getPutObjType());
        if (reqBO.getSkuId() != null) {
            uccChannelPutPo.setPutObjId(reqBO.getSkuId());
        } else {
            uccChannelPutPo.setPutObjId(reqBO.getCommodityId());
        }
        try {
            this.uccChannelPutMapper.deleteRecord(uccChannelPutPo);
        }
        catch (Exception e) {
            LOGGER.error("\u5220\u9664\u539f\u6709\u6295\u653e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
            throw new ZTBusinessException("\u5220\u9664\u539f\u6709\u6295\u653e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        if (reqBO.getChannelIds() != null) {
            for (Long each : reqBO.getChannelIds()) {
                uccChannelPutPo = new UccChannelPutPo();
                BeanUtils.copyProperties((Object)reqBO, (Object)uccChannelPutPo);
                if (reqBO.getSkuId() != null) {
                    uccChannelPutPo.setPutObjId(reqBO.getSkuId());
                } else {
                    uccChannelPutPo.setPutObjId(reqBO.getCommodityId());
                }
                uccChannelPutPo.setChannelId(each);
                try {
                    this.uccChannelPutMapper.sendChannel(uccChannelPutPo);
                }
                catch (Exception e) {
                    LOGGER.error("\u65b0\u589e\u6295\u653e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
                    throw new ZTBusinessException("\u65b0\u589e\u6295\u653e\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private String verify(UccSendChannelReqBO reqBO) {
        if (reqBO.getCommodityId() == null && reqBO.getSkuId() == null) {
            return "\u8bf7\u4f20\u5165\u6295\u653e\u5bf9\u8c61";
        }
        if (reqBO.getSupplierShopId() == null) {
            return "\u8bf7\u4f20\u5165\u5e97\u94fa\u4fe1\u606f";
        }
        if (reqBO.getPutObjType() == null) {
            return "\u8bf7\u4f20\u5165\u6295\u653e\u5bf9\u8c61\u7c7b\u578b";
        }
        return this.datebaseVerify(reqBO);
    }

    private String datebaseVerify(UccSendChannelReqBO reqBO) {
        int count = this.supplierShopMapper.selectSupplierShopById(reqBO.getSupplierShopId());
        if (count == 0) {
            return "\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u5e97\u94fa\u4fe1\u606f";
        }
        UccChannelDealPO uccChannelDealPO = null;
        for (Long each : reqBO.getChannelIds()) {
            uccChannelDealPO = new UccChannelDealPO();
            uccChannelDealPO.setChannelId(each);
            if ((uccChannelDealPO = this.uccChannelDealMapper.selectByChannelId(uccChannelDealPO)) != null) continue;
            return "\u8bf7\u4f20\u5165\u6b63\u786e\u7684\u9891\u9053ID \uff1a" + each;
        }
        return this.enumVerify(reqBO);
    }

    private String enumVerify(UccSendChannelReqBO reqBO) {
        Map<String, String> map = this.uccDictionaryAtomService.queryBypCodeBackMap(ChannelPutEnum.PUT_OBJ_TYPE.toString());
        if (map == null || !map.containsKey(reqBO.getPutObjType().toString())) {
            return "\u8f93\u5165\u6b63\u786e\u7684\u6295\u653e\u7c7b\u578b";
        }
        if (reqBO.getSkuId() != null && !"2".equals(reqBO.getPutObjType().toString())) {
            return "\u5bf9\u8c61\u4e0e\u5bf9\u8c61\u7c7b\u578b\u4e0d\u5339\u914d";
        }
        return "";
    }
}

