/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.CheckPassAndNotPassBO;
import com.tydic.commodity.bo.busi.CommodityCheckNotPassBO;
import com.tydic.commodity.bo.busi.CommodityCheckPassBO;
import com.tydic.commodity.bo.busi.SensitiveWordCheckInfoBO;
import com.tydic.commodity.bo.busi.SensitiveWordCheckReqBO;
import com.tydic.commodity.bo.busi.SensitiveWordCheckRspBO;
import com.tydic.commodity.busi.api.UccSensitiveWordCheckBusiService;
import com.tydic.commodity.dao.UccApprovalSensitiveWordMapper;
import com.tydic.commodity.dao.UccSensitiveVocabularyMapper;
import com.tydic.commodity.dao.po.UccApprovalSensitiveWordPO;
import com.tydic.commodity.dao.po.UccSensitiveVocabularyPO;
import com.tydic.commodity.util.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccSensitiveWordCheckBusiService.class)
public class UccSensitiveWordCheckBusiServiceImpl
implements UccSensitiveWordCheckBusiService {
    @Autowired
    private UccSensitiveVocabularyMapper sensitiveVocabularyMapper;
    @Autowired
    private UccApprovalSensitiveWordMapper uccApprovalSensitiveWordMapper;

    public SensitiveWordCheckRspBO executeSensitiveWordCheck(SensitiveWordCheckReqBO reqBO) {
        SensitiveWordCheckRspBO sensitiveWordCheckRspBO = new SensitiveWordCheckRspBO();
        CheckPassAndNotPassBO checkPassAndNotPassBO = new CheckPassAndNotPassBO();
        ArrayList commodityCheckPassBOs = Lists.newArrayList();
        ArrayList commodityCheckNotPassBOs = Lists.newArrayList();
        ArrayList approvalSensitiveWordList = new ArrayList();
        List<UccApprovalSensitiveWordPO> approvalSensitiveWordPOList = this.uccApprovalSensitiveWordMapper.getList(new UccApprovalSensitiveWordPO());
        if (CollectionUtils.isNotEmpty(approvalSensitiveWordPOList)) {
            approvalSensitiveWordList.addAll(approvalSensitiveWordPOList.stream().map(UccApprovalSensitiveWordPO::getSensitiveWord).collect(Collectors.toList()));
        }
        for (SensitiveWordCheckInfoBO sensitiveWordCheckInfoBO : reqBO.getSensitiveWordCheckInfoBOList()) {
            CommodityCheckNotPassBO commodityCheckNotPassBO = new CommodityCheckNotPassBO();
            List<UccSensitiveVocabularyPO> sensitiveVocabularyPOS = this.sensitiveVocabularyMapper.selectSensitiveByTypeId(sensitiveWordCheckInfoBO.getCommodityTypeId());
            if (CollectionUtils.isNotEmpty(sensitiveVocabularyPOS)) {
                List arrCAS = Utils.checkCAS((String)sensitiveWordCheckInfoBO.getCommodityName());
                if (CollectionUtils.isNotEmpty((Collection)arrCAS)) {
                    if (Objects.equals(sensitiveVocabularyPOS.get(0).getCasNumber(), arrCAS.get(0))) {
                        commodityCheckNotPassBO.setCommodityIds(sensitiveWordCheckInfoBO.getCommodityId());
                        commodityCheckNotPassBO.setNotPassReason("\u5b58\u5728\u654f\u611f\u8bcd");
                        commodityCheckNotPassBOs.add(commodityCheckNotPassBO);
                        continue;
                    }
                } else {
                    commodityCheckNotPassBO.setCommodityIds(sensitiveWordCheckInfoBO.getCommodityId());
                    commodityCheckNotPassBO.setNotPassReason("CAS\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5CAS");
                    commodityCheckNotPassBOs.add(commodityCheckNotPassBO);
                    continue;
                }
            }
            if (CollectionUtils.isNotEmpty(approvalSensitiveWordList)) {
                boolean checkResult = false;
                for (String sensitiveWord : approvalSensitiveWordList) {
                    if (!sensitiveWordCheckInfoBO.getCommodityName().contains(sensitiveWord)) continue;
                    checkResult = true;
                    commodityCheckNotPassBO.setCommodityIds(sensitiveWordCheckInfoBO.getCommodityId());
                    commodityCheckNotPassBO.setNotPassReason("\u5546\u54c1\u540d\u79f0\u5b58\u5728\u654f\u611f\u8bcd[" + sensitiveWord + "]");
                    commodityCheckNotPassBOs.add(commodityCheckNotPassBO);
                    break;
                }
                if (checkResult) continue;
            }
            CommodityCheckPassBO commodityCheckPassBO = new CommodityCheckPassBO();
            commodityCheckPassBO.setCommodityId(sensitiveWordCheckInfoBO.getCommodityId());
            commodityCheckPassBOs.add(commodityCheckPassBO);
        }
        checkPassAndNotPassBO.setPassCommodity((List)commodityCheckPassBOs);
        checkPassAndNotPassBO.setNotPassCommodity((List)commodityCheckNotPassBOs);
        sensitiveWordCheckRspBO.setCheckPassAndNotPassBO(checkPassAndNotPassBO);
        return sensitiveWordCheckRspBO;
    }
}

