/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl;

import com.tydic.commodity.atom.UccShufflingPicQryAtomService;
import com.tydic.commodity.atom.bo.UccShufflingPicQryReqBO;
import com.tydic.commodity.atom.bo.UccShufflingPicQryRspBO;
import com.tydic.commodity.bo.busi.UccShufflingPicQryBusiReqBO;
import com.tydic.commodity.bo.busi.UccShufflingPicQryBusiRspBO;
import com.tydic.commodity.busi.api.UccShufflingPicQryBusiService;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@Service(version="1.0.0", group="UCC_GROUP_DEV", interfaceClass=UccShufflingPicQryBusiService.class)
public class UccShufflingPicQryBusiServiceImpl
implements UccShufflingPicQryBusiService {
    @Autowired
    private UccShufflingPicQryAtomService uccShufflingPicQryAtomService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;

    public UccShufflingPicQryBusiRspBO qryShufflingPic(UccShufflingPicQryBusiReqBO reqBo) {
        UccShufflingPicQryBusiRspBO rspBo = new UccShufflingPicQryBusiRspBO();
        if (null == reqBo || null == reqBo.getSkuId() || null == reqBo.getSupplierShopId()) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u5165\u53c2\u5bf9\u8c61\u3001\u5355\u54c1ID\u3001\u5e97\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
            return rspBo;
        }
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSkuId(reqBo.getSkuId());
        uccSkuPo.setSupplierShopId(reqBo.getSupplierShopId());
        List<UccSkuPo> skuPoList = this.uccSkuMapper.qerySku(uccSkuPo);
        if (CollectionUtils.isEmpty(skuPoList)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u672a\u67e5\u8be2\u5230\u5bf9\u5e94SKU\u4fe1\u606f");
            return rspBo;
        }
        uccSkuPo = skuPoList.get(0);
        SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(reqBo.getSupplierShopId());
        if (supplierShopPo == null || supplierShopPo.getSupplierId() == null) {
            rspBo.setRespDesc("\u5e97\u94fa\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode("8888");
            return rspBo;
        }
        Long supplierId = supplierShopPo.getSupplierId();
        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(supplierId);
        if (supplierBusiPo == null || supplierBusiPo.getSupplierCode() == null) {
            rspBo.setRespDesc("\u4f9b\u5e94\u5546\u7f16\u7801\u67e5\u8be2\u51fa\u9519");
            rspBo.setRespCode("8888");
            return rspBo;
        }
        String supplierCode = supplierBusiPo.getSupplierCode();
        UccShufflingPicQryReqBO uccShufflingPicQryReqBo = new UccShufflingPicQryReqBO();
        uccShufflingPicQryReqBo.setSkuIds(Collections.singletonList(uccSkuPo.getExtSkuId()));
        uccShufflingPicQryReqBo.setSupplierCode(supplierCode);
        uccShufflingPicQryReqBo.setSupplierId(supplierId);
        UccShufflingPicQryRspBO uccShufflingPicQryRspBo = this.uccShufflingPicQryAtomService.qryShufflingPic(uccShufflingPicQryReqBo);
        if (!"0000".equals(uccShufflingPicQryRspBo.getRespCode())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(uccShufflingPicQryRspBo.getRespDesc());
            return rspBo;
        }
        if (!CollectionUtils.isEmpty(uccShufflingPicQryRspBo.getCommdShufflingPicInfos())) {
            rspBo.setSku(uccShufflingPicQryRspBo.getCommdShufflingPicInfos().get(0).getSku());
            rspBo.setJdCommdPicInfos(uccShufflingPicQryRspBo.getCommdShufflingPicInfos().get(0).getJdCommdPicInfos());
            rspBo.setNotJdCommdPicInfo(uccShufflingPicQryRspBo.getCommdShufflingPicInfos().get(0).getNotJdCommdPicInfo());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

