/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busi.impl.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.mq.proxy.DefaultProxyMessageConfig;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageConsumer;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.ohaotian.plugin.mq.proxy.status.ProxyConsumerStatus;
import com.tydic.commodity.bo.busi.MqSyncCommdPriceBo;
import com.tydic.commodity.bo.busi.MqSyncCommdPriceReqBo;
import com.tydic.commodity.bo.busi.MqSyncCommdPriceRspBo;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.busi.api.UccMqSyncCommdPriceBusiService;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.external.util.PropertiesUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public class UccSyncChangePriceServiceConsumer
extends DefaultProxyMessageConfig
implements ProxyMessageConsumer {
    private static final Logger log = LoggerFactory.getLogger(UccSyncChangePriceServiceConsumer.class);
    private static final Logger LOG = LoggerFactory.getLogger(UccSyncChangePriceServiceConsumer.class);
    private final boolean IS_DEBUG_ENABLED = LOG.isDebugEnabled();
    @Autowired
    private UccMqSyncCommdPriceBusiService uccMqSyncCommdPriceBusiService;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    public ProxyConsumerStatus onMessage(ProxyMessage proxyMessage) {
        if (this.IS_DEBUG_ENABLED) {
            LOG.debug("---------------\u4ef7\u683c\u5f02\u6b65\u63d0\u4ea4\u6d88\u8d39\u8005\u5f00\u59cb---------------");
        }
        MqSyncCommdPriceReqBo mqSyncCommdPriceReqBo = new MqSyncCommdPriceReqBo();
        try {
            List mqSyncCommdPriceBo = JSON.parseArray((String)proxyMessage.getContent(), MqSyncCommdPriceBo.class);
            mqSyncCommdPriceReqBo.setMqSyncCommdPriceBoList(mqSyncCommdPriceBo);
        }
        catch (Exception e) {
            log.error("UccSyncChangePriceServiceConsumer  =  " + e.getMessage());
        }
        if (this.IS_DEBUG_ENABLED) {
            LOG.debug("\u4ef7\u683c\u5f02\u6b65\u63d0\u4ea4\u8f6c\u6362\u540e\u5f97\u5230\u7684\u6d88\u8d39\u8005\u53c2\u6570\u4e3a\uff1a" + mqSyncCommdPriceReqBo.toString());
        }
        MqSyncCommdPriceRspBo mqSyncCommdPriceRspBo = this.uccMqSyncCommdPriceBusiService.dealSync(mqSyncCommdPriceReqBo);
        if (this.IS_DEBUG_ENABLED) {
            LOG.debug("---------------\u4ef7\u683c\u5f02\u6b65\u63d0\u4ea4\u6d88\u8d39\u8005\u7ed3\u675f---------------");
        }
        if ("0000".equals(mqSyncCommdPriceRspBo.getRespCode())) {
            this.syncEs(mqSyncCommdPriceReqBo.getMqSyncCommdPriceBoList());
        }
        return ProxyConsumerStatus.CONSUME_SUCCESS;
    }

    private void syncEs(List<MqSyncCommdPriceBo> mqSyncCommdPriceBoList) {
        Map<Long, List<MqSyncCommdPriceBo>> collect;
        if (!CollectionUtils.isEmpty(mqSyncCommdPriceBoList) && !CollectionUtils.isEmpty(collect = mqSyncCommdPriceBoList.stream().collect(Collectors.groupingBy(MqSyncCommdPriceBo::getSupplierShopId)))) {
            collect.forEach((supplierShopId, list) -> {
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    List skus = list.stream().map(MqSyncCommdPriceBo::getSkuId).distinct().collect(Collectors.toList());
                    SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
                    syncSceneCommodityToEsReqBO.setSkuIds(skus);
                    syncSceneCommodityToEsReqBO.setSupplierId(supplierShopId);
                    syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.OPER_ES_UPDATE_TYPE);
                    syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
                    syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_PRICE.intValue());
                    this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
                }
            });
        }
    }
}

