/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.tydic.commodity.external.bo.UccApplicationMasterDataSingleOnReqBO;
import com.tydic.commodity.external.bo.UccApplicationMasterDataSingleOnRspBO;
import com.tydic.commodity.external.service.UccApplicationMasterDataSingleSignOnService;
import com.tydic.commodity.external.util.SsoUtils;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="uccApplicationMasterDataSingleSignOnService")
public class UccApplicationMasterDataSingleSignOnServiceImpl
implements UccApplicationMasterDataSingleSignOnService {
    private static final SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    private static final Logger LOGGER = LoggerFactory.getLogger(UccApplicationMasterDataSingleSignOnServiceImpl.class);
    private static final String COND_SYSCODE = "wzbm";

    public UccApplicationMasterDataSingleOnRspBO applicationMasterDataSingleSign(UccApplicationMasterDataSingleOnReqBO reqBO) {
        UccApplicationMasterDataSingleOnRspBO rspBO = new UccApplicationMasterDataSingleOnRspBO();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(reqBO.getUserName()).append(simpleDateFormat.format(new Date()));
        String insertMaterialUrl = reqBO.getInsertMaterialUrl();
        if (StringUtils.isBlank((String)insertMaterialUrl)) {
            LOGGER.error("\u65b0\u589e\u7269\u6599\u4e3b\u6570\u636e\u5730\u5740\u4e3a\u7a7a");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            return rspBO;
        }
        try {
            LOGGER.info("\u7528\u6237\u540d\u548c\u65e5\u671f\u6570\u636e:" + stringBuilder.toString() + "\u79d8\u94a5\u6570\u636e:" + reqBO.getSecretKey());
            String md5Str = SsoUtils.ssoKey(stringBuilder.toString() + reqBO.getSecretKey());
            String propertysJson = URLEncoder.encode(reqBO.getPropertysjson(), "UTF-8");
            String dircetUrl = insertMaterialUrl + "?cond.syscode=" + COND_SYSCODE + "&cond.categorycode=" + reqBO.getCategoryCode() + "&cond.propertysjson=" + propertysJson.toLowerCase() + "";
            String urlEncoder = URLEncoder.encode(dircetUrl, "UTF-8");
            String postUrl = reqBO.getUrl() + "?ssou=" + reqBO.getUserName() + "&ssomd5=" + md5Str + "&ssourl=" + urlEncoder.toLowerCase() + "";
            rspBO.setRespDesc("\u6210\u529f");
            rspBO.setRespCode("0000");
            rspBO.setSingleOnUrl(postUrl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rspBO;
    }

    public static void main(String[] args) {
        UccApplicationMasterDataSingleSignOnServiceImpl singleSignOnService = new UccApplicationMasterDataSingleSignOnServiceImpl();
        UccApplicationMasterDataSingleOnReqBO reqBO = new UccApplicationMasterDataSingleOnReqBO();
        reqBO.setInsertMaterialUrl("http://172.20.8.58/mdmcode/mdm/sso/detail.dxml");
        String propertysJson = "[{\"98547568367111540\":\"123123\"},{\"98547568367111544\":\"1558484\"},{\"98547568367111546\":\"1234878\"}]";
        reqBO.setPropertysjson(propertysJson);
        reqBO.setUserName("yz");
        reqBO.setSecretKey("YYYYYXX28JHKLNGYJ");
        reqBO.setUrl("http://172.20.8.58/icore/sso/login");
        reqBO.setCategoryCode("010101");
        UccApplicationMasterDataSingleOnRspBO rspBO = singleSignOnService.applicationMasterDataSingleSign(reqBO);
        System.out.println(rspBO.getSingleOnUrl());
    }
}

