/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.external.bo.CommdStockBO;
import com.tydic.commodity.external.bo.SkuNumBO;
import com.tydic.commodity.external.bo.UccCurrentStockQryReqBO;
import com.tydic.commodity.external.bo.UccCurrentStockQryRspBO;
import com.tydic.commodity.external.service.UccCurrentStockQryService;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(value="uccCurrentStockQryService")
public class UccCurrentStockQryServiceImpl
implements UccCurrentStockQryService {
    private static final Log LOG = LogFactory.getLog(UccCurrentStockQryServiceImpl.class);

    public UccCurrentStockQryRspBO qryCommdCurrentStock(UccCurrentStockQryReqBO reqBO) {
        try {
            List<String> skus = reqBO.getSkuNum().stream().map(SkuNumBO::getSkuId).collect(Collectors.toList());
            String reqStr = this.initReqStr(reqBO);
            String hsn = reqBO.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_STOCK_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_STOCK_URL") + "]" + reqEsbStr));
                return this.setDefualtMsg(skus);
            }
            LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                LOG.error((Object)"\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                return this.setDefualtMsg(skus);
            }
            UccCurrentStockQryRspBO resolveRsp = this.resolveRsp(returnString, skus);
            if (resolveRsp != null) {
                LOG.info((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + resolveRsp.toString()));
            }
            return resolveRsp;
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage());
            UccCurrentStockQryRspBO rspBO = new UccCurrentStockQryRspBO();
            rspBO.setResultCode("8888");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5e93\u5b58\u63a5\u53e3\u5f02\u5e38");
            return rspBO;
        }
    }

    private String initReqStr(UccCurrentStockQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("skuNums", (Object)reqBO.getSkuNum());
        String area = "" + reqBO.getProvince() + "_" + reqBO.getCity() + "_" + reqBO.getCounty() + "";
        jsonObject.put("area", (Object)area);
        jsonObject.put("hsn", (Object)reqBO.getSupplierCode());
        return jsonObject.toString();
    }

    private UccCurrentStockQryRspBO resolveRsp(String returnString, List<String> skus) {
        UccCurrentStockQryRspBO rspBO = new UccCurrentStockQryRspBO();
        ArrayList<CommdStockBO> list = new ArrayList<CommdStockBO>();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setSuccess(((Boolean)rspJsonObject.get((Object)"success")).booleanValue());
            rspBO.setResultCode(rspJsonObject.get((Object)"resultCode").toString());
            rspBO.setResultMessage((String)rspJsonObject.get((Object)"resultMessage"));
            String respCode = (String)rspJsonObject.get((Object)"resultCode");
            if (!"0000".equals(respCode)) {
                if (!"2007".equals(respCode)) {
                    LOG.error((Object)("\u8c03\u7528\u5916\u90e8\u5e73\u53f0 \u5e93\u5b58\u6570\u91cf\u5b9e\u65f6\u67e5\u8be2\u63a5\u53e3 \u9519\u8bef:" + rspBO.getResultMessage()));
                    return this.setDefualtMsg(skus);
                }
                rspBO.setResultMessage("token\u5df2\u8fc7\u671f,\u8bf7\u91cd\u65b0\u5237\u65b0\u6216\u8005\u83b7\u53d6token");
                rspBO.setResultCode("8888");
                return rspBO;
            }
            JSONArray object = rspJsonObject.getJSONArray("result");
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    String jsonStr = JSONObject.toJSONString((Object)obj);
                    if (StringUtils.isEmpty((Object)jsonStr)) continue;
                    CommdStockBO jsonStringToJavaBean = (CommdStockBO)JSON.parseObject((String)jsonStr, CommdStockBO.class);
                    list.add(jsonStringToJavaBean);
                }
                rspBO.setCommdStockInfo(list);
            }
            List TrueRuslt = rspBO.getCommdStockInfo().stream().map(CommdStockBO::getSkuId).collect(Collectors.toList());
            skus.removeAll(TrueRuslt);
            if (!CollectionUtils.isEmpty(skus)) {
                UccCurrentStockQryRspBO bo = this.setDefualtMsg(skus);
                rspBO.getCommdStockInfo().addAll(bo.getCommdStockInfo());
            }
            return rspBO;
        }
        catch (Exception var10) {
            LOG.error((Object)("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10));
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }

    public UccCurrentStockQryRspBO setDefualtMsg(List<String> skus) {
        UccCurrentStockQryRspBO rspBO = new UccCurrentStockQryRspBO();
        if (!CollectionUtils.isEmpty(skus)) {
            ArrayList<CommdStockBO> commdStockInfo = new ArrayList<CommdStockBO>();
            for (String each : skus) {
                CommdStockBO bo = new CommdStockBO();
                bo.setStockStateId(Integer.valueOf(34));
                bo.setRemainNum(Integer.valueOf(0));
                bo.setStockStateDesc("\u65e0\u8d27");
                bo.setSkuId(each);
                commdStockInfo.add(bo);
            }
            rspBO.setCommdStockInfo(commdStockInfo);
        }
        rspBO.setRespCode("0000");
        rspBO.setResultCode("0000");
        rspBO.setSuccess(true);
        rspBO.setRespDesc("\u5e93\u5b58\u9ed8\u8ba4\u503c");
        return rspBO;
    }
}

