/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.external.bo.QryGiftFromEcommerceReqBo;
import com.tydic.commodity.external.bo.QryGiftFromEcommerceRspBo;
import com.tydic.commodity.external.bo.UccCommdDetailsQryReqBO;
import com.tydic.commodity.external.bo.UccCommdDetailsQryRspBO;
import com.tydic.commodity.external.service.UccCommdDetailsQryService;
import com.tydic.commodity.external.service.UccQryGiftFromEcommerceService;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.JsonUtils;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import com.tydic.commodity.external.vo.GiftRspVO;
import java.net.URI;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccQryGiftFromEcommerceService")
public class UccQryGiftFromEcommerceServiceImpl
implements UccQryGiftFromEcommerceService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccQryGiftFromEcommerceServiceImpl.class);
    @Autowired
    private UccCommdDetailsQryService uccCommdDetailsQryService;

    public QryGiftFromEcommerceRspBo qryGift(QryGiftFromEcommerceReqBo reqBo) {
        QryGiftFromEcommerceRspBo busiQrySKUGiftRspBO = new QryGiftFromEcommerceRspBo();
        try {
            String reqStr = this.initReqStr(reqBo);
            String hsn = reqBo.getSupplierCode();
            String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, hsn, "BUSINESS_COMMODITY");
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("ESB_QRY_SKU_GIFT_URL")), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOGGER.error("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("ESB_QRY_SKU_GIFT_URL") + "]");
                busiQrySKUGiftRspBO.setRespCode("8888");
                busiQrySKUGiftRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25");
                return busiQrySKUGiftRspBO;
            }
            String returnString = httpRetBean.getStr();
            LOGGER.debug("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\uff1a" + returnString);
            if (StringUtils.isEmpty((Object)returnString)) {
                busiQrySKUGiftRspBO.setRespCode("8888");
                busiQrySKUGiftRspBO.setRespDesc("\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a");
                return busiQrySKUGiftRspBO;
            }
            busiQrySKUGiftRspBO = this.resolveRspMsg(reqBo, returnString);
            List giftList = busiQrySKUGiftRspBO.getGifts();
            if (giftList != null && giftList.size() > 0) {
                for (GiftRspVO giftRspVO : giftList) {
                    UccCommdDetailsQryRspBO busiQrySKURspBO = this.qrySKUInfo(reqBo, giftRspVO);
                    if (busiQrySKURspBO == null || !busiQrySKURspBO.isSuccess()) continue;
                    if (busiQrySKURspBO.getResult().getJdBookInfo() != null) {
                        giftRspVO.setSkuName(busiQrySKURspBO.getResult().getJdBookInfo().getName());
                    }
                    if (busiQrySKURspBO.getResult().getJdCommdInfo() != null) {
                        giftRspVO.setSkuName(busiQrySKURspBO.getResult().getJdCommdInfo().getName());
                    }
                    if (busiQrySKURspBO.getResult().getJdVedioInfo() != null) {
                        giftRspVO.setSkuName(busiQrySKURspBO.getResult().getJdVedioInfo().getName());
                    }
                    if (busiQrySKURspBO.getResult().getNotJdCommdDetails() == null) continue;
                    giftRspVO.setSkuName(busiQrySKURspBO.getResult().getNotJdCommdDetails().getName());
                }
            }
            busiQrySKUGiftRspBO.setRespCode("0000");
            busiQrySKUGiftRspBO.setRespDesc("\u6210\u529f");
            return busiQrySKUGiftRspBO;
        }
        catch (Exception e) {
            LOGGER.error("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25:" + e);
            busiQrySKUGiftRspBO.setRespCode("8888");
            busiQrySKUGiftRspBO.setRespDesc("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u5931\u8d25");
            return busiQrySKUGiftRspBO;
        }
    }

    private UccCommdDetailsQryRspBO qrySKUInfo(QryGiftFromEcommerceReqBo busiQrySKUGiftReqBO, GiftRspVO giftRspVO) {
        UccCommdDetailsQryReqBO busiQrySKUReqBO = new UccCommdDetailsQryReqBO();
        busiQrySKUReqBO.setSkuId(giftRspVO.getSkuId().toString());
        busiQrySKUReqBO.setSupplierCode(busiQrySKUGiftReqBO.getSupplierCode());
        busiQrySKUReqBO.setShow(false);
        UccCommdDetailsQryRspBO uccCommdDetailsQryRspBO = this.uccCommdDetailsQryService.qryCommdDetails(busiQrySKUReqBO);
        return uccCommdDetailsQryRspBO;
    }

    private String initReqStr(QryGiftFromEcommerceReqBo busiQrySKUGiftReqBO) {
        StringBuffer sb = new StringBuffer();
        sb.append("{").append("\"skuId\":").append('\"' + busiQrySKUGiftReqBO.getSkuId() + '\"').append(",").append("\"province\":").append(busiQrySKUGiftReqBO.getProvince()).append(",").append("\"city\":").append(busiQrySKUGiftReqBO.getCity()).append(",").append("\"county\":").append(busiQrySKUGiftReqBO.getCounty()).append(",").append("\"town\":").append(busiQrySKUGiftReqBO.getTown()).append("}");
        return sb.toString();
    }

    private QryGiftFromEcommerceRspBo resolveRspMsg(QryGiftFromEcommerceReqBo QryGiftFromEcommerceReqBo2, String rspStr) {
        JSONObject jsonObject = JSONObject.parseObject((String)rspStr);
        QryGiftFromEcommerceRspBo busiQrySKUGiftRspBO = new QryGiftFromEcommerceRspBo();
        if ("0010".equals(jsonObject.get((Object)"resultCode"))) {
            busiQrySKUGiftRspBO.setRespCode("0000");
            busiQrySKUGiftRspBO.setRespDesc("\u8be5\u5546\u54c1\u65e0\u8d60\u54c1\u4fe1\u606f");
            return busiQrySKUGiftRspBO;
        }
        String resultStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
        if (((Boolean)jsonObject.get((Object)"success")).booleanValue()) {
            if (!StringUtils.isEmpty((Object)resultStr) && !"null".equals(resultStr)) {
                try {
                    busiQrySKUGiftRspBO = JsonUtils.jsonStringToJavaBean(JSONObject.toJSONString((Object)jsonObject.get((Object)"result")), QryGiftFromEcommerceRspBo.class);
                    busiQrySKUGiftRspBO.setRespCode("0000");
                    busiQrySKUGiftRspBO.setRespDesc("\u6210\u529f");
                    return busiQrySKUGiftRspBO;
                }
                catch (Exception e) {
                    LOGGER.error("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25" + e);
                    busiQrySKUGiftRspBO.setRespCode("8888");
                    busiQrySKUGiftRspBO.setRespDesc("\u89e3\u6790\u54cd\u5e94\u6570\u636e\u5931\u8d25");
                    return busiQrySKUGiftRspBO;
                }
            }
            busiQrySKUGiftRspBO.setRespCode("0000");
            busiQrySKUGiftRspBO.setRespDesc("\u8be5\u5546\u54c1\u65e0\u8d60\u54c1\u4fe1\u606f");
            return busiQrySKUGiftRspBO;
        }
        LOGGER.error("\u83b7\u53d6\u8d60\u54c1\u4e1a\u52a1\u670d\u52a1\u8c03\u7528\u80fd\u529b\u5e73\u53f0\u67e5\u8be2\u8d60\u54c1\u4fe1\u606f\u5931\u8d25:" + jsonObject.get((Object)"resultMessage"));
        busiQrySKUGiftRspBO.setRespCode("0000");
        busiQrySKUGiftRspBO.setRespDesc("\u8be5\u5546\u54c1\u65e0\u8d60\u54c1\u4fe1\u606f");
        return busiQrySKUGiftRspBO;
    }
}

