/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.DataInfo;
import com.tydic.commodity.external.bo.Splitpage;
import com.tydic.commodity.external.bo.UccInquiryOfMaterialListReqBO;
import com.tydic.commodity.external.bo.UccInquiryOfMaterialListRspBO;
import com.tydic.commodity.external.service.UccQueryGateWayInquiryOfMaterialListInMainDataOfMediumCoalService;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="uccQueryGateWayInquiryOfMaterialListInMainDataOfMediumCoalService")
public class UccQueryGateWayInquiryOfMaterialListInMainDataOfMediumCoalServiceImpl
implements UccQueryGateWayInquiryOfMaterialListInMainDataOfMediumCoalService {
    private static final Logger logger = LoggerFactory.getLogger(UccQueryGateWayInquiryOfMaterialListInMainDataOfMediumCoalServiceImpl.class);
    private final boolean isDebugEnabled = logger.isDebugEnabled();
    private final boolean isDebug = true;

    public UccInquiryOfMaterialListRspBO getInquiryOfMaterialList(UccInquiryOfMaterialListReqBO reqBO) {
        if (this.isDebugEnabled) {
            logger.debug("\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\uff1a" + reqBO.toString());
        }
        UccInquiryOfMaterialListRspBO rspBO = new UccInquiryOfMaterialListRspBO();
        String reqStr = this.initReqStr(reqBO);
        HttpRetBean httpRetBean = null;
        try {
            httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(reqBO.getUrl()), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001http,\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u67e5\u8be2\u5931\u8d25", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u67e5\u8be2\u5931\u8d25");
            return rspBO;
        }
        try {
            if (httpRetBean.getStatus() != 200) {
                logger.error("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u67e5\u8be2\u670d\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25,[http_status=" + httpRetBean.getStatus() + "], [http_url=" + reqBO.getUrl() + "]");
                throw new RuntimeException("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u67e5\u8be2\u670d\u52a1");
            }
            logger.info("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u67e5\u8be2\u670d\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((CharSequence)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u67e5\u8be2\u670d\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccInquiryOfMaterialListRspBO addCmsArticelSkuInfoRspBO = this.resolveRsp(returnString);
            if (!addCmsArticelSkuInfoRspBO.isSuccess()) {
                throw new BusinessException(addCmsArticelSkuInfoRspBO.getCode(), addCmsArticelSkuInfoRspBO.getMessage());
            }
            addCmsArticelSkuInfoRspBO.setRespDesc("\u6210\u529f");
            addCmsArticelSkuInfoRspBO.setSuccess(true);
            return addCmsArticelSkuInfoRspBO;
        }
        catch (BusinessException e) {
            logger.error("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868,\u54cd\u5e94\u8fd4\u56de\u9519\u8bef");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(e.getMsgInfo());
            return rspBO;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u5931\u8d25", (Throwable)e);
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u5931\u8d25");
            return rspBO;
        }
    }

    private static Integer getUUIDString() {
        Integer orderId = UUID.randomUUID().toString().hashCode();
        orderId = orderId < 0 ? -orderId.intValue() : orderId;
        return orderId;
    }

    private String initReqStr(UccInquiryOfMaterialListReqBO inquiryOfMaterialListReqBO) {
        String desc1 = null == inquiryOfMaterialListReqBO.getDesc1() ? "" : inquiryOfMaterialListReqBO.getDesc1();
        String descLong = null == inquiryOfMaterialListReqBO.getDesclong() ? "" : inquiryOfMaterialListReqBO.getDesclong();
        String categoryCode = null == inquiryOfMaterialListReqBO.getCateGoryCode() ? "" : inquiryOfMaterialListReqBO.getCateGoryCode();
        String code = null == inquiryOfMaterialListReqBO.getCode() ? "" : inquiryOfMaterialListReqBO.getCode();
        String reqStr = "{\n\t\"ESB\": {\n\t  \"appCode\":\"mainData\",\n\t\t\"DATA\": {\n\t\t\t\"DATAINFOS\": {\n\t\t\t\t\"DATAINFO\": [{\n\t\t\t\t\t\"CATEGORYCODE\": \"" + categoryCode + "\",\n\t\t\t\t\t\"CODE\": \"" + code + "\",\n\t\t\t\t\t\"DESC1\": \"" + desc1 + "\",\n\t\t\t\t\t\"DESCLONG\": \"" + descLong + "\"\n\t\t\t\t}],\n\t\t\t\t\"PUUID\": \"" + UccQueryGateWayInquiryOfMaterialListInMainDataOfMediumCoalServiceImpl.getUUIDString() + "\"\n\t\t\t},\n\t\t\t\"SPLITPAGE\": {\n\t\t\t\t\"COUNTPERPAGE\": \"" + inquiryOfMaterialListReqBO.getCountperpage() + "\",\n\t\t\t\t\"CURRENTPAGE\": \"" + inquiryOfMaterialListReqBO.getCurrentpage() + "\"\n\t\t\t}\n\t\t}\n\t}\n}\n";
        return reqStr;
    }

    public static void main(String[] args) {
        System.out.println(UccQueryGateWayInquiryOfMaterialListInMainDataOfMediumCoalServiceImpl.getUUIDString());
    }

    private UccInquiryOfMaterialListRspBO resolveRsp(String returnString) {
        UccInquiryOfMaterialListRspBO rspBO = new UccInquiryOfMaterialListRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            JSONObject esb = rspJsonObject.getJSONObject("ESB");
            JSONObject data = esb.getJSONObject("DATA");
            JSONObject DATAINFOS = data.getJSONObject("DATAINFOS");
            JSONArray jsonArray = DATAINFOS.getJSONArray("DATAINFO");
            JSONObject SPLITPAGE = data.getJSONObject("SPLITPAGE");
            ArrayList<DataInfo> dataInfos = new ArrayList<DataInfo>();
            int size = jsonArray.size();
            for (int i = 0; i < size; ++i) {
                JSONObject jsonObject = jsonArray.getJSONObject(i);
                DataInfo dataInfo = new DataInfo();
                dataInfo.setCATEGORYCODE(jsonObject.getString("CATEGORYCODE"));
                dataInfo.setCODE(jsonObject.getString("CODE"));
                dataInfo.setDESC1(jsonObject.getString("DESC1"));
                dataInfo.setDESC19(jsonObject.getString("DESC19"));
                dataInfo.setDESC2(jsonObject.getString("DESC2"));
                dataInfo.setDESC3(jsonObject.getString("DESC3"));
                dataInfo.setDESC5(jsonObject.getString("DESC5"));
                dataInfo.setDESC4(jsonObject.getString("DESC4"));
                dataInfo.setDESCLONG(jsonObject.getString("DESCLONG"));
                dataInfo.setUUID(jsonObject.getString("UUID"));
                dataInfos.add(dataInfo);
            }
            Splitpage splitpage = new Splitpage();
            splitpage.setCOUNTPERPAGE(SPLITPAGE.getInteger("COUNTPERPAGE"));
            splitpage.setCURRENTPAGE(SPLITPAGE.getInteger("CURRENTPAGE"));
            splitpage.setTOTALNUMBER(SPLITPAGE.getInteger("TOTALNUMBER"));
            splitpage.setTOTALPAGES(SPLITPAGE.getInteger("TOTALPAGES"));
            rspBO.setPageNo(SPLITPAGE.getInteger("CURRENTPAGE").intValue());
            rspBO.setRecordsTotal(SPLITPAGE.getInteger("TOTALNUMBER").intValue());
            rspBO.setTotal(SPLITPAGE.getInteger("TOTALPAGES").intValue());
            rspBO.setRows(dataInfos);
            rspBO.setSuccess(true);
            return rspBO;
        }
        catch (Exception var10) {
            logger.error("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u54cd\u5e94\u62a5\u6587\u5931\u8d25\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u4e3b\u6570\u636e\u7269\u6599\u5217\u8868\u5931\u8d25\uff1a" + var10);
        }
    }

    public class DataInfos {
        public List<DataInfo> DATAINFO;

        public List<DataInfo> getDATAINFO() {
            return this.DATAINFO;
        }

        public void setDATAINFO(List<DataInfo> DATAINFO) {
            this.DATAINFO = DATAINFO;
        }
    }

    public class Datas {
        public DataInfos DATAINFOS;
        private Splitpage SPLITPAGE;

        public DataInfos getDATAINFOS() {
            return this.DATAINFOS;
        }

        public void setDATAINFOS(DataInfos DATAINFOS) {
            this.DATAINFOS = DATAINFOS;
        }

        public Splitpage getSPLITPAGE() {
            return this.SPLITPAGE;
        }

        public void setSPLITPAGE(Splitpage SPLITPAGE) {
            this.SPLITPAGE = SPLITPAGE;
        }
    }

    public class ESB {
        private Datas DATA;
        private String DESC;
        private String RESULT;

        public Datas getDATA() {
            return this.DATA;
        }

        public void setDATA(Datas DATA) {
            this.DATA = DATA;
        }

        public String getDESC() {
            return this.DESC;
        }

        public void setDESC(String DESC) {
            this.DESC = DESC;
        }

        public String getRESULT() {
            return this.RESULT;
        }

        public void setRESULT(String RESULT) {
            this.RESULT = RESULT;
        }
    }

    public class ESBRspReturnObject {
        private ESB ESB;

        public ESB getESB() {
            return this.ESB;
        }

        public void setESB(ESB ESB2) {
            this.ESB = ESB2;
        }
    }
}

