/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.UccRemoveSkuInfoReqBO;
import com.tydic.commodity.external.bo.UccRemoveSkuInfoRspBO;
import com.tydic.commodity.external.service.UccRemoveCmsSkuInfoService;
import com.tydic.commodity.external.service.impl.UccQryMsgFromInterServiceImpl;
import com.tydic.commodity.external.util.ESBParamUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.stereotype.Service;

@Service(value="uccRemoveCmsSkuInfoService")
public class UccRemoveCmsSkuInfoServiceImpl
implements UccRemoveCmsSkuInfoService {
    private static final Log LOG = LogFactory.getLog(UccQryMsgFromInterServiceImpl.class);

    public UccRemoveSkuInfoRspBO removeCmsSkuInfo(UccRemoveSkuInfoReqBO reqBO) {
        UccRemoveSkuInfoRspBO uccRemoveSkuInfoRspBO = new UccRemoveSkuInfoRspBO();
        try {
            for (String columeCode : reqBO.getColumnCode()) {
                String reqStr = this.initReqStr(columeCode);
                String reqEsbStr = ESBParamUtil.getEsbReqStr(reqStr, null, "BUSINESS_COMMODITY");
                HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(reqBO.getUrl()), HSNHttpHeader.getRequestHeaders("json"), reqEsbStr.getBytes("UTF-8"), "UTF-8", false);
                if (httpRetBean.getStatus() != 200) {
                    LOG.error((Object)("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25,[http_status=" + httpRetBean.getStatus() + "], [http_url=" + reqBO.getUrl() + "]"));
                    throw new RuntimeException("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1\u4e1a\u52a1\u5931\u8d25");
                }
                LOG.info((Object)("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr()));
                String returnString = httpRetBean.getStr();
                if (StringUtils.isEmpty((CharSequence)returnString)) {
                    throw new RuntimeException("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
                }
                UccRemoveSkuInfoRspBO removeSkuInfoRspBO = this.resolveRsp(returnString);
                if (removeSkuInfoRspBO.isSuccess()) continue;
                throw new BusinessException(removeSkuInfoRspBO.getCode(), removeSkuInfoRspBO.getMessage());
            }
        }
        catch (BusinessException e) {
            LOG.error((Object)"\u53d1\u9001http,\u5220\u9664cms\uff0csku\u4fe1\u606f\u5931\u8d25");
            uccRemoveSkuInfoRspBO.setRespCode("8888");
            uccRemoveSkuInfoRspBO.setRespDesc(e.getMsgInfo());
            return uccRemoveSkuInfoRspBO;
        }
        catch (Exception e) {
            LOG.error((Object)"\u53d1\u9001http,\u5220\u9664cms\uff0csku\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            uccRemoveSkuInfoRspBO.setRespCode("8888");
            uccRemoveSkuInfoRspBO.setRespDesc("\u5220\u9664cms\u7684sku\u4fe1\u606f\u5931\u8d25");
            return uccRemoveSkuInfoRspBO;
        }
        uccRemoveSkuInfoRspBO.setRespCode("0000");
        uccRemoveSkuInfoRspBO.setRespDesc("\u6210\u529f");
        uccRemoveSkuInfoRspBO.setSuccess(true);
        return uccRemoveSkuInfoRspBO;
    }

    private String initReqStr(String columeCode) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", (Object)columeCode);
        return jsonObject.toString();
    }

    private UccRemoveSkuInfoRspBO resolveRsp(String returnString) {
        UccRemoveSkuInfoRspBO removeSkuInfoRspBO = new UccRemoveSkuInfoRspBO();
        try {
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            removeSkuInfoRspBO.setSuccess(((Boolean)rspJsonObject.get((Object)"success")).booleanValue());
            removeSkuInfoRspBO.setCode(String.valueOf(rspJsonObject.get((Object)"code")));
            removeSkuInfoRspBO.setMessage((String)rspJsonObject.get((Object)"message"));
            return removeSkuInfoRspBO;
        }
        catch (Exception var10) {
            LOG.error((Object)("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10));
            throw new RuntimeException("\u5220\u9664\u680f\u76ee\u4e1a\u52a1\u670d\u52a1\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }
}

