/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.external.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.bo.CommdStockBO;
import com.tydic.commodity.external.bo.UccTmCommdStockQryReqBO;
import com.tydic.commodity.external.bo.UccTmCommdStockQryRspBO;
import com.tydic.commodity.external.bo.UccTmStockBO;
import com.tydic.commodity.external.service.UccTmCommdStockQryService;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.external.util.SignUtil;
import com.tydic.commodity.external.util.http.HSHttpHelper;
import com.tydic.commodity.external.util.http.HSNHttpHeader;
import com.tydic.commodity.external.util.http.HttpRetBean;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service(value="uccTmCommdStockQryService")
public class UccTmCommdStockQryServiceImpl
implements UccTmCommdStockQryService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccTmCommdStockQryServiceImpl.class);
    @Value(value="${linkmall_app_key}")
    private String appKey;
    @Value(value="${linkmall_appSecret}")
    private String appSecret;

    public UccTmCommdStockQryRspBO qryStock(UccTmCommdStockQryReqBO reqBO) {
        try {
            String reqStr = this.initReqStr(reqBO);
            HttpRetBean httpRetBean = HSHttpHelper.doUrlPostRequest(new URI(PropertiesUtil.getProperty("TM_QRY_STOCK_URL")), HSNHttpHeader.getRequestHeaders("json"), reqStr.getBytes("UTF-8"), "UTF-8", false);
            if (httpRetBean.getStatus() != 200) {
                LOGGER.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u5931\u8d25[http_status=" + httpRetBean.getStatus() + "], [http_url=" + PropertiesUtil.getProperty("TM_QRY_STOCK_URL") + "]");
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u5931\u8d25");
            }
            LOGGER.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u63a5\u53e3\u8fd4\u56de\u54cd\u5e94\u62a5\u6587\uff1a" + httpRetBean.getStr());
            String returnString = httpRetBean.getStr();
            if (StringUtils.isEmpty((Object)returnString)) {
                throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u7cfb\u7edf\u54cd\u5e94\u62a5\u6587\u4e3a\u7a7a\uff01");
            }
            UccTmCommdStockQryRspBO rspBO = this.resolveRsp(returnString, reqBO);
            if (rspBO != null) {
                LOGGER.info("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1-\u89e3\u6790\u54cd\u5e94\u6570\u636e\uff1a" + rspBO.toString());
            }
            return rspBO;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
    }

    private String initReqStr(UccTmCommdStockQryReqBO reqBO) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("divisionCode", (Object)reqBO.getDivisionCode());
        jsonObject.put("itemList", (Object)reqBO.getItemList());
        String sign = this.getSign(reqBO);
        jsonObject.put("sign", (Object)sign);
        jsonObject.put("appKey", (Object)this.appKey);
        jsonObject.put("ip", (Object)"");
        return jsonObject.toString();
    }

    private UccTmCommdStockQryRspBO resolveRsp(String returnString, UccTmCommdStockQryReqBO reqBO) {
        UccTmCommdStockQryRspBO rspBO = new UccTmCommdStockQryRspBO();
        try {
            ArrayList<CommdStockBO> commdStockBOS = new ArrayList<CommdStockBO>();
            JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
            rspBO.setRespCode(rspJsonObject.get((Object)"code").toString());
            rspBO.setRespDesc(rspJsonObject.get((Object)"message").toString());
            if (!"0000".equals(rspBO.getRespCode())) {
                for (UccTmStockBO each : reqBO.getItemList()) {
                    for (Long sku : each.getSkuIdLists()) {
                        CommdStockBO commdStockBO = new CommdStockBO();
                        commdStockBO.setSkuId(sku.toString());
                        commdStockBO.setCommdExtSkuId(each.getItemId().toString());
                        commdStockBO.setRemainNum(Integer.valueOf(0));
                        commdStockBOS.add(commdStockBO);
                    }
                }
                rspBO.setRespCode("0000");
                rspBO.setItemList(commdStockBOS);
                return rspBO;
            }
            JSONObject data = (JSONObject)rspJsonObject.get((Object)"data");
            JSONArray object = data.getJSONArray("itemList");
            if (null != object) {
                for (int i = 0; i < object.size(); ++i) {
                    JSONObject obj = (JSONObject)object.get(i);
                    JSONArray skuList = obj.getJSONArray("skuInfos");
                    if (null == skuList) continue;
                    for (int j = 0; j < skuList.size(); ++j) {
                        CommdStockBO commdStockBO = new CommdStockBO();
                        JSONObject jsonObject = (JSONObject)skuList.get(j);
                        commdStockBO.setSkuId(jsonObject.get((Object)"skuId").toString());
                        commdStockBO.setCommdExtSkuId(obj.get((Object)"itemId").toString());
                        commdStockBO.setRemainNum((Integer)jsonObject.get((Object)"stock"));
                        commdStockBOS.add(commdStockBO);
                    }
                }
                rspBO.setItemList(commdStockBOS);
            }
            return rspBO;
        }
        catch (Exception var10) {
            LOGGER.error("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
            throw new RuntimeException("\u83b7\u53d6\u6d88\u606f\u63a8\u9001\u4fe1\u606f\u4e1a\u52a1\u63a5\u53e3\u89e3\u6790\u54cd\u5e94\u62a5\u6587\u51fa\u9519\uff1a" + var10);
        }
    }

    private String getSign(Long itemId, List<Long> skuList, String divisionCode) {
        HashMap<String, String> paramStockString = new HashMap<String, String>();
        JSONObject jsonDatas = new JSONObject();
        JSONArray stocks = new JSONArray();
        ArrayList<Long> skus = new ArrayList<Long>();
        skus.addAll(skuList);
        jsonDatas.put("itemId", (Object)itemId);
        jsonDatas.put("skuIdLists", skus);
        stocks.add((Object)jsonDatas);
        paramStockString.put("appKey", this.appKey);
        paramStockString.put("itemList", stocks.toString());
        paramStockString.put("divisionCode", divisionCode);
        paramStockString.put("ip", null);
        System.out.println("\u5165\u53c2\uff1a" + paramStockString);
        String sign = "";
        try {
            sign = SignUtil.getSignMp(paramStockString, this.appSecret);
            LOGGER.info("\u5546\u54c1\u5e93\u5b58\uff1a" + sign);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sign;
    }

    private String getSign(UccTmCommdStockQryReqBO reqBO) {
        HashMap<String, String> paramStockString = new HashMap<String, String>();
        JSONObject jsonDatas = new JSONObject();
        jsonDatas.put("itemId", (Object)reqBO.getItemList());
        paramStockString.put("appKey", this.appKey);
        paramStockString.put("itemList", JSONObject.parseArray((String)JSONObject.toJSONString((Object)reqBO.getItemList())).toString());
        paramStockString.put("divisionCode", reqBO.getDivisionCode());
        paramStockString.put("ip", null);
        LOGGER.info("\u5165\u53c2\uff1a" + paramStockString);
        String sign = "";
        try {
            sign = SignUtil.getSignMp(paramStockString, this.appSecret);
            System.out.println("\u5546\u54c1\u5e93\u5b58\uff1a" + sign);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sign;
    }
}

