/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.search.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.bo.ability.QueryParam;
import com.tydic.commodity.search.SearchCommodityService;
import com.tydic.commodity.search.SearchEsQueryService;
import com.tydic.commodity.search.SearchEsSQLService;
import com.tydic.commodity.search.bo.QueryParamBO;
import com.tydic.commodity.search.bo.SearchEsReqBO;
import com.tydic.commodity.search.bo.SearchEsRspBo;
import com.tydic.commodity.search.bo.SearchEsSQLReqBO;
import com.tydic.commodity.search.bo.SearchEsSQLRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class SearchCommodityServiceImpl
implements SearchCommodityService {
    private static final Logger LOGGER = LogManager.getLogger(SearchCommodityServiceImpl.class);
    @Autowired
    private SearchEsSQLService searchEsSQLService;
    @Autowired
    private SearchEsQueryService searchEsQueryService;

    @Override
    public SearchEsRspBo queryByMatch(SearchEsReqBO reqBO) {
        SearchEsRspBo bo = new SearchEsRspBo();
        SearchEsSQLReqBO searchEsSQLReqBO = new SearchEsSQLReqBO();
        BeanUtils.copyProperties((Object)((Object)reqBO), (Object)searchEsSQLReqBO);
        if (reqBO.getCategoryIds() != null && reqBO.getCategoryIds().size() > 0) {
            searchEsSQLReqBO.setCategoryIds(reqBO.getCategoryIds());
        }
        if (reqBO.getSkuList() != null && reqBO.getSkuList().size() > 0) {
            searchEsSQLReqBO.setSkuList(reqBO.getSkuList());
        }
        if (!StringUtils.isEmpty((Object)reqBO.getQueryChannelId())) {
            searchEsSQLReqBO.setSearchChannel(reqBO.getQueryChannelId());
        }
        List params = null;
        ArrayList<QueryParamBO> queryParamBOs = new ArrayList<QueryParamBO>();
        if (CollectionUtils.isNotEmpty(reqBO.getQueryParams())) {
            params = JSON.parseArray((String)JSON.toJSONString(reqBO.getQueryParams()), QueryParam.class);
            for (QueryParam queryParam : params) {
                QueryParamBO queryParamBO = new QueryParamBO();
                BeanUtils.copyProperties((Object)queryParam, (Object)queryParamBO);
                queryParamBOs.add(queryParamBO);
            }
        }
        searchEsSQLReqBO.setQueryParams(queryParamBOs);
        SearchEsSQLRspBO builderSQL = this.searchEsSQLService.buildSQL(searchEsSQLReqBO);
        builderSQL.setField(reqBO.isIsField());
        builderSQL.setNeedKeyWorld(reqBO.isNeedKeyWorld());
        SearchEsRspBo rspBo = this.searchEsQueryService.executeSQL(builderSQL);
        List<QueryParam> propParams = rspBo.getPropParams();
        if (CollectionUtils.isNotEmpty((Collection)params)) {
            HashSet<String> queryFilterIds = new HashSet<String>();
            for (QueryParam queryParam : params) {
                queryFilterIds.add(queryParam.getFilterId());
            }
            HashSet<String> filterIdSet = new HashSet<String>();
            HashSet<QueryParam> h1 = new HashSet<QueryParam>();
            if (propParams != null && propParams.size() > 0) {
                for (QueryParam queryParam : propParams) {
                    String filterId = queryParam.getFilterId();
                    if (!filterIdSet.contains(filterId) && !queryFilterIds.contains(filterId)) {
                        h1.add(queryParam);
                    }
                    filterIdSet.add(filterId);
                }
                propParams.clear();
                propParams.addAll(h1);
            }
        }
        rspBo.setPropParams(propParams);
        return rspBo;
    }
}

