/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.search.impl;

import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.search.SearchEsSQLService;
import com.tydic.commodity.search.bo.CompareEsSQLReqBo;
import com.tydic.commodity.search.bo.CompareEsSQLRspBo;
import com.tydic.commodity.search.bo.QueryParamBO;
import com.tydic.commodity.search.bo.SearchEsSQLReqBO;
import com.tydic.commodity.search.bo.SearchEsSQLRspBO;
import com.tydic.commodity.search.bo.UccFieldsSearchEsBo;
import com.tydic.commodity.search.bo.UccFieldsSearchExtEsBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.common.lucene.search.function.FunctionScoreQuery;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.MultiMatchQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.functionscore.FunctionScoreQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class SearchEsSQLServiceImpl
implements SearchEsSQLService {
    private static final Logger LOGGER = LoggerFactory.getLogger(SearchEsSQLServiceImpl.class);
    @Value(value="${search_phrase}")
    private String searchPhrase;
    @Autowired
    private CacheClient cacheClient;

    @Override
    public SearchEsSQLRspBO buildSQL(SearchEsSQLReqBO searchEsSQLReqBO) {
        long[] skus;
        int i;
        SearchEsSQLRspBO searchBarEsSQLRspBO = new SearchEsSQLRspBO();
        BoolQueryBuilder extBoolQueryBuilder = QueryBuilders.boolQuery();
        BoolQueryBuilder inBoolQueryBuilder = QueryBuilders.boolQuery();
        if (searchEsSQLReqBO.getSceneId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"scene_id", (Object)searchEsSQLReqBO.getSceneId()));
        }
        if (searchEsSQLReqBO.getSkuStatus() != null && searchEsSQLReqBO.getSkuStatus().size() > 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", searchEsSQLReqBO.getSkuStatus()));
        }
        if (searchEsSQLReqBO.getQueryLocation() != null && searchEsSQLReqBO.getQueryLocation() != 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_location", (Object)searchEsSQLReqBO.getQueryLocation()));
        }
        if (searchEsSQLReqBO.getSearchChannel() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"channel_id", (Object)searchEsSQLReqBO.getSearchChannel()));
        }
        if (searchEsSQLReqBO.getSupplierShopIds() != null && searchEsSQLReqBO.getSupplierShopIds().size() > 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_shop_id", searchEsSQLReqBO.getSupplierShopIds()));
        }
        if (searchEsSQLReqBO.getSupplierId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)searchEsSQLReqBO.getSupplierId()));
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"unuse_suppliershop_list", (Object)searchEsSQLReqBO.getSupplierId()));
        }
        if (searchEsSQLReqBO.getMerchantId() != null) {
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"unuse_suppliershop_list", (Object)searchEsSQLReqBO.getMerchantId()));
        }
        if (searchEsSQLReqBO.getBrandIds() != null && searchEsSQLReqBO.getBrandIds().size() > 0) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"brand_id", searchEsSQLReqBO.getBrandIds()));
        }
        if (searchEsSQLReqBO.getVendorId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)searchEsSQLReqBO.getVendorId()));
        }
        if (searchEsSQLReqBO.getTypeId() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)searchEsSQLReqBO.getTypeId()));
        }
        if (searchEsSQLReqBO.getTypeName() != null) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_name", (String)searchEsSQLReqBO.getTypeName()));
        }
        if (searchEsSQLReqBO.getCommdIds() != null && searchEsSQLReqBO.getCommdIds().size() > 0) {
            long[] commd = new long[searchEsSQLReqBO.getCommdIds().size()];
            for (i = 0; i < searchEsSQLReqBO.getCommdIds().size(); ++i) {
                commd[i] = searchEsSQLReqBO.getCommdIds().get(i);
            }
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", (long[])commd));
        }
        if (searchEsSQLReqBO.getSkuList() != null && searchEsSQLReqBO.getSkuList().size() > 0) {
            skus = new long[searchEsSQLReqBO.getSkuList().size()];
            for (i = 0; i < searchEsSQLReqBO.getSkuList().size(); ++i) {
                skus[i] = searchEsSQLReqBO.getSkuList().get(i);
            }
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (long[])skus));
        }
        if (searchEsSQLReqBO.getIgnoreList() != null && searchEsSQLReqBO.getIgnoreList().size() > 0) {
            skus = new long[searchEsSQLReqBO.getIgnoreList().size()];
            for (i = 0; i < searchEsSQLReqBO.getIgnoreList().size(); ++i) {
                skus[i] = searchEsSQLReqBO.getIgnoreList().get(i);
            }
            extBoolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (long[])skus));
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("SearchEsSQLServiceImpl \uff1a \u8d70\u67e5\u8be2\u8ff7\u7cca\u5339\u914d search_phrase\uff1a" + this.searchPhrase);
        }
        float minScore = 4.0f;
        if (!StringUtils.isEmpty((String)searchEsSQLReqBO.getQueryStr())) {
            Object fields;
            FunctionScoreQueryBuilder functionScoreQueryBuilder = QueryBuilders.functionScoreQuery((QueryBuilder)extBoolQueryBuilder);
            Object obj = this.cacheClient.get("UCC_FIELDS_SEARCH");
            UccFieldsSearchEsBo esBo = null;
            if (obj != null) {
                try {
                    esBo = (UccFieldsSearchEsBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)obj), UccFieldsSearchEsBo.class);
                }
                catch (Exception e) {
                    LOGGER.error("\u6570\u636e\u8f6c\u6362\u5f02\u5e38 \uff1a " + JSONObject.toJSONString((Object)obj));
                }
            }
            if (esBo != null) {
                minScore = esBo.getMinScore().floatValue();
                fields = new HashedMap();
                Map<Integer, List<UccFieldsSearchExtEsBo>> fieldsListMap = this.groupByfieldsType(esBo.getFields());
                if (!fieldsListMap.isEmpty()) {
                    for (Map.Entry<Integer, List<UccFieldsSearchExtEsBo>> entry : fieldsListMap.entrySet()) {
                        if (entry.getKey() == 3) {
                            fields = entry.getValue().stream().collect(Collectors.toMap(UccFieldsSearchExtEsBo::getFields, UccFieldsSearchExtEsBo::getBoot));
                        }
                        if (!searchEsSQLReqBO.getQueryStr().matches("^[0-9]{4,}$") || entry.getKey() != 1) continue;
                        for (UccFieldsSearchExtEsBo field : entry.getValue()) {
                            inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)field.getFields(), (Object)searchEsSQLReqBO.getQueryStr()).boost(field.getBoot().floatValue()));
                        }
                    }
                }
                HashedMap fieldsf = new HashedMap();
                for (Map.Entry each : fields.entrySet()) {
                    fieldsf.put(each.getKey(), Float.valueOf(((BigDecimal)each.getValue()).floatValue()));
                }
                if ("true".equals(this.searchPhrase)) {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchEsSQLReqBO.getQueryStr(), (String[])new String[0]).fields((Map)fieldsf).type((Object)esBo.getParseField()).tieBreaker(1.0f).type((Object)"phrase").slop(esBo.getSlop().intValue()));
                } else {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchEsSQLReqBO.getQueryStr(), (String[])new String[0]).fields((Map)fieldsf).minimumShouldMatch(new StringBuffer(esBo.getAnalysisModulus().toString()).append("%").toString()).type((Object)esBo.getParseField()).analyzer(esBo.getAnalyzer())).boost();
                }
            } else if ("true".equals(this.searchPhrase)) {
                String[] fileNames = new String[]{"ext_sku_id", "sku_name", "commodity_name", "brand_name", "supplier_name", "l2_category_name", "l3_category_name", "properties", "manufacturer", "figure", "model", "material_name", "l4mg_category_name"};
                inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchEsSQLReqBO.getQueryStr(), (String[])fileNames).type(MultiMatchQueryBuilder.Type.BEST_FIELDS).tieBreaker(1.0f).type((Object)"phrase").slop(20));
                if (searchEsSQLReqBO.getQueryStr().matches("^[0-9]{4,}$")) {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"sku_id", (Object)searchEsSQLReqBO.getQueryStr()));
                }
            } else {
                fields = new HashedMap();
                fields.put("type_name", Float.valueOf(20.0f));
                fields.put("brand_name", Float.valueOf(12.0f));
                fields.put("supplier_name", Float.valueOf(10.0f));
                fields.put("l3_category_name", Float.valueOf(10.0f));
                fields.put("l2_category_name", Float.valueOf(7.0f));
                fields.put("sku_name", Float.valueOf(5.0f));
                fields.put("ext_sku_id", Float.valueOf(1.0f));
                fields.put("properties", Float.valueOf(1.0f));
                fields.put("manufacturer", Float.valueOf(1.0f));
                fields.put("figure", Float.valueOf(1.0f));
                fields.put("model", Float.valueOf(1.0f));
                fields.put("material_name", Float.valueOf(1.0f));
                fields.put("l4mg_category_name", Float.valueOf(1.0f));
                inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.multiMatchQuery((Object)searchEsSQLReqBO.getQueryStr(), (String[])new String[0]).fields((Map)fields).minimumShouldMatch("95%").type(MultiMatchQueryBuilder.Type.MOST_FIELDS).analyzer("ik_smart")).boost();
                if (searchEsSQLReqBO.getQueryStr().matches("^[0-9]{4,}$")) {
                    inBoolQueryBuilder.should((QueryBuilder)QueryBuilders.matchPhraseQuery((String)"sku_id", (Object)searchEsSQLReqBO.getQueryStr())).boost(20.0f);
                }
            }
            extBoolQueryBuilder.must((QueryBuilder)inBoolQueryBuilder);
            functionScoreQueryBuilder.scoreMode(FunctionScoreQuery.ScoreMode.SUM);
            if (!StringUtils.isEmpty((String)searchEsSQLReqBO.getQueryStr())) {
                functionScoreQueryBuilder.setMinScore(minScore);
            }
            searchBarEsSQLRspBO.setFunctionScoreQueryBuilder(functionScoreQueryBuilder);
        }
        LinkedList<String> hiddenParamsForRsp = new LinkedList<String>();
        if (searchEsSQLReqBO.getQueryParams() != null) {
            for (int i2 = 0; i2 < searchEsSQLReqBO.getQueryParams().size(); ++i2) {
                int j;
                QueryParamBO param = searchEsSQLReqBO.getQueryParams().get(i2);
                hiddenParamsForRsp.add(param.getFilterId());
                BoolQueryBuilder boolQueryBuilder2 = QueryBuilders.boolQuery();
                if ("supplier_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"supplier_name.keyword", (String)param.getFilterValues().get(j))));
                    }
                    continue;
                }
                if ("brand_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"brand_name.keyword", (String)param.getFilterValues().get(j))));
                    }
                    continue;
                }
                if ("l3_category_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_name.keyword", (String)param.getFilterValues().get(j))));
                    }
                    continue;
                }
                if ("vendor_id_name".equals(param.getFilterId())) {
                    for (j = 0; j < param.getFilterValues().size(); ++j) {
                        extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.termQuery((String)"vendor_name.keyword", (String)param.getFilterValues().get(j))));
                    }
                    continue;
                }
                for (j = 0; j < param.getFilterValues().size(); ++j) {
                    extBoolQueryBuilder.must((QueryBuilder)boolQueryBuilder2.should((QueryBuilder)QueryBuilders.matchQuery((String)"properties", (Object)param.getFilterValues().get(j))));
                }
            }
        }
        if (searchEsSQLReqBO.getCategoryIds() != null && searchEsSQLReqBO.getCategoryIds().size() > 0 && searchEsSQLReqBO.getLevel() != null) {
            if (searchEsSQLReqBO.getLevel() == 1) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l1_category_id", searchEsSQLReqBO.getCategoryIds()));
            } else if (searchEsSQLReqBO.getLevel() == 2) {
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l2_category_id", searchEsSQLReqBO.getCategoryIds()));
            } else if (searchEsSQLReqBO.getLevel() == 3) {
                Integer queryLocation = searchEsSQLReqBO.getQueryLocation();
                queryLocation = queryLocation == null ? 0 : queryLocation;
                LOGGER.error("Sku location {}", (Object)queryLocation);
                extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l3_category_id", searchEsSQLReqBO.getCategoryIds()));
            }
        }
        try {
            RangeQueryBuilder qb = null;
            if (null != searchEsSQLReqBO.getMinSalesPrice()) {
                qb = searchEsSQLReqBO.getMinSalesPrice().compareTo(BigDecimal.ZERO) != 0 ? QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)searchEsSQLReqBO.getMinSalesPrice())) : QueryBuilders.rangeQuery((String)"sale_price").gte((Object)0);
            }
            if (null != searchEsSQLReqBO.getMaxSalesPrice() && searchEsSQLReqBO.getMaxSalesPrice().compareTo(BigDecimal.ZERO) != 0 && null != qb) {
                qb.lte((Object)MoneyUtils.BigDecimal2Long((BigDecimal)searchEsSQLReqBO.getMaxSalesPrice()));
            }
            if (qb != null) {
                extBoolQueryBuilder.must(qb);
            }
        }
        catch (Exception e) {
            throw new BusinessException("RSP_CODE_BUSI_SERVICE_ERROR", "\u6700\u4f4e\u9500\u552e\u4ef7\u683c\u6216\u6700\u9ad8\u9500\u552e\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38\uff01");
        }
        SortOrder orderType = SortOrder.DESC;
        if (searchEsSQLReqBO.getOrderType() != null && searchEsSQLReqBO.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        if (searchEsSQLReqBO.getOrderByColumn() != null) {
            if (searchEsSQLReqBO.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 4) {
                sortField = "discounts";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 5) {
                sortField = "comment_number";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 7) {
                sortField = "ecommerce_sale";
            } else if (searchEsSQLReqBO.getOrderByColumn() == 6) {
                sortField = "view_order";
            }
        }
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        if (!sortField.isEmpty()) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            fieldSortBuilders.add(sortQuery);
        }
        searchBarEsSQLRspBO.setBoolQueryBuilder(extBoolQueryBuilder);
        searchBarEsSQLRspBO.setSortQuery(fieldSortBuilders);
        searchBarEsSQLRspBO.setHiddenParamsForRsp(hiddenParamsForRsp);
        searchBarEsSQLRspBO.setPageNo(searchEsSQLReqBO.getPageNo());
        searchBarEsSQLRspBO.setPageSize(searchEsSQLReqBO.getPageSize());
        searchBarEsSQLRspBO.setLevel(searchEsSQLReqBO.getLevel());
        return searchBarEsSQLRspBO;
    }

    @Override
    public CompareEsSQLRspBo compareSQL(CompareEsSQLReqBo reqBo) {
        CompareEsSQLRspBo compareEsSQLRspBo = new CompareEsSQLRspBo();
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_status", (int)3));
        if (!StringUtils.isEmpty((String)reqBo.getUpc())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"upc", (String)reqBo.getUpc()));
        }
        if (!StringUtils.isEmpty((String)reqBo.getMfgsku())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"mfgsku", (String)reqBo.getMfgsku()));
        }
        if (reqBo.getChannelId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"channel_id", (Object)reqBo.getChannelId()));
        }
        boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)"sale_price").order(SortOrder.ASC);
        ArrayList<FieldSortBuilder> fieldSortBuilders = new ArrayList<FieldSortBuilder>();
        fieldSortBuilders.add(sortQuery);
        compareEsSQLRspBo.setBoolQueryBuilder(boolQueryBuilder);
        compareEsSQLRspBo.setSortQuery(fieldSortBuilders);
        compareEsSQLRspBo.setPageNo(1);
        return compareEsSQLRspBo;
    }

    private Map<Integer, List<UccFieldsSearchExtEsBo>> groupByfieldsType(List<UccFieldsSearchExtEsBo> fields) {
        Object map = new HashedMap();
        if (CollectionUtils.isEmpty(fields)) {
            return map;
        }
        map = fields.stream().collect(Collectors.groupingBy(UccFieldsSearchExtEsBo::getFieldsType));
        return map;
    }
}

