/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.utils;

import com.tydic.commodity.utils.SeqEntity;
import java.util.HashMap;
import java.util.Map;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionDefinition;
import org.springframework.util.StringUtils;

public class SequenceMem {
    private JdbcTemplate jdbcTemplate;
    private static Map<String, SeqEntity> seqMap = new HashMap<String, SeqEntity>();
    private final Integer MEM_MAX_STEP = 1000;
    private TransactionStatus status;
    private PlatformTransactionManager platformTransactionManager;

    public void beginTransaction() {
        if (this.platformTransactionManager != null) {
            DefaultTransactionDefinition def = new DefaultTransactionDefinition();
            def.setPropagationBehavior(3);
            this.status = this.platformTransactionManager.getTransaction((TransactionDefinition)def);
        }
    }

    public void endTransaction() {
        if (this.platformTransactionManager != null) {
            try {
                this.platformTransactionManager.commit(this.status);
            }
            catch (Exception ex) {
                this.platformTransactionManager.rollback(this.status);
            }
        }
    }

    public void initData(JdbcTemplate jdbcTemplate, PlatformTransactionManager platformTransactionManager) {
        this.jdbcTemplate = jdbcTemplate;
        this.platformTransactionManager = platformTransactionManager;
    }

    public Long updateSeq(String seqNmae) {
        this.beginTransaction();
        this.jdbcTemplate.update("update ohaotian_order_sequence set current_value = current_value +1 where name = ?", new Object[]{seqNmae});
        Long currentValue = (Long)this.jdbcTemplate.queryForObject("select current_value from ohaotian_order_sequence where name = ? ", Long.class, new Object[]{seqNmae});
        SeqEntity seqEntity = new SeqEntity();
        seqEntity.setCurrentVal(currentValue);
        seqEntity.setInitVal(currentValue);
        seqMap.put(seqNmae, seqEntity);
        this.jdbcTemplate.update("update ohaotian_order_sequence set current_value = current_value + ? where name = ?", new Object[]{this.MEM_MAX_STEP, seqNmae});
        this.endTransaction();
        return currentValue;
    }

    private Long getMemSeq(String seqName) throws Exception {
        Long memSeq = 0L;
        if (StringUtils.isEmpty((Object)seqName)) {
            throw new Exception("\u5e8f\u5217\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        SeqEntity seqEntity = seqMap.get(seqName);
        if (seqEntity == null) {
            memSeq = this.updateSeq(seqName);
        } else {
            Long currentVal = seqEntity.getCurrentVal();
            Long initVal = seqEntity.getInitVal();
            if (initVal.intValue() + this.MEM_MAX_STEP == currentVal.intValue()) {
                memSeq = this.updateSeq(seqName);
            } else {
                currentVal = currentVal + 1L;
                seqEntity.setCurrentVal(currentVal);
                seqMap.put(seqName, seqEntity);
                memSeq = currentVal;
            }
        }
        return memSeq;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getSeq(String seqName) {
        Long seq = 0L;
        try {
            JdbcTemplate jdbcTemplate = this.jdbcTemplate;
            synchronized (jdbcTemplate) {
                seq = this.getMemSeq(seqName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return seq;
    }
}

