/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.bo.busi.GuideCatalogBO;
import com.tydic.commodity.bo.busi.UccChannelDateBO;
import com.tydic.commodity.bo.busi.UccChannelSelectReqBO;
import com.tydic.commodity.bo.busi.UccChannelSelectRspBO;
import com.tydic.commodity.bo.busi.UccGuideCatalogReqBO;
import com.tydic.commodity.bo.busi.UccGuideCatalogRspBO;
import com.tydic.commodity.busi.api.QryUccGuideCatalogService;
import com.tydic.commodity.busi.api.UccChannelSelectBusiService;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.CceCatalogRecommend;
import com.tydic.uccext.bo.CceGuideCatalogBO;
import com.tydic.uccext.bo.CceOnloadCatalogReqBO;
import com.tydic.uccext.bo.CceOnloadCatalogRspBO;
import com.tydic.uccext.bo.GuideCatalogRedisBO;
import com.tydic.uccext.dao.CceCategoryStatisticsMapper;
import com.tydic.uccext.dao.UccBannerConfigMapper;
import com.tydic.uccext.dao.UccPortalCmsSkuListMapper;
import com.tydic.uccext.dao.po.CceCategoryStatisticsPO;
import com.tydic.uccext.dao.po.UccBannerConfigPO;
import com.tydic.uccext.dao.po.UccPortalCmsSkuListPO;
import com.tydic.uccext.service.CceOnloadCatalogAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=CceOnloadCatalogAbilityService.class)
public class CceOnloadCatalogAbilityServiceImpl
implements CceOnloadCatalogAbilityService {
    @Reference(interfaceClass=QryUccGuideCatalogService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private QryUccGuideCatalogService qryUccGuideCatalogService;
    @Reference(interfaceClass=UccChannelSelectBusiService.class, version="1.0.0", group="UCC_GROUP_DEV")
    protected UccChannelSelectBusiService channelSelectBusiService;
    @Autowired
    private CacheClient cacheClient;
    @Autowired
    private UccBannerConfigMapper uccBannerConfigMapper;
    @Autowired
    private CceCategoryStatisticsMapper cceCategoryStatisticsMapper;
    @Autowired
    private UccPortalCmsSkuListMapper uccPortalCmsSkuListMapper;

    public CceOnloadCatalogRspBO onLoadCatalogToRedis(CceOnloadCatalogReqBO reqBO) {
        CceOnloadCatalogRspBO rspBO = new CceOnloadCatalogRspBO();
        UccChannelSelectReqBO channelSelectReqBO = new UccChannelSelectReqBO();
        channelSelectReqBO.setChannelStatus(Integer.valueOf(1));
        UccChannelSelectRspBO channelSelectRspBO = null;
        HashMap<Long, GuideCatalogRedisBO> uccGuideCatalogRspBOS = new HashMap<Long, GuideCatalogRedisBO>();
        try {
            channelSelectRspBO = this.channelSelectBusiService.selectChannel(channelSelectReqBO);
        }
        catch (Exception e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u9891\u9053\u5206\u7c7b\u9519\u8bef");
            return rspBO;
        }
        try {
            for (Object e : channelSelectRspBO.getRows()) {
                UccChannelDateBO uccChannelDateBO = (UccChannelDateBO)e;
                UccGuideCatalogReqBO catalogReqBO = new UccGuideCatalogReqBO();
                catalogReqBO.setChannelId(uccChannelDateBO.getChannelId());
                catalogReqBO.setOrderType(Integer.valueOf(4));
                catalogReqBO.setPageNo(1);
                catalogReqBO.setPageSize(100);
                catalogReqBO.setCatalogLevel(Integer.valueOf(1));
                UccGuideCatalogRspBO uccGuideCatalogRspBO = null;
                try {
                    uccGuideCatalogRspBO = this.qryUccGuideCatalogService.qryUccGuideCatalog(catalogReqBO);
                }
                catch (Exception e2) {
                    throw new BusinessException("8888", "\u5931\u8d25");
                }
                if (uccGuideCatalogRspBO == null) {
                    throw new BusinessException("8888", "\u5931\u8d25");
                }
                ArrayList<CceGuideCatalogBO> cceGuideCatalogBOS = new ArrayList<CceGuideCatalogBO>();
                GuideCatalogRedisBO guideCatalogRedisBO = new GuideCatalogRedisBO();
                guideCatalogRedisBO.setRows(cceGuideCatalogBOS);
                if (CollectionUtils.isNotEmpty((Collection)uccGuideCatalogRspBO.getRows())) {
                    for (int i = 0; i < uccGuideCatalogRspBO.getRows().size(); ++i) {
                        CceGuideCatalogBO cceGuideCatalogBO = new CceGuideCatalogBO();
                        GuideCatalogBO guideCatalogBO = (GuideCatalogBO)uccGuideCatalogRspBO.getRows().get(i);
                        BeanUtils.copyProperties((Object)guideCatalogBO, (Object)cceGuideCatalogBO);
                        this.getCceCatalog(cceGuideCatalogBO);
                        cceGuideCatalogBOS.add(cceGuideCatalogBO);
                    }
                }
                if (CollectionUtils.isNotEmpty(cceGuideCatalogBOS)) {
                    Map<Long, List<CceCatalogRecommend>> cceCatalogRecommends = this.getCatalogRecommend(cceGuideCatalogBOS);
                    for (CceGuideCatalogBO cceGuideCatalogBO : cceGuideCatalogBOS) {
                        for (Map.Entry<Long, List<CceCatalogRecommend>> each : cceCatalogRecommends.entrySet()) {
                            if (!cceGuideCatalogBO.getGuideCatalogId().equals(each.getKey())) continue;
                            cceGuideCatalogBO.setCatalogRecommendInfo(each.getValue());
                        }
                    }
                }
                uccGuideCatalogRspBOS.put(uccChannelDateBO.getChannelId(), guideCatalogRedisBO);
                this.cacheClient.delete("CHANNEL_NUM" + String.valueOf(uccChannelDateBO.getChannelId()));
            }
        }
        catch (BusinessException e) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u67e5\u8be2\u9891\u9053\u5bf9\u5e94\u7684\u5546\u54c1\u5bfc\u8d2d\u7c7b\u76ee\u5931\u8d25");
            return rspBO;
        }
        for (Map.Entry entry : uccGuideCatalogRspBOS.entrySet()) {
            this.cacheClient.set("CHANNEL_NUM" + String.valueOf(entry.getKey()), entry.getValue());
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void getCceCatalog(CceGuideCatalogBO cceGuideCatalogBO) {
        CceCategoryStatisticsPO cceCategoryStatisticsPO = new CceCategoryStatisticsPO();
        cceCategoryStatisticsPO.setGroupField("GUIDE_CATALOG_ID1");
        cceCategoryStatisticsPO.setChannelId(cceGuideCatalogBO.getChannelId());
        CceCategoryStatisticsPO cceCategoryStatisticsPO1 = this.cceCategoryStatisticsMapper.selectMostCount(cceCategoryStatisticsPO);
        cceCategoryStatisticsPO.setGroupField("GUIDE_CATALOG_ID2");
        cceCategoryStatisticsPO.setGuideCatalogId1(cceGuideCatalogBO.getGuideCatalogId());
        CceCategoryStatisticsPO cceCategoryStatisticsPO2 = this.cceCategoryStatisticsMapper.selectSecondLevelDicMostCount(cceCategoryStatisticsPO);
        if (cceCategoryStatisticsPO1 != null) {
            cceGuideCatalogBO.setMostClickCatId(cceCategoryStatisticsPO1.getGuideCatalogId1());
            cceGuideCatalogBO.setMostClickCatName(cceCategoryStatisticsPO1.getCatalogName1());
            cceGuideCatalogBO.setMostHostCatId(cceCategoryStatisticsPO1.getGuideCatalogId1());
            cceGuideCatalogBO.setMostHostCatName(cceCategoryStatisticsPO1.getCatalogName1());
        }
        if (cceCategoryStatisticsPO2 != null) {
            cceGuideCatalogBO.setSecondHostCatId(cceCategoryStatisticsPO2.getGuideCatalogId2());
            cceGuideCatalogBO.setSecondHostCatName(cceCategoryStatisticsPO2.getCatalogName2());
        }
    }

    private Map<Long, List<CceCatalogRecommend>> getCatalogRecommend(List<CceGuideCatalogBO> cceGuideCatalogBOS) {
        ArrayList<CceCatalogRecommend> cceCatalogRecommends = new ArrayList<CceCatalogRecommend>();
        ArrayList<Long> searchIds = new ArrayList<Long>();
        if (CollectionUtils.isNotEmpty(cceGuideCatalogBOS)) {
            for (int i = 0; i < cceGuideCatalogBOS.size(); ++i) {
                Long id = cceGuideCatalogBOS.get(i).getGuideCatalogId();
                if (null == id) continue;
                searchIds.add(id);
            }
        }
        UccBannerConfigPO uccBannerConfigPO = new UccBannerConfigPO();
        uccBannerConfigPO.setSearchIds(searchIds);
        List<UccBannerConfigPO> uccBannerConfigPOS = this.uccBannerConfigMapper.qryList(uccBannerConfigPO);
        if (CollectionUtils.isNotEmpty(uccBannerConfigPOS)) {
            List bannerIds = uccBannerConfigPOS.stream().map(UccBannerConfigPO::getBannerId).collect(Collectors.toList());
            List<String> columnCodes = bannerIds.stream().map(a -> String.valueOf(a)).collect(Collectors.toList());
            UccPortalCmsSkuListPO uccPortalCmsSkuListPO = new UccPortalCmsSkuListPO();
            uccPortalCmsSkuListPO.setColumnCodes(columnCodes);
            List<UccPortalCmsSkuListPO> uccPortalCmsSkuListPOS = this.uccPortalCmsSkuListMapper.qryListByBannerIds(uccPortalCmsSkuListPO);
            for (UccBannerConfigPO uccBannerConfigPO1 : uccBannerConfigPOS) {
                CceCatalogRecommend cceCatalogRecommend = new CceCatalogRecommend();
                cceCatalogRecommend.setGuideCatalogId(uccBannerConfigPO1.getSearchId());
                cceCatalogRecommend.setPic(uccBannerConfigPO1.getBannerPicUrl());
                cceCatalogRecommend.setUrl(uccBannerConfigPO1.getForwardUrl());
                cceCatalogRecommend.setSupplierShopId(uccBannerConfigPO1.getSupplierShopId());
                if (CollectionUtils.isNotEmpty(uccPortalCmsSkuListPOS)) {
                    for (UccPortalCmsSkuListPO uccPortalCmsSkuListPO1 : uccPortalCmsSkuListPOS) {
                        if (!uccBannerConfigPO1.getBannerId().equals(uccPortalCmsSkuListPO1.getColumnCode())) continue;
                        cceCatalogRecommend.setSkuId(uccPortalCmsSkuListPO1.getSkuId());
                    }
                }
                cceCatalogRecommends.add(cceCatalogRecommend);
            }
        }
        Map<Long, List<CceCatalogRecommend>> map = cceCatalogRecommends.stream().collect(Collectors.groupingBy(CceCatalogRecommend::getGuideCatalogId));
        return map;
    }
}

