/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.ability.api.SearchBarEsAbilityService;
import com.tydic.commodity.atom.UccAreaAvailableQryAtomService;
import com.tydic.commodity.atom.UccAvailableCommdQryAtomService;
import com.tydic.commodity.atom.bo.UccAreaAvailableQryReqBO;
import com.tydic.commodity.atom.bo.UccAreaAvailableQryRspBO;
import com.tydic.commodity.atom.bo.UccAvailableCommdQryReqBO;
import com.tydic.commodity.atom.bo.UccAvailableCommdQryRspBO;
import com.tydic.commodity.bo.ability.SearchBarEsReqBO;
import com.tydic.commodity.bo.ability.SearchBarEsRspBO;
import com.tydic.commodity.bo.ability.SearchBarEsRspInfo;
import com.tydic.commodity.bo.busi.AreaAvailableCommdBO_busi;
import com.tydic.commodity.bo.busi.AvailableCommdBO_busi;
import com.tydic.commodity.bo.busi.CommdStockBO_busi;
import com.tydic.commodity.bo.busi.SkuNumBO_busi;
import com.tydic.commodity.bo.busi.UccCurrentStockQryReqBO;
import com.tydic.commodity.bo.busi.UccCurrentStockQryRspBO;
import com.tydic.commodity.busi.api.UccCommdStockQryBusiService;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCatalogDealMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCatalogDealPO;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.uccext.bo.ExchangeGoodsQryBO;
import com.tydic.uccext.bo.ExchangeGoodsQryReqBO;
import com.tydic.uccext.bo.ExchangeGoodsQryRspBO;
import com.tydic.uccext.dao.UccCommodityExtMapper;
import com.tydic.uccext.service.ExchangeGoodsQryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.map.HashedMap;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=ExchangeGoodsQryAbilityService.class)
public class ExchangeGoodsQryAbilityServiceImpl
implements ExchangeGoodsQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(ExchangeGoodsQryAbilityServiceImpl.class);
    @Autowired
    private UccCatalogDealMapper uccCatalogDealMapper;
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccCommodityExtMapper uccCommodityExtMapper;
    @Autowired
    private UccCommdStockQryBusiService uccCommdStockQryBusiService;
    @Autowired
    private UccAreaAvailableQryAtomService uccAreaAvailableQryAtomService;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccAvailableCommdQryAtomService uccAvailableCommdQryAtomService;
    @Reference(interfaceClass=SearchBarEsAbilityService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private SearchBarEsAbilityService searchBarEsAbilityService;
    @Autowired
    private UccSkuMapper uccSkuMapper;

    public ExchangeGoodsQryRspBO queryGoods(ExchangeGoodsQryReqBO reqBO) {
        ExchangeGoodsQryRspBO rspBO = new ExchangeGoodsQryRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        SearchBarEsReqBO searchBarEsReqBO = new SearchBarEsReqBO();
        if (reqBO.getGuideCatalogId() != null) {
            UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
            uccCatalogDealPO.setGuideCatalogId(reqBO.getGuideCatalogId());
            List<UccCatalogDealPO> reqGuis = this.uccCatalogDealMapper.queryCatalog(uccCatalogDealPO);
            if (!CollectionUtils.isEmpty(reqGuis)) {
                searchBarEsReqBO.setCategoryId(reqBO.getGuideCatalogId());
                searchBarEsReqBO.setLevel(reqGuis.get(0).getCatalogLevel());
            }
        }
        if (reqBO.getMaxPrice() != null && BigDecimal.ZERO.compareTo(reqBO.getMaxPrice()) <= 0) {
            searchBarEsReqBO.setMaxSalesPrice(reqBO.getMaxPrice());
        }
        if (reqBO.getMinPirce() != null && BigDecimal.ZERO.compareTo(reqBO.getMinPirce()) <= 0) {
            searchBarEsReqBO.setMinSalesPrice(reqBO.getMinPirce());
        }
        if (reqBO.getSupplierId() != null) {
            searchBarEsReqBO.setSupplierId(reqBO.getSupplierId());
        }
        if (reqBO.getSkuId() != null || !StringUtils.isEmpty((Object)reqBO.getCommodityName())) {
            if (reqBO.getCommodityName() != null) {
                searchBarEsReqBO.setQueryStr(reqBO.getCommodityName());
            }
            if (reqBO.getSkuId() != null) {
                searchBarEsReqBO.setQueryStr(reqBO.getSkuId().toString());
            }
        }
        searchBarEsReqBO.setReqNo(reqBO.getReqNo());
        searchBarEsReqBO.setPageSize(reqBO.getPageSize());
        searchBarEsReqBO.setNeedKeyWorld(false);
        SearchBarEsRspBO searchBarEsRspBO = this.searchBarEsAbilityService.qryBySearchBar(searchBarEsReqBO);
        rspBO.setTotal(searchBarEsRspBO.getTotal());
        rspBO.setRecordsTotal(searchBarEsRspBO.getRecordsTotal());
        rspBO.setPageNo(reqBO.getPageNo());
        if (!"0000".equals(searchBarEsRspBO.getRespCode())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5173\u8054\u6570\u636e");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)searchBarEsRspBO.getResult())) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5173\u8054\u6570\u636e");
            return rspBO;
        }
        ArrayList<ExchangeGoodsQryBO> exchangeGoodsQryBOS = new ArrayList<ExchangeGoodsQryBO>();
        for (SearchBarEsRspInfo each : searchBarEsRspBO.getResult()) {
            ExchangeGoodsQryBO bo = new ExchangeGoodsQryBO();
            bo.setSalePrice(each.getSalePrice());
            bo.setExtSkuId(each.getExtSkuId());
            bo.setCommodityName(each.getCommodityName());
            bo.setCommodityId(each.getCommodityId());
            bo.setImgUrl(each.getPriPicUrl());
            bo.setSupplierId(Long.valueOf(each.getSupplierId()));
            bo.setSupplierShopId(each.getSupplierShopId());
            bo.setSkuId(each.getSkuId());
            bo.setSupplierName(each.getSupplierName());
            exchangeGoodsQryBOS.add(bo);
        }
        List<Long> skus = exchangeGoodsQryBOS.stream().map(ExchangeGoodsQryBO::getSkuId).collect(Collectors.toList());
        List<UccSkuPo> skuPoList = this.uccSkuMapper.qeryBatchSkus(skus);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(skuPoList)) {
            log.error("\u67e5\u8be2uccSkuMapper \u65e0\u8fd4\u56de\u7ed3\u679c\uff1a" + skus);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5173\u8054\u6570\u636e");
            return rspBO;
        }
        Map<Long, UccSkuPo> skuPoMap = skuPoList.stream().collect(Collectors.toMap(UccSkuPo::getSkuId, UccSkuPo2 -> UccSkuPo2));
        for (ExchangeGoodsQryBO each : exchangeGoodsQryBOS) {
            if (!skuPoMap.containsKey(each.getSkuId())) continue;
            each.setBranName(skuPoMap.get(each.getSkuId()).getBrandName());
            each.setMeasureName(skuPoMap.get(each.getSkuId()).getMeasureName());
        }
        Object extSkusMap = new HashedMap();
        extSkusMap = exchangeGoodsQryBOS.stream().collect(Collectors.toMap(ExchangeGoodsQryBO::getSkuId, ExchangeGoodsQryBO::getExtSkuId));
        Map<Long, List<Long>> supplierMap = this.groupByShopId(exchangeGoodsQryBOS);
        if (reqBO.getProvince() != null && reqBO.getCity() != null && reqBO.getCounty() != null && reqBO.getTown() != null && !supplierMap.isEmpty()) {
            for (Map.Entry<Long, List<Long>> entry : supplierMap.entrySet()) {
                Long shopId = entry.getKey();
                ArrayList<String> extSkus = new ArrayList<String>();
                ArrayList<SkuNumBO_busi> skuNumBO_busis = new ArrayList<SkuNumBO_busi>();
                for (Long sku : entry.getValue()) {
                    if (extSkusMap.containsKey(sku)) {
                        extSkus.add((String)extSkusMap.get(sku));
                    }
                    SkuNumBO_busi skuNumBO_busi = new SkuNumBO_busi();
                    skuNumBO_busi.setSkuId(sku);
                    skuNumBO_busi.setNum(Long.valueOf(1L));
                    skuNumBO_busis.add(skuNumBO_busi);
                }
                UccCurrentStockQryReqBO uccCurrentStockQryReqBO = new UccCurrentStockQryReqBO();
                uccCurrentStockQryReqBO.setSkuNum(skuNumBO_busis);
                uccCurrentStockQryReqBO.setSupplierShopId(shopId);
                uccCurrentStockQryReqBO.setCity(reqBO.getCity());
                uccCurrentStockQryReqBO.setCounty(reqBO.getCounty());
                uccCurrentStockQryReqBO.setProvince(reqBO.getProvince());
                uccCurrentStockQryReqBO.setTown(reqBO.getTown());
                log.info("\u8c03\u7528\u4e1a\u52a1\u5c42\u5e93\u5b58\u67e5\u8be2\u63a5\u53e3\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)uccCurrentStockQryReqBO));
                UccCurrentStockQryRspBO uccCurrentStockQryRspBO = this.uccCommdStockQryBusiService.qryStock(uccCurrentStockQryReqBO);
                if ("0000".equals(uccCurrentStockQryRspBO.getRespCode())) {
                    List commdStockBO_busis = uccCurrentStockQryRspBO.getCommdStockInfo();
                    if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)commdStockBO_busis)) {
                        Map<String, CommdStockBO_busi> stockBO_busiMap = commdStockBO_busis.stream().collect(Collectors.toMap(CommdStockBO_busi::getSkuId, CommdStockBO_busi2 -> CommdStockBO_busi2));
                        for (ExchangeGoodsQryBO exchangeGoodsQrybO : exchangeGoodsQryBOS) {
                            if (!stockBO_busiMap.containsKey(exchangeGoodsQrybO.getSkuId().toString())) continue;
                            exchangeGoodsQrybO.setStockDesc(stockBO_busiMap.get(exchangeGoodsQrybO.getSkuId().toString()).getStockStateDesc());
                            exchangeGoodsQrybO.setStockStateId(stockBO_busiMap.get(exchangeGoodsQrybO.getSkuId().toString()).getStockStateId());
                        }
                    }
                } else {
                    BeanUtils.copyProperties((Object)uccCurrentStockQryRspBO, (Object)rspBO);
                    return rspBO;
                }
                SupplierShopPo supplierShopPo = this.supplierShopMapper.queryPoBySupplierShopId(shopId);
                SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(supplierShopPo.getSupplierId());
                UccAreaAvailableQryReqBO uccAreaAvailableQryReqBO = new UccAreaAvailableQryReqBO();
                uccAreaAvailableQryReqBO.setCity(reqBO.getCity());
                uccAreaAvailableQryReqBO.setCounty(reqBO.getCounty());
                uccAreaAvailableQryReqBO.setProvince(reqBO.getProvince());
                uccAreaAvailableQryReqBO.setTown(reqBO.getTown());
                uccAreaAvailableQryReqBO.setSupplierCode(supplierBusiPo.getSupplierCode());
                uccAreaAvailableQryReqBO.setSupplierId(supplierBusiPo.getSupplierId());
                uccAreaAvailableQryReqBO.setSkuIds(extSkus);
                UccAreaAvailableQryRspBO uccAreaAvailableQryRspBO = this.uccAreaAvailableQryAtomService.qryAreaAvailableCommd(uccAreaAvailableQryReqBO);
                if ("0000".equals(uccAreaAvailableQryRspBO.getRespCode())) {
                    Map<String, Boolean> areaLimit = uccAreaAvailableQryRspBO.getAreaAvailableCommdInfos().stream().collect(Collectors.toMap(AreaAvailableCommdBO_busi::getSkuId, AreaAvailableCommdBO_busi::isAreaRestrict));
                    for (ExchangeGoodsQryBO resultEach : exchangeGoodsQryBOS) {
                        if (!areaLimit.containsKey(resultEach.getExtSkuId().toString())) continue;
                        resultEach.setAreaRestrict(((Boolean)areaLimit.get(resultEach.getExtSkuId().toString())).booleanValue());
                    }
                } else {
                    log.error("\u67e5\u8be2\u533a\u57df\u9650\u5236\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)((Object)uccAreaAvailableQryRspBO)));
                    for (ExchangeGoodsQryBO resultEach : exchangeGoodsQryBOS) {
                        if (resultEach.getSupplierShopId() != shopId) continue;
                        resultEach.setAreaRestrict(true);
                    }
                }
                UccAvailableCommdQryReqBO uccAvailableCommdQryReqBO = new UccAvailableCommdQryReqBO();
                uccAvailableCommdQryReqBO.setSkuIds(extSkus);
                uccAvailableCommdQryReqBO.setSupplierCode(supplierBusiPo.getSupplierCode());
                UccAvailableCommdQryRspBO uccAvailableCommdQryRspBO = this.uccAvailableCommdQryAtomService.qryAvailableCommd(uccAvailableCommdQryReqBO);
                if ("0000".equals(uccAvailableCommdQryRspBO.getResultCode())) {
                    Map<String, Integer> extSkuArea = uccAvailableCommdQryRspBO.getAvailableCommdInfos().stream().collect(Collectors.toMap(AvailableCommdBO_busi::getSkuId, AvailableCommdBO_busi::getSaleState));
                    for (ExchangeGoodsQryBO resultEach : exchangeGoodsQryBOS) {
                        if (!extSkuArea.containsKey(resultEach.getExtSkuId())) continue;
                        if (extSkuArea.get(resultEach.getExtSkuId()) == null) {
                            resultEach.setSaleState(Integer.valueOf(0));
                            continue;
                        }
                        resultEach.setSaleState(extSkuArea.get(resultEach.getExtSkuId()));
                    }
                    continue;
                }
                log.error("\u67e5\u8be2\u53ef\u552e\u9a8c\u8bc1\u5931\u8d25\uff1a" + JSONObject.toJSONString((Object)((Object)uccAvailableCommdQryRspBO)));
                for (ExchangeGoodsQryBO resultEach : exchangeGoodsQryBOS) {
                    if (resultEach.getSupplierShopId() != shopId) continue;
                    resultEach.setSaleState(Integer.valueOf(0));
                }
            }
        }
        rspBO.setData(exchangeGoodsQryBOS);
        return rspBO;
    }

    public List<Long> qry3LevlGuis(Long guideCatalogId) {
        ArrayList<Long> guiAray = new ArrayList<Long>();
        UccCatalogDealPO uccCatalogDealPO = new UccCatalogDealPO();
        uccCatalogDealPO.setGuideCatalogId(guideCatalogId);
        List<UccCatalogDealPO> reqGuis = this.uccCatalogDealMapper.queryCatalog(uccCatalogDealPO);
        if (org.apache.commons.collections.CollectionUtils.isEmpty(reqGuis)) {
            return guiAray;
        }
        if (reqGuis.get(0).getCatalogLevel() == 3) {
            guiAray.add(reqGuis.get(0).getGuideCatalogId());
            return guiAray;
        }
        if (reqGuis.get(0).getCatalogLevel() == 2) {
            uccCatalogDealPO = new UccCatalogDealPO();
            uccCatalogDealPO.setUpperCatalogId(guideCatalogId);
            List<UccCatalogDealPO> reqGuis3 = this.uccCatalogDealMapper.queryCatalog(uccCatalogDealPO);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(reqGuis3)) {
                for (UccCatalogDealPO each : reqGuis3) {
                    guiAray.add(each.getGuideCatalogId());
                }
            }
        }
        if (reqGuis.get(0).getCatalogLevel() == 1) {
            uccCatalogDealPO = new UccCatalogDealPO();
            uccCatalogDealPO.setUpperCatalogId(guideCatalogId);
            List<UccCatalogDealPO> reqGuis2 = this.uccCatalogDealMapper.queryCatalog(uccCatalogDealPO);
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(reqGuis2)) {
                for (UccCatalogDealPO each : reqGuis2) {
                    List<Long> Levl3List = this.qry3LevlGuis(each.getGuideCatalogId());
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(Levl3List)) continue;
                    guiAray.addAll(Levl3List);
                }
            }
        }
        return guiAray;
    }

    public Map<Long, List<Long>> groupByShopId(List<ExchangeGoodsQryBO> exchangeGoodsQryBO) {
        HashedMap map = new HashedMap();
        if (org.apache.commons.collections.CollectionUtils.isEmpty(exchangeGoodsQryBO)) {
            return map;
        }
        for (ExchangeGoodsQryBO each : exchangeGoodsQryBO) {
            if (map.containsKey(each.getSupplierShopId())) {
                if (((List)map.get(each.getSupplierShopId())).contains(each.getSkuId())) continue;
                ((List)map.get(each.getSupplierShopId())).add(each.getSkuId());
                continue;
            }
            map.put(each.getSupplierShopId(), new ArrayList<Long>(Arrays.asList(each.getSkuId())));
        }
        return map;
    }
}

