/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.atom.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.atom.bo.UccSkuStatusUpdatesAtomReqBO;
import com.tydic.commodity.atom.bo.UccSkuStatusUpdatesAtomRspBO;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.ListUtils;
import com.tydic.uac.config.ProperticeVo;
import com.tydic.uccext.bo.UccGoodsIssueDeleteAbilityReqBO;
import com.tydic.uccext.bo.UccGoodsIssueDeleteAbilityRspBO;
import com.tydic.uccext.service.UccGoodsIssueDeleteAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccGoodsIssueDeleteAbilityService.class)
public class UccGoodsIssueDeleteAbilityServiceImpl
implements UccGoodsIssueDeleteAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private ProperticeVo properticeVo;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccGoodsIssueDeleteAbilityServiceImpl.class);

    public UccGoodsIssueDeleteAbilityRspBO dealUccGoodsIssueDelete(UccGoodsIssueDeleteAbilityReqBO reqBO) {
        UccGoodsIssueDeleteAbilityRspBO rspBO = new UccGoodsIssueDeleteAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u6237ID");
            return rspBO;
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5355\u54c1ID");
            return rspBO;
        }
        List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isNotEmpty(supplierShopPos)) {
            reqBO.setSupplierShopId(supplierShopPos.get(0).getSupplierShopId());
        }
        List<Object> uccSkuPos = new ArrayList();
        try {
            uccSkuPos = this.uccSkuMapper.batchQrySku(reqBO.getSkuIds(), reqBO.getSupplierShopId());
            if (CollectionUtils.isEmpty(uccSkuPos)) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u8bf7\u4f20\u5165\u6709\u6548\u5355\u54c1ID");
                return rspBO;
            }
            ArrayList<Long> failIds = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(uccSkuPos)) {
                for (UccSkuPo uccSkuPo : uccSkuPos) {
                    if (uccSkuPo.getSkuStatus().equals(SkuStatusEnum.DRAFT_STATUS.getStatus())) continue;
                    failIds.add(uccSkuPo.getSkuId());
                }
            }
            if (failIds.size() > 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5546\u54c1" + ((Object)failIds).toString() + "\u4e0d\u4e3a\u8349\u7a3f\u72b6\u6001");
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        try {
            UccSkuStatusUpdatesAtomReqBO uccSkuStatusUpdatesAtomReqBO = new UccSkuStatusUpdatesAtomReqBO();
            uccSkuStatusUpdatesAtomReqBO.setSkuIds(reqBO.getSkuIds());
            uccSkuStatusUpdatesAtomReqBO.setState(SkuStatusEnum.INVALID_STATUS.getStatus());
            uccSkuStatusUpdatesAtomReqBO.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuStatusUpdatesAtomReqBO.setOldStatus(SkuStatusEnum.DRAFT_STATUS.getStatus());
            UccSkuStatusUpdatesAtomRspBO uccSkuStatusUpdatesAtomRspBO = this.uccSkuStatusUpdatesAtomService.dealUccSkuStatusUpdates(uccSkuStatusUpdatesAtomReqBO);
            if (!"0000".equals(uccSkuStatusUpdatesAtomRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)((Object)uccSkuStatusUpdatesAtomRspBO), (Object)rspBO);
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        if (CollectionUtils.isNotEmpty(uccSkuPos)) {
            List commodityIds = uccSkuPos.stream().map(UccSkuPo::getCommodityId).collect(Collectors.toList());
            commodityIds = ListUtils.removeReapet(commodityIds);
            try {
                UccCommodityPo uccCommodityPo = new UccCommodityPo();
                uccCommodityPo.setCommodityStatus(4);
                uccCommodityPo.setSupplierShopId(reqBO.getSupplierShopId());
                this.uccCommodityMapper.batchUpdateById(commodityIds, uccCommodityPo);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new BusinessException("8888", "\u66f4\u65b0\u5546\u54c1\u5931\u8d25");
            }
        }
        if (!CollectionUtils.isEmpty(uccSkuPos)) {
            List agreementDetailsId = uccSkuPos.stream().filter(poList -> poList.getAgreementDetailsId() != null).map(UccSkuPo::getAgreementDetailsId).collect(Collectors.toList());
            List agreementDetailsIds = agreementDetailsId.stream().map(a -> String.valueOf(a)).collect(Collectors.toList());
            UccZoneGoodsAuditNotifyMessageBO uccZoneGoodsAuditNotifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
            try {
                uccZoneGoodsAuditNotifyMessageBO.setAgreementId(String.valueOf(((UccSkuPo)uccSkuPos.get(0)).getAgreementId()));
                uccZoneGoodsAuditNotifyMessageBO.setAgreementSkuIds(agreementDetailsIds);
                uccZoneGoodsAuditNotifyMessageBO.setAgreementSkuStatus("6");
                uccZoneGoodsAuditNotifyMessageBO.setMemIdIn(reqBO.getUserId());
                uccZoneGoodsAuditNotifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_UP_SHELF.code());
                LOGGER.info("\u53d1\u5e03\u5220\u9664\u5546\u54c1\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)uccZoneGoodsAuditNotifyMessageBO));
                this.zoneGoodsAuditMQ.send(new ProxyMessage(this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TOPIC"), this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)uccZoneGoodsAuditNotifyMessageBO)));
            }
            catch (Exception var16) {
                LOGGER.error("\u53d1\u5e03\u5220\u9664\uff0c\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
                throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
            }
        }
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList((Iterable)reqBO.getSkuIds()));
        syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierShopId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
        LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u5e03\u5220\u9664\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
            throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
        }
        return rspBO;
    }
}

