/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.atom.UccGoodsInfoCheckAtomService;
import com.tydic.commodity.bo.busi.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.UccGoodsAgreementAndCommodityBO;
import com.tydic.uccext.bo.UccGoodsIssueUpdateAbilityReqBO;
import com.tydic.uccext.bo.UccGoodsIssueUpdateAbilityRspBO;
import com.tydic.uccext.bo.UccGoodsIssueUpdateBusiReqBO;
import com.tydic.uccext.bo.UccGoodsIssueUpdateBusiRspBO;
import com.tydic.uccext.service.UccGoodsIssueUpdateAbilityService;
import com.tydic.uccext.service.UccGoodsIssueUpdateBusiService;
import com.tydic.uccext.service.UccRecordEditDetailsService;
import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccGoodsIssueUpdateAbilityService.class)
public class UccGoodsIssueUpdateAbilityServiceImpl
implements UccGoodsIssueUpdateAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccGoodsIssueUpdateAbilityServiceImpl.class);
    @Reference(interfaceClass=UccRecordEditDetailsService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccRecordEditDetailsService recordEditDetailsService;
    @Autowired
    private UccGoodsInfoCheckAtomService goodsInfoCheckAtomService;
    @Reference(interfaceClass=UccGoodsIssueUpdateBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccGoodsIssueUpdateBusiService issueUpdateBusiService;
    @Reference(interfaceClass=BatchUpdateCommoStatusForMarketService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private BatchUpdateCommoStatusForMarketService batchUpdateCommoStatusForMarketService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Reference(interfaceClass=BatchUpdateCommoStatusForMarketService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private BatchUpdateCommoStatusForMarketService statusForMarketService;

    public UccGoodsIssueUpdateAbilityRspBO dealUccGoodsIssueUpdate(UccGoodsIssueUpdateAbilityReqBO reqBO) {
        UccGoodsIssueUpdateAbilityRspBO uccGoodsIssueUpdateAbilityRspBO = new UccGoodsIssueUpdateAbilityRspBO();
        this.checkParameter(reqBO);
        UccGoodsIssueUpdateBusiReqBO issueUpdateBusiReqBO = new UccGoodsIssueUpdateBusiReqBO();
        BeanUtils.copyProperties((Object)reqBO, (Object)issueUpdateBusiReqBO);
        UccGoodsIssueUpdateBusiRspBO rspBO = this.issueUpdateBusiService.dealUccGoodsIssueUpdate(issueUpdateBusiReqBO);
        if ("8888".equals(rspBO.getRespCode())) {
            throw new BusinessException("8888", rspBO.getRespDesc());
        }
        try {
            if (reqBO.getOperType() == 1) {
                CommodityBo commodityBo = new CommodityBo();
                UccCommodityPo commodityPo = this.uccCommodityMapper.getCommodityById(rspBO.getCommodityId());
                BeanUtils.copyProperties((Object)commodityPo, (Object)commodityBo);
                commodityBo.setCommodityStatus(null);
                commodityBo.setApprovalStatus(rspBO.getStepId());
                this.batchUpdateCommoStatusForMarketService.updateCommoApprovalStatus(commodityBo, AuditResultStatusEnum.Audit_Pass);
                BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
                Long[] businessId = new Long[]{rspBO.getCommodityId()};
                batchUpdateCommoStatusForMarketBO.setReason("\u53d1\u5e03\u5ba1\u6279");
                batchUpdateCommoStatusForMarketBO.setBusinessId(businessId);
                this.statusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.PENDING_APPROVAL_STATUS, SkuStatusEnum.PENDING_APPROVAL_STATUS);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4fee\u6539\uff0c\u539f\u56e0\uff1a" + e);
            throw new BusinessException("8888", "\u6d41\u7a0b\u5904\u7406\u5931\u8d25");
        }
        uccGoodsIssueUpdateAbilityRspBO.setSkuId(rspBO.getSkuId());
        uccGoodsIssueUpdateAbilityRspBO.setRespCode("0000");
        uccGoodsIssueUpdateAbilityRspBO.setRespDesc("\u6210\u529f");
        return uccGoodsIssueUpdateAbilityRspBO;
    }

    private void checkParameter(UccGoodsIssueUpdateAbilityReqBO reqBO) {
        boolean isError;
        if (CollectionUtils.isEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            throw new BusinessException("8888", "\u534f\u8bae\u660e\u7ec6ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getAgreementId()) {
            throw new BusinessException("8888", "\u534f\u8baeID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        boolean bl = isError = reqBO.getOperMnueFunction() != 1 && reqBO.getOperMnueFunction() != 2 && reqBO.getIsBatchEdit() == false;
        if (null == reqBO.getCatalogId() && isError) {
            throw new BusinessException("8888", "\u5916\u90e8\u7c7b\u76ee\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (null == reqBO.getSupplierId()) {
            throw new BusinessException("8888", "\u5546\u94faID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getMaterialCode()) && isError) {
            throw new BusinessException("8888", "\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getMaterialName()) && isError) {
            throw new BusinessException("8888", "\u7269\u6599\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getBrandCode()) && isError) {
            throw new BusinessException("8888", "\u54c1\u724c\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

