/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.bo.ability.CommodityPackBO;
import com.tydic.commodity.bo.ability.CommodityPackSpecBO;
import com.tydic.commodity.bo.ability.LadderPriceBo;
import com.tydic.commodity.bo.ability.UccGoodsManageDetailQueryAbilityReqBO;
import com.tydic.commodity.bo.ability.UccGoodsManageDetailQueryAbilityRspBO;
import com.tydic.commodity.bo.busi.CommodityPicBo;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPackageMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.dao.po.CommodityPackSpecPO;
import com.tydic.commodity.dao.po.CommodityRecordPO;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPackagePo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.dao.po.UccSkuPutCirPo;
import com.tydic.commodity.enumType.SkuOnShelveWayEnum;
import com.tydic.commodity.enumType.SkuSourceEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.service.UccGoodsManageDetailQueryAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccGoodsManageDetailQueryAbilityService.class)
public class UccGoodsManageDetailQueryAbilityServiceImpl
implements UccGoodsManageDetailQueryAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCommodityPackageMapper uccCommodityPackageMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccGoodsManageDetailQueryAbilityServiceImpl.class);

    public UccGoodsManageDetailQueryAbilityRspBO getUccGoodsManageDetailQuery(UccGoodsManageDetailQueryAbilityReqBO reqBO) {
        UccGoodsManageDetailQueryAbilityRspBO rspBO = new UccGoodsManageDetailQueryAbilityRspBO();
        if (reqBO.getSkuId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u54c1ID");
            return rspBO;
        }
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u6237ID");
            return rspBO;
        }
        List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isNotEmpty(supplierShopPos)) {
            reqBO.setSupplierShopId(supplierShopPos.get(0).getSupplierShopId());
        }
        CommodityRecordPO commodityRecordPO = null;
        try {
            ArrayList supplierShopIds;
            ArrayList CommodityIds;
            Object uccCommodityPicPos;
            commodityRecordPO = this.uccSkuMapper.qryZqSkuDetail(reqBO.getSupplierShopId(), reqBO.getSkuId());
            if (commodityRecordPO.getOnShelveWay() != null) {
                rspBO.setOnShelveWayDesc(SkuOnShelveWayEnum.getPcode((int)commodityRecordPO.getOnShelveWay()));
            }
            BeanUtils.copyProperties((Object)commodityRecordPO, (Object)rspBO);
            if (rspBO.getSkuSource() != null) {
                rspBO.setSkuSourceDesc(SkuSourceEnum.getSourceDesc((Integer)rspBO.getSkuSource()).getSourceDesc());
            }
            if (rspBO.getSkuStatus() != null) {
                rspBO.setSkuStatusDesc(SkuStatusEnum.getStatusDesc((Integer)rspBO.getSkuStatus()).getStatusDesc());
            }
            if (CollectionUtils.isNotEmpty(uccCommodityPicPos = this.uccCommodityPicMapper.queryBatchByCommdId(CommodityIds = Lists.newArrayList((Object[])new Long[]{commodityRecordPO.getCommodityId()}), supplierShopIds = Lists.newArrayList((Object[])new Long[]{commodityRecordPO.getSupplierShopId()})))) {
                ArrayList<CommodityPicBo> commodityPicBos = new ArrayList<CommodityPicBo>();
                Iterator<UccCommodityPicPo> iterator = uccCommodityPicPos.iterator();
                while (iterator.hasNext()) {
                    UccCommodityPicPo uccCommodityPicPo = iterator.next();
                    CommodityPicBo commodityPicBo = new CommodityPicBo();
                    BeanUtils.copyProperties((Object)uccCommodityPicPo, (Object)commodityPicBo);
                    commodityPicBos.add(commodityPicBo);
                }
                rspBO.setCommodityPicInfo(commodityPicBos);
            }
            UccCommodityPackagePo uccCommodityPackagePo = new UccCommodityPackagePo();
            uccCommodityPackagePo.setCommodityId(commodityRecordPO.getCommodityId());
            List<UccCommodityPackagePo> uccCommodityPackagePos = this.uccCommodityPackageMapper.queryCommdPackage(uccCommodityPackagePo);
            if (CollectionUtils.isNotEmpty(uccCommodityPackagePos)) {
                ArrayList<CommodityPackBO> commodityPackBOS = new ArrayList<CommodityPackBO>();
                for (UccCommodityPackagePo uccCommodityPackagePo1 : uccCommodityPackagePos) {
                    CommodityPackBO commodityPackBO = new CommodityPackBO();
                    BeanUtils.copyProperties((Object)uccCommodityPackagePo1, (Object)commodityPackBO);
                    commodityPackBO.setList(uccCommodityPackagePo1.getPackParam());
                    commodityPackBOS.add(commodityPackBO);
                }
                rspBO.setCommodityPackInfo(commodityPackBOS);
            }
            rspBO.setMaterialCode(commodityRecordPO.getMaterialCode());
            rspBO.setMeterialName(commodityRecordPO.getMeterialName());
            rspBO.setShopName(commodityRecordPO.getShopName());
            rspBO.setModel(commodityRecordPO.getModel());
            rspBO.setSpec(commodityRecordPO.getSpec());
            rspBO.setFigure(commodityRecordPO.getFigure());
            rspBO.setTexture(commodityRecordPO.getTexture());
            rspBO.setEmdCatalogId(commodityRecordPO.getCatalogId());
            rspBO.setEmdCatalogName(commodityRecordPO.getBelongCategory());
            rspBO.setCommodityTypeName(commodityRecordPO.getCatalogName());
            rspBO.setSkuDesc(commodityRecordPO.getSkuDesc());
            rspBO.setLocation(rspBO.getSkuSourceDesc());
            if (commodityRecordPO.getShowPack() != null) {
                rspBO.setShowPack(commodityRecordPO.getShowPack());
                if (commodityRecordPO.getShowPack() == 0) {
                    rspBO.setShowPackDesc("\u4e0d\u5c55\u793a");
                } else {
                    rspBO.setShowPackDesc("\u5c55\u793a");
                }
            }
            if (commodityRecordPO.getAgreementId() != null) {
                rspBO.setAgreementId(Long.valueOf(Long.parseLong(commodityRecordPO.getAgreementId())));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25");
        }
        try {
            ArrayList<LadderPriceBo> ladderPriceBos = new ArrayList<LadderPriceBo>();
            List<UccLadderPricePO> uccLadderPricePOS = this.uccLadderPriceMapper.selectBySkuId(reqBO.getSkuId(), reqBO.getSupplierShopId());
            if (CollectionUtils.isNotEmpty(uccLadderPricePOS)) {
                for (UccLadderPricePO uccLadderPricePO : uccLadderPricePOS) {
                    LadderPriceBo ladderPriceBo = new LadderPriceBo();
                    if (uccLadderPricePO.getStart() != null) {
                        ladderPriceBo.setStartPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getStart()));
                    }
                    if (uccLadderPricePO.getStop() != null) {
                        ladderPriceBo.setStopPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getStop()));
                    }
                    if (uccLadderPricePO.getPrice() != null) {
                        ladderPriceBo.setPrice(MoneyUtils.haoToYuan((Long)uccLadderPricePO.getPrice()));
                    }
                    ladderPriceBos.add(ladderPriceBo);
                }
            }
            rspBO.setLadderPrice(ladderPriceBos);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u67e5\u8be2\u9636\u68af\u4ef7\u683c\u5931\u8d25");
        }
        try {
            CommodityPackSpecPO commodityPackSpecPO = this.uccSkuMapper.qryCommodityPackSpecBO(reqBO.getSkuId(), reqBO.getSupplierShopId());
            CommodityPackSpecBO commodityPackSpecBO = new CommodityPackSpecBO();
            BeanUtils.copyProperties((Object)commodityPackSpecPO, (Object)commodityPackSpecBO);
            if (commodityPackSpecBO.getSaleUnitPrice() != null) {
                commodityPackSpecBO.setSaleUnitPrice(MoneyUtils.haoToYuan((BigDecimal)commodityPackSpecBO.getSaleUnitPrice()));
            }
            if (commodityPackSpecBO.getPurchaseUnitPrice() != null) {
                commodityPackSpecBO.setPurchaseUnitPrice(MoneyUtils.haoToYuan((BigDecimal)commodityPackSpecBO.getPurchaseUnitPrice()));
            }
            if (commodityPackSpecBO.getPackageSaleUnitPrice() != null) {
                commodityPackSpecBO.setPackageSaleUnitPrice(MoneyUtils.haoToYuan((BigDecimal)commodityPackSpecBO.getPackageSaleUnitPrice()));
            }
            if (commodityPackSpecBO.getPackagePurchaseUitPrice() != null) {
                commodityPackSpecBO.setPackagePurchaseUitPrice(MoneyUtils.haoToYuan((BigDecimal)commodityPackSpecBO.getPackagePurchaseUitPrice()));
            }
            rspBO.setCommodityPackSpec(commodityPackSpecBO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u67e5\u8be2\u5305\u88c5\u89c4\u683c\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setManufacturer(commodityRecordPO.getManufacturer());
        rspBO.setVendorId(commodityRecordPO.getVendorId());
        rspBO.setVendorName(commodityRecordPO.getVendorName());
        try {
            UccSkuPutCirPo uccSkuPutCirPo1;
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setState(1);
            uccSkuPutCirPo.setSkuId(reqBO.getSkuId());
            List<UccSkuPutCirPo> uccSkuPutCirPos = this.uccSkuPutCirMapper.querySkuPutCir(uccSkuPutCirPo);
            if (CollectionUtils.isNotEmpty(uccSkuPutCirPos) && (uccSkuPutCirPo1 = uccSkuPutCirPos.get(0)).getPreUpTime() != null) {
                rspBO.setPreOnShelveTime(DateUtils.dateToStr((Date)uccSkuPutCirPo1.getPreUpTime()));
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u67e5\u8be2\u4e0a\u4e0b\u67b6\u4fe1\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

