/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.bo.ability.CommodityPackBO;
import com.tydic.commodity.bo.ability.CommodityPackSpecBO;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uccext.bo.SkuImportBO;
import com.tydic.uccext.bo.UccDealImportCommodityReqBO;
import com.tydic.uccext.bo.UccDealImportCommodityRspBO;
import com.tydic.uccext.bo.UccGoodsAgreementAndCommodityBO;
import com.tydic.uccext.bo.UccGoodsIssueUpdateAbilityReqBO;
import com.tydic.uccext.bo.UccGoodsIssueUpdateAbilityRspBO;
import com.tydic.uccext.bo.UccGoodsTemplateToCreateAbilityReqBO;
import com.tydic.uccext.bo.UccGoodsTemplateToCreateAbilityRspBO;
import com.tydic.uccext.service.UccDealImportCommodityService;
import com.tydic.uccext.service.UccGoodsIssueUpdateAbilityService;
import com.tydic.uccext.service.UccGoodsTemplateToCreateAbilityService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.springframework.util.StringUtils;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccGoodsTemplateToCreateAbilityService.class)
public class UccGoodsTemplateToCreateAbilityServiceImpl
implements UccGoodsTemplateToCreateAbilityService {
    @Reference(interfaceClass=UccGoodsIssueUpdateAbilityService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccGoodsIssueUpdateAbilityService uccGoodsIssueUpdateAbilityService;
    @Reference(interfaceClass=UccDealImportCommodityService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccDealImportCommodityService uccDealImportCommodityService;

    public UccGoodsTemplateToCreateAbilityRspBO dealUccGoodsTemplateToCreate(UccGoodsTemplateToCreateAbilityReqBO reqBO) {
        UccGoodsTemplateToCreateAbilityRspBO rspBO = new UccGoodsTemplateToCreateAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        List<SkuImportBO> skuImportBOS = this.getData(reqBO);
        reqBO.setData(skuImportBOS);
        try {
            this.checkReq(reqBO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", e.getMessage());
        }
        for (SkuImportBO skuImportBO : skuImportBOS) {
            UccGoodsIssueUpdateAbilityReqBO uccGoodsIssueUpdateAbilityReqBO = new UccGoodsIssueUpdateAbilityReqBO();
            uccGoodsIssueUpdateAbilityReqBO.setOperType(Integer.valueOf(0));
            uccGoodsIssueUpdateAbilityReqBO.setSkuName(skuImportBO.getSkuName());
            uccGoodsIssueUpdateAbilityReqBO.setCatalogId(skuImportBO.getCatalogId());
            uccGoodsIssueUpdateAbilityReqBO.setMarketPrice(skuImportBO.getMarketPrice());
            uccGoodsIssueUpdateAbilityReqBO.setSkuSource(Integer.valueOf(3));
            uccGoodsIssueUpdateAbilityReqBO.setMiniOrderNum(skuImportBO.getMiniOrderNum());
            uccGoodsIssueUpdateAbilityReqBO.setCommodityPicInfo(skuImportBO.getCommodityPicInfo());
            uccGoodsIssueUpdateAbilityReqBO.setSkuDesc(skuImportBO.getSkuDesc());
            uccGoodsIssueUpdateAbilityReqBO.setCommodityPackInfo(skuImportBO.getCommodityPackInfo());
            uccGoodsIssueUpdateAbilityReqBO.setCommodityPackSpecBO(skuImportBO.getCommodityPackSpecBO());
            uccGoodsIssueUpdateAbilityReqBO.setGoodsAgreementAndCommodityBOS(skuImportBO.getGoodsAgreementAndCommodityBOS());
            uccGoodsIssueUpdateAbilityReqBO.setLadderPrice(skuImportBO.getLadderPrice());
            uccGoodsIssueUpdateAbilityReqBO.setOnShelveWay(Integer.valueOf(0));
            uccGoodsIssueUpdateAbilityReqBO.setSupplierId(skuImportBO.getSupplierId());
            uccGoodsIssueUpdateAbilityReqBO.setAgreementId(skuImportBO.getAgreementId());
            uccGoodsIssueUpdateAbilityReqBO.setShowPackUnit(skuImportBO.getIsShowPack());
            uccGoodsIssueUpdateAbilityReqBO.setMaterialCode(skuImportBO.getMaterialCode());
            uccGoodsIssueUpdateAbilityReqBO.setBrandCode(skuImportBO.getBrandCode());
            uccGoodsIssueUpdateAbilityReqBO.setIsBatchEdit(Boolean.valueOf(true));
            uccGoodsIssueUpdateAbilityReqBO.setOperMnueFunction(Integer.valueOf(0));
            UccGoodsIssueUpdateAbilityRspBO uccGoodsIssueUpdateAbilityRspBO = this.uccGoodsIssueUpdateAbilityService.dealUccGoodsIssueUpdate(uccGoodsIssueUpdateAbilityReqBO);
            if ("0000".equals(uccGoodsIssueUpdateAbilityRspBO.getRespCode())) continue;
            rspBO.setRespCode("8888");
            rspBO.setRespDesc(uccGoodsIssueUpdateAbilityRspBO.getRespDesc());
            return rspBO;
        }
        return rspBO;
    }

    private List<SkuImportBO> getData(UccGoodsTemplateToCreateAbilityReqBO reqBO) {
        UccDealImportCommodityRspBO uccDealImportCommodityRspBO;
        if (StringUtils.isEmpty((Object)reqBO.getPath())) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u8def\u5f84\u4fe1\u606f");
        }
        UccDealImportCommodityReqBO uccDealImportCommodityReqBO = new UccDealImportCommodityReqBO();
        uccDealImportCommodityReqBO.setPath(reqBO.getPath());
        try {
            uccDealImportCommodityRspBO = this.uccDealImportCommodityService.dealImportCommodity(uccDealImportCommodityReqBO);
        }
        catch (Exception e) {
            throw new BusinessException("8888", e.getMessage());
        }
        ArrayList<SkuImportBO> skuImportBOS = new ArrayList<SkuImportBO>();
        if ("0000".equals(uccDealImportCommodityRspBO.getRespCode())) {
            List data = uccDealImportCommodityRspBO.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (List row : data) {
                    int i = 0;
                    SkuImportBO skuImportBO = new SkuImportBO();
                    skuImportBO.setSkuCode((String)row.get(i++));
                    skuImportBO.setSkuName((String)row.get(i++));
                    if (row.get(i) != null) {
                        skuImportBO.setMarketPrice(new BigDecimal(Long.parseLong((String)row.get(i++))));
                    }
                    if (row.get(i) != null) {
                        skuImportBO.setMiniOrderNum(new BigDecimal(Long.parseLong((String)row.get(i++))));
                    }
                    skuImportBO.setSkuDesc((String)row.get(i++));
                    CommodityPackBO commodityPackBO = new CommodityPackBO();
                    if (row.get(i) != null) {
                        commodityPackBO.setLength(new BigDecimal(Long.parseLong((String)row.get(i++))));
                    }
                    if (row.get(i) != null) {
                        commodityPackBO.setWidth(new BigDecimal(Long.parseLong((String)row.get(i++))));
                    }
                    if (row.get(i) != null) {
                        commodityPackBO.setHeight(new BigDecimal(Long.parseLong((String)row.get(i++))));
                    }
                    commodityPackBO.setList((String)row.get(i++));
                    ArrayList<CommodityPackBO> commodityPackBOS = new ArrayList<CommodityPackBO>();
                    commodityPackBOS.add(commodityPackBO);
                    skuImportBO.setCommodityPackInfo(commodityPackBOS);
                    skuImportBO.setLadderPrice(null);
                    if (!StringUtils.isEmpty(row.get(++i))) {
                        skuImportBO.setIsShowPack(Integer.valueOf(Integer.parseInt((String)row.get(i++))));
                    }
                    if (!StringUtils.isEmpty(row.get(i))) {
                        skuImportBO.setCatalogId(Long.valueOf(Long.parseLong((String)row.get(i++))));
                    }
                    skuImportBO.setAgreementId((String)row.get(i++));
                    UccGoodsAgreementAndCommodityBO uccGoodsAgreementAndCommodityBO = new UccGoodsAgreementAndCommodityBO();
                    uccGoodsAgreementAndCommodityBO.setAgreementDetailsId((String)row.get(i++));
                    ArrayList<UccGoodsAgreementAndCommodityBO> uccGoodsAgreementAndCommodityBOS = new ArrayList<UccGoodsAgreementAndCommodityBO>();
                    uccGoodsAgreementAndCommodityBOS.add(uccGoodsAgreementAndCommodityBO);
                    skuImportBO.setGoodsAgreementAndCommodityBOS(uccGoodsAgreementAndCommodityBOS);
                    if (!StringUtils.isEmpty(row.get(i))) {
                        skuImportBO.setSupplierId(Long.valueOf(Long.parseLong((String)row.get(i++))));
                    }
                    CommodityPackSpecBO commodityPackSpecBO = new CommodityPackSpecBO();
                    if (!StringUtils.isEmpty(row.get(i))) {
                        commodityPackSpecBO.setSaleUnitPrice(new BigDecimal(Long.parseLong((String)row.get(i++))));
                    }
                    if (!StringUtils.isEmpty(row.get(i))) {
                        commodityPackSpecBO.setPurchaseUnitPrice(new BigDecimal(Long.parseLong((String)row.get(i++))));
                    }
                    commodityPackSpecBO.setSettlementUnit((String)row.get(i++));
                    commodityPackSpecBO.setSaleUnit((String)row.get(i++));
                    commodityPackSpecBO.setPackageSpec((String)row.get(i++));
                    if (!StringUtils.isEmpty(row.get(i))) {
                        commodityPackSpecBO.setUnitConversionValue(new BigDecimal(Long.parseLong((String)row.get(i++))));
                    }
                    if (!StringUtils.isEmpty(row.get(i))) {
                        commodityPackSpecBO.setPackagePurchaseUitPrice(new BigDecimal(Long.parseLong((String)row.get(i++))));
                    }
                    if (!StringUtils.isEmpty(row.get(i))) {
                        commodityPackSpecBO.setPackageSaleUnitPrice(new BigDecimal(Long.parseLong((String)row.get(i++))));
                    }
                    skuImportBO.setCommodityPackSpecBO(commodityPackSpecBO);
                    skuImportBO.setMaterialCode((String)row.get(i++));
                    skuImportBO.setBrandCode((String)row.get(i++));
                    skuImportBOS.add(skuImportBO);
                }
            } else {
                throw new BusinessException("8888", "\u5bfc\u5165\u4fe1\u606f\u4e3a\u7a7a");
            }
        }
        return skuImportBOS;
    }

    private void checkReq(UccGoodsTemplateToCreateAbilityReqBO reqBO) {
        if (CollectionUtils.isEmpty((Collection)reqBO.getData())) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u4fe1\u606f");
        }
        List skuImportBOS = reqBO.getData();
        for (SkuImportBO skuImportBO : skuImportBOS) {
            if (StringUtils.isEmpty((Object)skuImportBO.getSkuCode())) {
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u5546\u54c1\u7f16\u7801");
            }
            if (StringUtils.isEmpty((Object)skuImportBO.getSkuName())) {
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u5546\u54c1\u540d\u79f0");
            }
            if (StringUtils.isEmpty((Object)skuImportBO.getSkuDesc())) {
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u5546\u54c1\u4ecb\u7ecd");
            }
            if (skuImportBO.getIsShowPack() == null) {
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u662f\u5426\u5c55\u793a\u5305\u88c5\u5355\u4f4d");
            }
            if (skuImportBO.getCatalogId() == null) {
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u7c7b\u76eeID");
            }
            if (StringUtils.isEmpty((Object)skuImportBO.getAgreementId())) {
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u534f\u8baeID");
            }
            if (CollectionUtils.isEmpty((Collection)skuImportBO.getGoodsAgreementAndCommodityBOS())) {
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u534f\u8bae\u660e\u7ec6ID");
            }
            for (UccGoodsAgreementAndCommodityBO uccGoodsAgreementAndCommodityBO : skuImportBO.getGoodsAgreementAndCommodityBOS()) {
                if (!StringUtils.isEmpty((Object)uccGoodsAgreementAndCommodityBO.getAgreementDetailsId())) continue;
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u534f\u8bae\u660e\u7ec6ID");
            }
            if (skuImportBO.getSupplierId() == null) {
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u5546\u6237ID");
            }
            if (!skuImportBO.getIsShowPack().equals(1)) continue;
            if (skuImportBO.getCommodityPackSpecBO() == null) {
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u5546\u54c1\u5305\u88c5\u89c4\u683c\u4fe1\u606f");
            }
            if (skuImportBO.getCommodityPackSpecBO().getSaleUnitPrice() == null) {
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u9500\u552e\u5355\u4ef7");
            }
            if (skuImportBO.getCommodityPackSpecBO().getPurchaseUnitPrice() == null) {
                throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u91c7\u8d2d\u5355\u4ef7");
            }
            if (skuImportBO.getCommodityPackSpecBO().getSettlementUnit() != null) continue;
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u7ed3\u7b97\u5355\u4f4d");
        }
    }
}

