/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.CommodityRecordPO;
import com.tydic.commodity.dao.po.CommodityRecordVO;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.DateUtils;
import com.tydic.uccext.bo.CommodityAuditRecordBO;
import com.tydic.uccext.bo.UccZoneGoodsAuditRecordListQueryAbilityReqBO;
import com.tydic.uccext.bo.UccZoneGoodsAuditRecordListQueryAbilityRspBO;
import com.tydic.uccext.service.UccZoneGoodsAuditRecordListQueryAbilityService;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccZoneGoodsAuditRecordListQueryAbilityService.class)
public class UccZoneGoodsAuditRecordListQueryAbilityServiceImpl
implements UccZoneGoodsAuditRecordListQueryAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccZoneGoodsAuditRecordListQueryAbilityServiceImpl.class);

    public UccZoneGoodsAuditRecordListQueryAbilityRspBO getUccZoneGoodsAuditRecordListQuery(UccZoneGoodsAuditRecordListQueryAbilityReqBO reqBO) {
        List<CommodityRecordPO> commodityRecordPOS;
        UccZoneGoodsAuditRecordListQueryAbilityRspBO rspBO = new UccZoneGoodsAuditRecordListQueryAbilityRspBO();
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        if (reqBO.getAgreementId() == null) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u534f\u8baeID");
        }
        try {
            CommodityRecordVO commodityRecordVO = new CommodityRecordVO();
            commodityRecordVO.setSkuName(reqBO.getSkuName());
            commodityRecordVO.setSkuCode(reqBO.getSkuCode());
            commodityRecordVO.setSkuId(reqBO.getSkuId());
            commodityRecordVO.setAuditType(reqBO.getType());
            commodityRecordVO.setDealResult(reqBO.getDealResult());
            commodityRecordVO.setDealName(reqBO.getOrgName());
            commodityRecordVO.setSupplierId(reqBO.getSupplierId());
            commodityRecordVO.setAgreementId(String.valueOf(reqBO.getAgreementId()));
            if (StringUtils.isNotEmpty((String)reqBO.getDealTimeBegin())) {
                commodityRecordVO.setAuditTimeBegin(DateUtils.strToDate((String)reqBO.getDealTimeBegin()));
            }
            if (StringUtils.isNotEmpty((String)reqBO.getDealTimeEnd())) {
                commodityRecordVO.setAuditTimeEnd(DateUtils.strToDate((String)reqBO.getDealTimeEnd()));
            }
            commodityRecordPOS = this.uccSkuMapper.qryAuditRecordList(page, commodityRecordVO);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u67e5\u8be2\u5931\u8d25");
        }
        ArrayList<CommodityAuditRecordBO> commodityAuditRecordBOS = new ArrayList<CommodityAuditRecordBO>();
        if (CollectionUtils.isNotEmpty(commodityRecordPOS)) {
            for (CommodityRecordPO commodityRecordPO : commodityRecordPOS) {
                CommodityAuditRecordBO commodityAuditRecordBO = new CommodityAuditRecordBO();
                commodityAuditRecordBO.setSkuName(commodityRecordPO.getSkuName());
                commodityAuditRecordBO.setSkuCode(commodityRecordPO.getSkuCode());
                commodityAuditRecordBO.setType(commodityRecordPO.getAuditType());
                if (commodityAuditRecordBO.getType() != null) {
                    commodityAuditRecordBO.setTypeDesc(ApprovalTypeEnum.findByStep((String)commodityAuditRecordBO.getType().toString()).getMessage());
                }
                this.auditConvertStatus(commodityRecordPO, commodityAuditRecordBO);
                commodityAuditRecordBO.setDealName(commodityRecordPO.getDealName());
                if (commodityRecordPO.getAuditTime() != null) {
                    commodityAuditRecordBO.setDealTime(DateUtils.dateToStr((Date)commodityRecordPO.getAuditTime()));
                }
                commodityAuditRecordBO.setSupplierId(commodityRecordPO.getSupplierId());
                commodityAuditRecordBO.setSupplierName(commodityRecordPO.getSupplierName());
                commodityAuditRecordBO.setSupplierShopId(commodityRecordPO.getSupplierShopId());
                commodityAuditRecordBO.setSkuId(commodityRecordPO.getSkuId());
                commodityAuditRecordBOS.add(commodityAuditRecordBO);
            }
        }
        rspBO.setRows(commodityAuditRecordBOS);
        rspBO.setRecordsTotal(page.getTotalCount());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void auditConvertStatus(CommodityRecordPO recordPO, CommodityAuditRecordBO commodityAuditRecordBO) {
        if (null == recordPO.getDealResult()) {
            return;
        }
        if (recordPO.getDealResult() == 2) {
            commodityAuditRecordBO.setDealResult(Integer.valueOf(3));
            commodityAuditRecordBO.setDealResultDesc("\u5ba1\u6279\u9a73\u56de");
        } else if (recordPO.getDealResult() == 3) {
            commodityAuditRecordBO.setDealResult(Integer.valueOf(2));
            commodityAuditRecordBO.setDealResultDesc("\u5ba1\u6279\u901a\u8fc7");
        }
    }
}

