/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.tydic.commodity.atom.UccSkuPutCirAtomService;
import com.tydic.commodity.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.bo.busi.BatchUpdateCommoStatusForMarketBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPutCirPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.util.DateUtils;
import com.tydic.uac.exception.BusinessException;
import com.tydic.uccext.bo.UccProcessAuditReqBO;
import com.tydic.uccext.bo.UccProcessAuditRspBO;
import com.tydic.uccext.bo.UccZoneGoodsFirstOpenApprovalAbilityReqBO;
import com.tydic.uccext.bo.UccZoneGoodsFirstOpenApprovalAbilityRspBO;
import com.tydic.uccext.service.UccProcessAuditBusiService;
import com.tydic.uccext.service.UccZoneGoodsFirstOpenApprovalAbilityService;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccZoneGoodsFirstOpenApprovalAbilityService.class)
public class UccZoneGoodsFirstOpenApprovalAbilityServiceImpl
implements UccZoneGoodsFirstOpenApprovalAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccZoneGoodsFirstOpenApprovalAbilityServiceImpl.class);
    @Reference(interfaceClass=UccProcessAuditBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccProcessAuditBusiService processAuditBusiService;
    @Reference(interfaceClass=BatchUpdateCommoStatusForMarketService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private BatchUpdateCommoStatusForMarketService statusForMarketService;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;

    public UccZoneGoodsFirstOpenApprovalAbilityRspBO dealUccZoneGoodsFirstOpenApproval(UccZoneGoodsFirstOpenApprovalAbilityReqBO reqBO) {
        UccZoneGoodsFirstOpenApprovalAbilityRspBO rspBO = new UccZoneGoodsFirstOpenApprovalAbilityRspBO();
        reqBO.setStatus(Integer.valueOf(3));
        reqBO.setCurrentStatus(Integer.valueOf(1));
        reqBO.setObjType(ApprovalTypeEnum.APPROVAL_UP_SHELF);
        UccProcessAuditRspBO uccProcessAuditRspBO = this.processAuditBusiService.dealCheckParameters((UccProcessAuditReqBO)reqBO);
        if ("8888".equals(uccProcessAuditRspBO.getRespCode())) {
            throw new BusinessException("8888", uccProcessAuditRspBO.getRespDesc());
        }
        reqBO.setCommodityIds(uccProcessAuditRspBO.getCommodityIds());
        UccProcessAuditRspBO processAuditRspBO = this.processAuditBusiService.processAuditBusiService((UccProcessAuditReqBO)reqBO);
        if ("8888".equals(processAuditRspBO.getRespCode())) {
            LOGGER.error("\u6267\u884c\u4e0a\u67b6\u5ba1\u6279\u5931\u8d25,\u539f\u56e0\uff1a" + processAuditRspBO.getRespDesc());
            throw new BusinessException("8888", processAuditRspBO.getRespDesc());
        }
        for (int i = 0; i < reqBO.getCommodityIds().size(); ++i) {
            BatchUpdateCommoStatusForMarketBO batchUpdateCommoStatusForMarketBO = new BatchUpdateCommoStatusForMarketBO();
            batchUpdateCommoStatusForMarketBO.setReason(reqBO.getApprovalRemark());
            batchUpdateCommoStatusForMarketBO.setBusinessId(new Long[]{(Long)reqBO.getCommodityIds().get(i)});
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setCommodityId((Long)reqBO.getCommodityIds().get(i));
            List<UccSkuPo> skuPos = this.uccSkuMapper.qerySku(uccSkuPo);
            if (CollectionUtils.isEmpty(skuPos)) continue;
            uccSkuPo = skuPos.get(0);
            if (reqBO.getAuditResult() == 0) {
                this.statusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.REJECT_STATUS, SkuStatusEnum.REJECT_STATUS);
                continue;
            }
            if (reqBO.getAuditResult() == 1 && processAuditRspBO.getIsFinish().booleanValue() && 0 == uccSkuPo.getOnShelveWay()) {
                this.statusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.EFFECTIVE_STATUS, SkuStatusEnum.PENDING_SHELF_STATUS);
                continue;
            }
            if (reqBO.getAuditResult() == 1 && processAuditRspBO.getIsFinish().booleanValue() && 1 == uccSkuPo.getOnShelveWay()) {
                this.statusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.EFFECTIVE_STATUS, SkuStatusEnum.ON_SHELVES_STATUS);
                try {
                    UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                    uccSkuPutCirReqBO.setSkuId(uccSkuPo.getSkuId());
                    uccSkuPutCirReqBO.setSupplierShopId(uccSkuPo.getSupplierShopId());
                    uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr((Date)new Date()));
                    uccSkuPutCirReqBO.setUptype(2);
                    uccSkuPutCirReqBO.setState(1);
                    uccSkuPutCirReqBO.setRemark("\u81ea\u52a8-\u7acb\u5373\u4e0a\u67b6");
                    this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
                    continue;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new BusinessException("8888", "\u63d2\u5165\u5468\u671f\u8868\u5931\u8d25");
                }
            }
            if (reqBO.getAuditResult() != 1 || !processAuditRspBO.getIsFinish().booleanValue() || 2 != uccSkuPo.getOnShelveWay()) continue;
            UccSkuPutCirPo skuPutCirPo = new UccSkuPutCirPo();
            skuPutCirPo.setSkuId(uccSkuPo.getSkuId());
            skuPutCirPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
            List<UccSkuPutCirPo> uccSkuPutCirPos = this.uccSkuPutCirMapper.querySkuPutCir(skuPutCirPo);
            if (!CollectionUtils.isNotEmpty(uccSkuPutCirPos) || null == uccSkuPutCirPos.get(0).getPreUpTime() || DateUtils.compareDate((Date)new Date(), (Date)uccSkuPutCirPos.get(0).getPreUpTime()) <= 0) continue;
            this.statusForMarketService.batchUpdateCommoStatusForMarket(batchUpdateCommoStatusForMarketBO, CommodityStatusEnum.EFFECTIVE_STATUS, SkuStatusEnum.ON_SHELVES_STATUS);
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

