/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.atom.UccSkuPutCirAtomService;
import com.tydic.commodity.atom.UccSkuStatusUpdatesAtomService;
import com.tydic.commodity.atom.bo.UccSkuPutCirReqBO;
import com.tydic.commodity.atom.bo.UccSkuStatusUpdatesAtomReqBO;
import com.tydic.commodity.atom.bo.UccSkuStatusUpdatesAtomRspBO;
import com.tydic.commodity.bo.busi.SyncSceneCommodityToEsReqBO;
import com.tydic.commodity.bo.busi.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.constant.ModelRuleConstant;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.external.util.PropertiesUtil;
import com.tydic.commodity.util.DateUtils;
import com.tydic.commodity.util.ListUtils;
import com.tydic.uac.config.ProperticeVo;
import com.tydic.uccext.bo.UccZoneGoodsIssueOpenAbilityReqBO;
import com.tydic.uccext.bo.UccZoneGoodsIssueOpenAbilityRspBO;
import com.tydic.uccext.service.UccZoneGoodsIssueOpenAbilityService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccZoneGoodsIssueOpenAbilityService.class)
public class UccZoneGoodsIssueOpenAbilityServiceImpl
implements UccZoneGoodsIssueOpenAbilityService {
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStatusUpdatesAtomService uccSkuStatusUpdatesAtomService;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private ProperticeVo properticeVo;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;
    @Autowired
    private UccSkuPutCirAtomService uccSkuPutCirAtomService;
    private static final Logger LOGGER = LoggerFactory.getLogger(UccZoneGoodsIssueOpenAbilityServiceImpl.class);

    public UccZoneGoodsIssueOpenAbilityRspBO dealUccZoneGoodsIssueOpen(UccZoneGoodsIssueOpenAbilityReqBO reqBO) {
        List<UccSkuPo> uccSkuPos;
        UccZoneGoodsIssueOpenAbilityRspBO rspBO = new UccZoneGoodsIssueOpenAbilityRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        if (CollectionUtils.isEmpty((Collection)reqBO.getSkuIds())) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u54c1ID");
            return rspBO;
        }
        if (reqBO.getSupplierId() == null) {
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u8bf7\u4f20\u5165\u5546\u6237ID");
            return rspBO;
        }
        try {
            List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
            if (!CollectionUtils.isEmpty(supplierShopPos)) {
                reqBO.setSupplierShopId(supplierShopPos.get(0).getSupplierShopId());
            }
            uccSkuPos = this.uccSkuMapper.batchQrySku(reqBO.getSkuIds(), reqBO.getSupplierShopId());
            List<Long> failIds = new ArrayList();
            if (!CollectionUtils.isEmpty(uccSkuPos)) {
                for (UccSkuPo uccSkuPo : uccSkuPos) {
                    if (uccSkuPo.getSkuStatus() == SkuStatusEnum.PENDING_SHELF_STATUS.getStatus()) continue;
                    failIds.add(uccSkuPo.getSkuId());
                }
            }
            if ((failIds = ListUtils.removeNull(failIds)).size() > 0) {
                rspBO.setRespCode("8888");
                rspBO.setRespDesc("\u5546\u54c1" + failIds.toString() + "\u72b6\u6001\u4e0d\u4e3a\u5f85\u4e0a\u67b6");
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        try {
            UccSkuStatusUpdatesAtomReqBO uccSkuStatusUpdatesAtomReqBO = new UccSkuStatusUpdatesAtomReqBO();
            uccSkuStatusUpdatesAtomReqBO.setSkuIds(reqBO.getSkuIds());
            uccSkuStatusUpdatesAtomReqBO.setState(3);
            uccSkuStatusUpdatesAtomReqBO.setSupplierShopId(reqBO.getSupplierShopId());
            UccSkuStatusUpdatesAtomRspBO uccSkuStatusUpdatesAtomRspBO = this.uccSkuStatusUpdatesAtomService.dealUccSkuStatusUpdates(uccSkuStatusUpdatesAtomReqBO);
            if (!"0000".equals(uccSkuStatusUpdatesAtomRspBO.getRespCode())) {
                BeanUtils.copyProperties((Object)((Object)uccSkuStatusUpdatesAtomRspBO), (Object)rspBO);
                return rspBO;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u5931\u8d25");
        }
        List skuIds = reqBO.getSkuIds();
        try {
            for (Long skuId : skuIds) {
                UccSkuPutCirReqBO uccSkuPutCirReqBO = new UccSkuPutCirReqBO();
                uccSkuPutCirReqBO.setSkuId(skuId);
                uccSkuPutCirReqBO.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPutCirReqBO.setUptype(1);
                uccSkuPutCirReqBO.setRealUpTime(DateUtils.dateToStr((Date)new Date()));
                uccSkuPutCirReqBO.setCreateOperId(reqBO.getUsername());
                uccSkuPutCirReqBO.setRemark("\u624b\u52a8\u4e0a\u67b6");
                this.uccSkuPutCirAtomService.dealSkuPutCir(uccSkuPutCirReqBO);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new BusinessException("8888", "\u63d2\u5165\u4e0a\u4e0b\u67b6\u5468\u671f\u8868\u5931\u8d25");
        }
        if (!CollectionUtils.isEmpty(uccSkuPos)) {
            List agreementDetailsId = uccSkuPos.stream().filter(poList -> poList.getAgreementDetailsId() != null).map(UccSkuPo::getAgreementDetailsId).collect(Collectors.toList());
            List agreementDetailsIds = agreementDetailsId.stream().map(a -> String.valueOf(a)).collect(Collectors.toList());
            UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
            try {
                notifyMessageBO.setAgreementId(String.valueOf(uccSkuPos.get(0).getAgreementId()));
                notifyMessageBO.setAgreementSkuIds(agreementDetailsIds);
                notifyMessageBO.setAgreementSkuStatus("3");
                notifyMessageBO.setMemIdIn(reqBO.getUserId());
                notifyMessageBO.setOperCode(ApprovalTypeEnum.APPROVAL_UP_SHELF.code());
                LOGGER.info("\u624b\u52a8\u4e0a\u67b6\u5546\u54c1\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
                this.zoneGoodsAuditMQ.send(new ProxyMessage(this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TOPIC"), this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
            }
            catch (Exception var16) {
                LOGGER.error("\u624b\u52a8\u4e0a\u67b6\uff0c\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
                throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
            }
        }
        SyncSceneCommodityToEsReqBO syncSceneCommodityToEsReqBO = new SyncSceneCommodityToEsReqBO();
        syncSceneCommodityToEsReqBO.setSkuIds((List)Lists.newArrayList((Iterable)reqBO.getSkuIds()));
        syncSceneCommodityToEsReqBO.setSupplierId(reqBO.getSupplierShopId());
        syncSceneCommodityToEsReqBO.setOperType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS);
        syncSceneCommodityToEsReqBO.setSyncType(ModelRuleConstant.SYNC_ES_BY_SKU_ID);
        syncSceneCommodityToEsReqBO.setSingleType(ModelRuleConstant.SYNC_ES_SINGLETYPE_STATUS.intValue());
        LOGGER.info("\u53d1\u9001\u6d88\u606f\u540c\u6b65es\u5165\u53c2\u5c55\u793a\uff1a" + JSON.toJSONString((Object)syncSceneCommodityToEsReqBO));
        try {
            this.lmSyncCommodityMqServiceProvider.send(new ProxyMessage(PropertiesUtil.getProperty("LM_UCC_SYNC_TOPIC"), PropertiesUtil.getProperty("LM_UCC_SYNC_TAG"), JSON.toJSONString((Object)syncSceneCommodityToEsReqBO)));
        }
        catch (Exception e) {
            LOGGER.error("\u624b\u52a8\u4e0a\u67b6\uff0c\u53d1\u9001es MQ\u5931\u8d25\uff1a" + e);
            throw new BusinessException("8888", "\u521b\u5efaes\u6d88\u606f\u5931\u8d25");
        }
        return rspBO;
    }
}

