/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.bo.busi.CommodityBo;
import com.tydic.commodity.bo.busi.UccZoneGoodsAuditNotifyMessageBO;
import com.tydic.commodity.busi.api.BatchUpdateCommoStatusForMarketService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.enumType.ApprovalTypeEnum;
import com.tydic.commodity.enumType.AuditResultStatusEnum;
import com.tydic.commodity.enumType.SkuStatusEnum;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.uac.config.ProperticeVo;
import com.tydic.uccext.bo.UccGoodsAgreementAndCommodityBO;
import com.tydic.uccext.bo.UccPreProcessAuditReqBO;
import com.tydic.uccext.bo.UccPreProcessAuditRspBO;
import com.tydic.uccext.bo.UccZoneGoodsReopenAbilityReqBO;
import com.tydic.uccext.bo.UccZoneGoodsReopenAbilityRspBO;
import com.tydic.uccext.service.UccPreProcessAuditBusiService;
import com.tydic.uccext.service.UccZoneGoodsReopenAbilityService;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccZoneGoodsReopenAbilityService.class)
public class UccZoneGoodsReopenAbilityServiceImpl
implements UccZoneGoodsReopenAbilityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccZoneGoodsReopenAbilityServiceImpl.class);
    @Reference(interfaceClass=UccPreProcessAuditBusiService.class, version="1.0.0", group="UCC_GROUP_TEST")
    private UccPreProcessAuditBusiService preProcessAuditBusiService;
    @Value(value="${ZONE_GOODS_REOPEN_DEF_ID}")
    private String processDefId;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Reference(interfaceClass=BatchUpdateCommoStatusForMarketService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private BatchUpdateCommoStatusForMarketService statusForMarketService;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Resource(name="zoneGoodsAuditMQ")
    private ProxyMessageProducer zoneGoodsAuditMQ;
    @Autowired
    private ProperticeVo properticeVo;
    @Resource(name="lmSyncCommodityMqServiceProvider")
    private ProxyMessageProducer lmSyncCommodityMqServiceProvider;

    public UccZoneGoodsReopenAbilityRspBO dealUccZoneGoodsReopen(UccZoneGoodsReopenAbilityReqBO reqBO) {
        UccZoneGoodsReopenAbilityRspBO rspBO = new UccZoneGoodsReopenAbilityRspBO();
        UccPreProcessAuditReqBO uccPreProcessAuditReqBO = new UccPreProcessAuditReqBO();
        HashMap<Integer, SkuStatusEnum> map = new HashMap<Integer, SkuStatusEnum>();
        map.put(SkuStatusEnum.DOWN_FRAME_STATUS.getStatus(), SkuStatusEnum.DOWN_FRAME_STATUS);
        uccPreProcessAuditReqBO.setStatus(SkuStatusEnum.PENDING_APPROVAL_STATUS);
        uccPreProcessAuditReqBO.setCurrentStatus(map);
        List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isNotEmpty(supplierShopPos)) {
            uccPreProcessAuditReqBO.setSupplierShopId(supplierShopPos.get(0).getSupplierShopId());
            reqBO.setSupplierShopId(supplierShopPos.get(0).getSupplierShopId());
        }
        uccPreProcessAuditReqBO.setObjType(Integer.valueOf(ApprovalTypeEnum.RESTORE_UP_SHELF.getStep()));
        uccPreProcessAuditReqBO.setSkuIds(reqBO.getSkuIds());
        uccPreProcessAuditReqBO.setSyncAdtFlag(Integer.valueOf(0));
        uccPreProcessAuditReqBO.setProcessDefId(this.processDefId);
        uccPreProcessAuditReqBO.setSupplierId(reqBO.getSupplierId());
        UccPreProcessAuditRspBO uccPreProcessAuditRspBO = this.preProcessAuditBusiService.dealCheckParameters(uccPreProcessAuditReqBO);
        if ("8888".equals(uccPreProcessAuditRspBO.getRespCode())) {
            throw new BusinessException("8888", uccPreProcessAuditRspBO.getRespDesc());
        }
        uccPreProcessAuditReqBO.setSkuAndCommodity(uccPreProcessAuditRspBO.getAgreementAndCommodityBOS());
        UccPreProcessAuditRspBO preProcessAuditRspBO = this.preProcessAuditBusiService.dealPreProcessAudit(uccPreProcessAuditReqBO);
        if (!"0000".equals(preProcessAuditRspBO.getRespCode())) {
            throw new BusinessException("8888", preProcessAuditRspBO.getRespDesc());
        }
        UccCommodityPo commodityPo = null;
        for (UccGoodsAgreementAndCommodityBO uccGoodsAgreementAndCommodityBO : uccPreProcessAuditRspBO.getAgreementAndCommodityBOS()) {
            commodityPo = this.uccCommodityMapper.getCommodityById(uccGoodsAgreementAndCommodityBO.getCommodityId());
            CommodityBo commodityBo = new CommodityBo();
            BeanUtils.copyProperties((Object)commodityPo, (Object)commodityBo);
            commodityBo.setCommodityStatus(null);
            commodityBo.setApprovalStatus(preProcessAuditRspBO.getStepId());
            this.statusForMarketService.updateCommoApprovalStatus(commodityBo, AuditResultStatusEnum.Audit_Pass);
        }
        UccZoneGoodsAuditNotifyMessageBO notifyMessageBO = new UccZoneGoodsAuditNotifyMessageBO();
        try {
            notifyMessageBO.setStationCode(preProcessAuditRspBO.getNextStationCode());
            notifyMessageBO.setAgreementId(commodityPo.getAgreementId());
            notifyMessageBO.setAgreementSkuIds((List)Lists.newArrayList((Object[])new String[]{commodityPo.getAgreementDetailsId()}));
            notifyMessageBO.setAgreementSkuStatus("5");
            notifyMessageBO.setAuditStatus("2");
            notifyMessageBO.setMemIdIn(reqBO.getUserId());
            notifyMessageBO.setOperCode(ApprovalTypeEnum.RESTORE_UP_SHELF.code());
            LOGGER.info("\u5ba1\u6279\u53d1\u9001\u534f\u8baeMQ,\u6d88\u606f\u5185\u5bb9:" + JSON.toJSONString((Object)notifyMessageBO));
            this.zoneGoodsAuditMQ.send(new ProxyMessage(this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TOPIC"), this.properticeVo.getProperty("UCC_AUDIT_NOTIFY_TAG"), JSONObject.toJSONString((Object)notifyMessageBO)));
        }
        catch (Exception var16) {
            LOGGER.error("\u6062\u590d\u4e0a\u67b6\uff0c\u53d1\u9001\u534f\u8baeMQ\u5931\u8d25\uff1a" + var16);
            throw new BusinessException("8888", "\u521b\u5efa\u534f\u8bae\u6d88\u606f\u5931\u8d25");
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }
}

