/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.google.common.collect.Lists;
import com.ohaotian.plugin.common.util.DateUtils;
import com.ohaotian.plugin.db.OrderSequence;
import com.ohaotian.plugin.db.Page;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.bo.ability.CommodityPackBO;
import com.tydic.commodity.bo.busi.AddCoefficientBO;
import com.tydic.commodity.bo.busi.CommodityPackageInfo;
import com.tydic.commodity.bo.busi.CommodityPicBo;
import com.tydic.commodity.bo.busi.UccAddSupplierBusiReqBO;
import com.tydic.commodity.bo.busi.UccAddSupplierShopBusiReqBO;
import com.tydic.commodity.bo.busi.UccCommdAddCoefficientReqBO;
import com.tydic.commodity.bo.busi.UccVendorBO;
import com.tydic.commodity.busi.api.UccCommdAddCoefficientBusiService;
import com.tydic.commodity.dao.SupplierMapper;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccBrandDealMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityPackageMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.dao.UccSkuStockMapper;
import com.tydic.commodity.dao.UccVendorMapper;
import com.tydic.commodity.dao.po.SupplierBusiPo;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccBrandDealPO;
import com.tydic.commodity.dao.po.UccCommodityPackagePo;
import com.tydic.commodity.dao.po.UccCommodityPicPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccCommodityTypePo;
import com.tydic.commodity.dao.po.UccEMdmCatalogPO;
import com.tydic.commodity.dao.po.UccEMdmMaterialPO;
import com.tydic.commodity.dao.po.UccLadderPricePO;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.dao.po.UccSkuPricePo;
import com.tydic.commodity.dao.po.UccSkuPutCirPo;
import com.tydic.commodity.dao.po.UccSkuStockPo;
import com.tydic.commodity.dao.po.UccVendorPo;
import com.tydic.commodity.exception.BusinessException;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.EmdmMaterialBO;
import com.tydic.uccext.bo.LadderPriceBO;
import com.tydic.uccext.bo.UccGenerateCommodityDataReqBO;
import com.tydic.uccext.bo.UccGengerateCommodityDataRspBO;
import com.tydic.uccext.bo.UccGoodsAgreementAndCommodityBO;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public abstract class AbstractGenerateCommodity {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGenerateCommodity.class);
    @Autowired
    private UccCommodityMapper commodityMapper;
    @Autowired
    private SupplierMapper supplierMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    @Autowired
    private OrderSequence uccCommdSequence;
    @Autowired
    private UccBrandDealMapper brandDealMapper;
    @Autowired
    private UccCommodityTypeMapper commodityTypeMapper;
    @Autowired
    private UccSkuMapper skuMapper;
    @Autowired
    private OrderSequence uccSkuSequence;
    @Autowired
    private UccSkuPutCirMapper putCirMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccCommodityPackageMapper commodityPackageMapper;
    @Autowired
    private UccCommodityPicMapper commodityPicMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccSkuStockMapper uccSkuStockMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Reference(interfaceClass=UccCommdAddCoefficientBusiService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private UccCommdAddCoefficientBusiService uccCommdAddCoefficientBusiService;
    private Sequence uccBatchSequence = Sequence.getInstance();
    @Autowired
    private UccVendorMapper uccVendorMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;

    public UccGengerateCommodityDataRspBO dealCommoGenerateTemplateMethod(UccGenerateCommodityDataReqBO reqBO) {
        UccGengerateCommodityDataRspBO rspBO = new UccGengerateCommodityDataRspBO();
        this.createSupplierData(reqBO);
        this.createShopData(reqBO);
        this.createCommodityType(reqBO);
        this.createVendorData(reqBO);
        this.createBrandData(reqBO);
        this.createMaterial(reqBO);
        this.createCommoData(reqBO);
        this.createSkuData(reqBO);
        this.createPutCirData(reqBO);
        this.createSkuPriceData(reqBO);
        this.createPackageData(reqBO);
        this.createCommodityPic(reqBO);
        this.createLadderPriceData(reqBO);
        this.createStock(reqBO);
        this.createAddCoefficientData(reqBO);
        rspBO.setSkuId(reqBO.getSkuId());
        rspBO.setCommodityId(reqBO.getCommodityId());
        rspBO.setSupplierShopId(reqBO.getSupplierShopId());
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void createAddCoefficientData(UccGenerateCommodityDataReqBO reqBO) {
        if (reqBO.getMarkupRate() == null) {
            return;
        }
        UccCommdAddCoefficientReqBO addCoefficientReqBO = new UccCommdAddCoefficientReqBO();
        ArrayList addCoefficientBOS = Lists.newArrayList();
        AddCoefficientBO addCoefficientBO = new AddCoefficientBO();
        if (null == ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getMarkupRate()) {
            addCoefficientBO.setAddCoefficient(reqBO.getMarkupRate());
        } else {
            addCoefficientBO.setAddCoefficient(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getMarkupRate());
        }
        if (null == ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getCatalogId()) {
            addCoefficientBO.setCatalogId(reqBO.getCatalogId());
        } else {
            addCoefficientBO.setCatalogId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getCatalogId());
        }
        addCoefficientBO.setSupplierId(reqBO.getSupplierId());
        addCoefficientBO.setSupplierShopId(reqBO.getSupplierShopId());
        addCoefficientBO.setAllowMarketPrice(Integer.valueOf(0));
        if (!StringUtils.isBlank((String)reqBO.getSupplierName())) {
            addCoefficientBO.setShopName(reqBO.getSupplierName());
            addCoefficientBO.setSupplierName(reqBO.getSupplierName());
        } else {
            addCoefficientBO.setShopName("\u6ca1\u6709\u540d\u5b57\u5e97\u94fa");
            addCoefficientBO.setSupplierName("\u6ca1\u6709\u540d\u5b57\u5e97\u94fa");
        }
        addCoefficientBO.setRemark("\u534f\u8bae\u521b\u5efa\u5546\u54c1");
        addCoefficientBO.setSkuPriceId(reqBO.getSkuPriceId());
        addCoefficientBOS.add(addCoefficientBO);
        addCoefficientReqBO.setAddCoefficientInfo((List)addCoefficientBOS);
        this.uccCommdAddCoefficientBusiService.addCoefficient(addCoefficientReqBO);
    }

    private void createVendorData(UccGenerateCommodityDataReqBO reqBO) {
        UccVendorPo uccVendorPo = new UccVendorPo();
        uccVendorPo.setId(this.uccBatchSequence.nextId());
        UccVendorBO uccVendorBO = ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getVendorBO();
        if (uccVendorBO == null) {
            return;
        }
        UccVendorPo po = new UccVendorPo();
        po.setVendorName(uccVendorBO.getVendorName());
        List<UccVendorPo> vendorPos = this.uccVendorMapper.queryVerdor(po);
        if (CollectionUtils.isNotEmpty(vendorPos)) {
            reqBO.setVendorId(vendorPos.get(0).getVendorId());
            reqBO.setVendorShopId(vendorPos.get(0).getShopId());
            return;
        }
        uccVendorPo.setContacts(uccVendorBO.getContacts());
        uccVendorPo.setCreateTime(new Date());
        uccVendorPo.setRelaPhone1(uccVendorBO.getRelaPhone1());
        uccVendorPo.setRelaPhone2(uccVendorBO.getRelaPhone2());
        uccVendorPo.setShopName(uccVendorBO.getVendorName());
        if (StringUtils.isBlank((String)uccVendorBO.getVendorCode())) {
            uccVendorPo.setVendorCode(String.valueOf(uccVendorBO.getVendorId()));
        } else {
            uccVendorPo.setVendorCode(uccVendorBO.getVendorCode());
        }
        uccVendorPo.setShopId(uccVendorBO.getVendorId());
        uccVendorPo.setVendorId(uccVendorBO.getVendorId());
        uccVendorPo.setVendorName(uccVendorBO.getVendorName());
        try {
            this.uccVendorMapper.insert(uccVendorPo);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u521b\u5efa\u5546\u54c1\u5382\u5546\u5931\u8d25");
        }
        reqBO.setVendorId(uccVendorPo.getVendorId());
        reqBO.setVendorShopId(uccVendorPo.getShopId());
    }

    private void createStock(UccGenerateCommodityDataReqBO reqBO) {
        UccSkuStockPo skuStockPo = new UccSkuStockPo();
        skuStockPo.setSkuId(reqBO.getSkuId());
        skuStockPo.setStockId(this.uccBatchSequence.nextId());
        if (((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getStockNum() == null) {
            skuStockPo.setStockNum(BigDecimal.ZERO);
        } else {
            skuStockPo.setStockNum(BigDecimal.valueOf(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getStockNum()));
        }
        skuStockPo.setStockStatus(0);
        skuStockPo.setCreateTime(new Date());
        skuStockPo.setSupplierShopId(reqBO.getSupplierShopId());
        try {
            this.uccSkuStockMapper.addskuStock(skuStockPo);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u521b\u5efa\u5e93\u5b58\u5931\u8d25");
        }
    }

    private void createSupplierData(UccGenerateCommodityDataReqBO reqBO) {
        SupplierBusiPo supplierBusiPo = this.supplierMapper.selectSupplierById(reqBO.getSupplierId());
        if (null == supplierBusiPo) {
            UccAddSupplierBusiReqBO uccAddSupplierBusiReqBO = new UccAddSupplierBusiReqBO();
            uccAddSupplierBusiReqBO.setSupplierId(reqBO.getSupplierId());
            uccAddSupplierBusiReqBO.setCreateTime(new Date());
            uccAddSupplierBusiReqBO.setSupplierCode(reqBO.getSupplierCode());
            uccAddSupplierBusiReqBO.setSupplierName(reqBO.getSupplierName());
            uccAddSupplierBusiReqBO.setSupplierSource(Integer.valueOf(3));
            this.supplierMapper.insertSelective(uccAddSupplierBusiReqBO);
        }
    }

    public UccGengerateCommodityDataRspBO dealUpdateFromalTemplateMethod(UccGenerateCommodityDataReqBO reqBO) {
        UccGengerateCommodityDataRspBO rspBO = new UccGengerateCommodityDataRspBO();
        if (!reqBO.getIsBatchEdit().booleanValue()) {
            this.updateCommoData(reqBO);
            this.updateSkuData(reqBO);
            this.updateSkuPriceData(reqBO);
            this.updatePackageData(reqBO);
            this.updateLadderPriceData(reqBO);
        }
        this.updatePutCirData(reqBO);
        this.updateCommodityPic(reqBO);
        rspBO.setSkuId(reqBO.getSkuId());
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void updateLadderPriceData(UccGenerateCommodityDataReqBO reqBO) {
        UccLadderPricePO ladderPricePO = new UccLadderPricePO();
        ladderPricePO.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
        ladderPricePO.setSupplierShopId(reqBO.getSupplierShopId());
        List<UccLadderPricePO> uccLadderPricePOS = this.uccLadderPriceMapper.selectByExample(ladderPricePO);
        if (CollectionUtils.isNotEmpty(uccLadderPricePOS)) {
            try {
                this.uccLadderPriceMapper.deleteByExample(ladderPricePO);
            }
            catch (Exception e) {
                LOGGER.error("\u5220\u9664\u9636\u68af\u4ef7\u683c\u5931\u8d25:skuId:" + ladderPricePO.getSkuId());
                throw new BusinessException("8888", "\u5220\u9664\u9636\u68af\u4ef7\u683c\u5931\u8d25");
            }
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getLadderPrice())) {
            return;
        }
        for (LadderPriceBO ladderPriceBO : reqBO.getLadderPrice()) {
            UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
            if (ladderPriceBO.getPrice() != null) {
                uccLadderPricePO.setPrice(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getPrice()).longValue());
            }
            if (ladderPriceBO.getStartPrice() != null) {
                uccLadderPricePO.setStart(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getStartPrice()).longValue());
            }
            if (ladderPriceBO.getStopPrice() != null) {
                uccLadderPricePO.setStop(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getStopPrice()).longValue());
            }
            uccLadderPricePO.setId(this.uccBatchSequence.nextId());
            uccLadderPricePO.setSkuId(reqBO.getSkuId());
            uccLadderPricePO.setSupplierShopId(reqBO.getSupplierShopId());
            uccLadderPricePO.setSkuPriceId(reqBO.getSkuPriceId());
            try {
                this.uccLadderPriceMapper.insertSelective(uccLadderPricePO);
            }
            catch (Exception e) {
                LOGGER.error("\u53d1\u5e03\u5ba1\u6279\u9636\u68af\u4ef7\u683c\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
                throw new BusinessException("8888", "\u4fdd\u5b58\u9636\u68af\u4ef7\u683c\u5931\u8d25");
            }
        }
    }

    protected void updateCommodityPic(UccGenerateCommodityDataReqBO reqBO) {
        try {
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getCommodityPicInfo())) {
                this.commodityPicMapper.deleteByCommodityId(reqBO.getCommodityId(), reqBO.getSupplierShopId());
                for (CommodityPicBo commodityPicBo : reqBO.getCommodityPicInfo()) {
                    UccCommodityPicPo commodityPicPo = new UccCommodityPicPo();
                    commodityPicPo.setCommodityPicId(this.uccBatchSequence.nextId());
                    commodityPicPo.setCommodityId(reqBO.getCommodityId());
                    commodityPicPo.setCreateTime(new Date());
                    commodityPicPo.setCommodityPicUrl(commodityPicBo.getCommodityPicUrl());
                    commodityPicPo.setCommodityPicType(commodityPicBo.getCommodityPicType());
                    commodityPicPo.setSupplierShopId(reqBO.getSupplierShopId());
                    commodityPicPo.setUpdateTime(new Date());
                    this.commodityPicMapper.addcommodityPic(commodityPicPo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e13\u533a\u7f16\u8f91\uff0c\u521b\u5efa\u5546\u54c1\u56fe\u7247\u5931\u8d25,\u539f\u56e0" + e);
            throw new BusinessException("8888", "\u521b\u5efa\u5546\u54c1\u56fe\u7247\u5931\u8d25");
        }
    }

    private void updatePackageData(UccGenerateCommodityDataReqBO reqBO) {
        UccCommodityPackagePo commodityPackagePo = new UccCommodityPackagePo();
        commodityPackagePo.setCommodityId(reqBO.getCommodityId());
        commodityPackagePo.setSupplierShopId(reqBO.getSupplierShopId());
        List<UccCommodityPackagePo> commodityPackagePos = this.commodityPackageMapper.queryCommdPackage(commodityPackagePo);
        if (CollectionUtils.isEmpty(commodityPackagePos) || commodityPackagePos.size() != 1) {
            LOGGER.error("\u53d1\u5e03\u5ba1\u6279\u5546\u54c1\u5305\u88c5\u6570\u636e\u4fdd\u5b58\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5546\u54c1\u5305\u88c5\u6570\u636e\u4e0d\u5b58\u5728\uff0c\u6216\u8005\u5b58\u5728\u591a\u6761.commodityId:" + reqBO.getCommodityId());
            return;
        }
        if (CollectionUtils.isNotEmpty(commodityPackagePos)) {
            if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityPackInfo())) {
                return;
            }
            UccCommodityPackagePo uccCommodityPackagePo = commodityPackagePos.get(0);
            CommodityPackageInfo commodityPackageInfo = new CommodityPackageInfo();
            commodityPackageInfo.setPackParam(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getList());
            commodityPackageInfo.setUpdateTime(new Date());
            commodityPackageInfo.setWeight(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getWeight());
            commodityPackageInfo.setLength(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getLength());
            commodityPackageInfo.setHeight(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getHeight());
            commodityPackageInfo.setWidth(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getWidth());
            commodityPackageInfo.setPackageId(uccCommodityPackagePo.getPackageId());
            commodityPackageInfo.setSupplierShopId(uccCommodityPackagePo.getSupplierShopId());
            try {
                commodityPackageInfo.setUpdateTime(new Date());
                this.commodityPackageMapper.updateCommodityPackage(commodityPackageInfo);
            }
            catch (Exception e) {
                LOGGER.error("\u53d1\u5e03\u5ba1\u6279\u5546\u54c1\u5305\u88c5\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
                throw new BusinessException("8888", "\u4fdd\u5b58\u5546\u54c1\u5305\u88c5\u6570\u636e\u5931\u8d25");
            }
        }
    }

    private void updateSkuPriceData(UccGenerateCommodityDataReqBO reqBO) {
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        uccSkuPricePo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
        uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
        UccSkuPricePo skuPricePo = this.uccSkuPriceMapper.querySkuPrice(uccSkuPricePo);
        if (skuPricePo == null) {
            LOGGER.error("\u5546\u54c1\u4e34\u65f6\u6570\u636e\u56de\u5199\u6b63\u5f0f\u6570\u636e\u5931\u8d25\uff1a\u4ef7\u683c\u4e0d\u5b58\u5728:skuId:" + reqBO.getSkuId());
            throw new BusinessException("8888", "\u4ef7\u683c\u6570\u636e\u4e0d\u5b58\u5728");
        }
        skuPricePo.setMarketPrice(reqBO.getMarketPrice().longValue());
        skuPricePo.setSingleAgreementPrice(reqBO.getCommodityPackSpecBO().getSaleUnitPrice());
        skuPricePo.setSingleSalePrice(reqBO.getCommodityPackSpecBO().getPurchaseUnitPrice());
        if (null != reqBO.getCommodityPackSpecBO().getPackagePurchaseUitPrice()) {
            skuPricePo.setAgreementPrice(reqBO.getCommodityPackSpecBO().getPackagePurchaseUitPrice().longValue());
        }
        if (null != reqBO.getCommodityPackSpecBO().getPackageSaleUnitPrice()) {
            skuPricePo.setSalePrice(reqBO.getCommodityPackSpecBO().getPackageSaleUnitPrice().longValue());
        }
        try {
            reqBO.setSkuPriceId(skuPricePo.getSkuPriceId());
            skuPricePo.setUpdateTime(new Date());
            this.uccSkuPriceMapper.updateSkuPrice(skuPricePo);
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u5e03\u5ba1\u6279\u4ef7\u683c\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("8888", "\u4fdd\u5b58\u4ef7\u683c\u6570\u636e\u5931\u8d25");
        }
    }

    private void updatePutCirData(UccGenerateCommodityDataReqBO reqBO) {
        UccSkuPutCirPo skuPutCirPo = new UccSkuPutCirPo();
        skuPutCirPo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
        skuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
        try {
            this.putCirMapper.deleteSkuPutCirInfoBySkuId(skuPutCirPo);
        }
        catch (Exception e) {
            throw new BusinessException("8888", "\u5220\u9664\u4e0a\u4e0b\u67b6\u6570\u636e\u5931\u8d25");
        }
        if (reqBO.getOnShelveWay() != null && 2 == reqBO.getOnShelveWay()) {
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setId(this.uccBatchSequence.nextId());
            uccSkuPutCirPo.setState(1);
            uccSkuPutCirPo.setSkuId(reqBO.getSkuId());
            uccSkuPutCirPo.setUpType(reqBO.getOnShelveWay());
            uccSkuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPutCirPo.setCreateTime(new Date());
            uccSkuPutCirPo.setPreUpTime(reqBO.getShelveTime());
            try {
                this.putCirMapper.addSkuPutCir(uccSkuPutCirPo);
            }
            catch (Exception e) {
                LOGGER.error("\u53d1\u5e03\u5ba1\u6279\u4e0a\u4e0b\u67b6\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
                throw new BusinessException("8888", "\u4fdd\u5b58\u4e0a\u4e0b\u67b6\u6570\u636e\u5931\u8d25");
            }
        }
    }

    private void updateSkuData(UccGenerateCommodityDataReqBO reqBO) {
        UccSkuPo skuPo = new UccSkuPo();
        skuPo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
        List<UccSkuPo> skuPos = this.skuMapper.qerySku(skuPo);
        if (CollectionUtils.isEmpty(skuPos)) {
            throw new BusinessException("8888", "\u5355\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
        }
        skuPo.setMoq(reqBO.getMiniOrderNum() == null ? null : Integer.valueOf(reqBO.getMiniOrderNum().intValue()));
        skuPo.setOnShelveWay(reqBO.getOnShelveWay());
        skuPo.setSkuLongName(reqBO.getSkuName());
        skuPo.setSkuName(reqBO.getSkuName());
        skuPo.setSkuPcDetailChar(reqBO.getSkuDesc());
        skuPo.setSkuPcDetailUrl(reqBO.getSkuDesc());
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCommodityPackInfo())) {
            skuPo.setWeight(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getWeight());
        }
        skuPo.setIsShopSalesUnit(reqBO.getShowPackUnit());
        skuPo.setSalesUnitName(reqBO.getCommodityPackSpecBO().getSaleUnit());
        skuPo.setSalesUnitRate(reqBO.getCommodityPackSpecBO().getUnitConversionValue());
        skuPo.setPackageSpec(reqBO.getCommodityPackSpecBO().getPackageSpec());
        skuPo.setSettlementUnit(reqBO.getCommodityPackSpecBO().getSettlementUnit());
        skuPo.setSkuId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getSkuId());
        skuPo.setSupplierShopId(reqBO.getSupplierShopId());
        skuPo.setRemark(reqBO.getApprovalRemark());
        skuPo.setUpdateTime(new Date());
        try {
            this.skuMapper.updateSku(skuPo);
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u5e03\u5ba1\u6279\u5355\u54c1\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("8888", "\u4fdd\u5b58\u5355\u54c1\u6570\u636e\u5931\u8d25");
        }
    }

    protected void updateCommoData(UccGenerateCommodityDataReqBO reqBO) {
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        uccCommodityPo.setCommodityId(reqBO.getCommodityId());
        UccCommodityPo po = this.commodityMapper.qryCommdByCommdId(reqBO.getCommodityId(), reqBO.getSupplierShopId());
        if (po == null) {
            LOGGER.error("\u53d1\u5e03\u5ba1\u6279\u5546\u54c1\u6570\u636e\u4fdd\u5b58\u5931\u8d25,\u539f\u56e0\uff1a\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728\u3002commodityId" + reqBO.getCommodityId());
            throw new BusinessException("8888", "\u5546\u54c1\u6570\u636e\u4e0d\u5b58\u5728");
        }
        uccCommodityPo.setCommodityName(reqBO.getSkuName());
        uccCommodityPo.setSupplierShopId(reqBO.getSupplierShopId());
        uccCommodityPo.setCommodityPcDetailUrl(reqBO.getSkuDesc());
        uccCommodityPo.setCommodityPcDetailChar(reqBO.getSkuDesc());
        uccCommodityPo.setUpdateTime(new Date());
        try {
            this.commodityMapper.updateCommodity(uccCommodityPo);
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u5e03\u5ba1\u6279\u5546\u54c1\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
            throw new BusinessException("8888", "\u4fdd\u5b58\u5546\u54c1\u6570\u636e\u5931\u8d25");
        }
    }

    private void createLadderPriceData(UccGenerateCommodityDataReqBO reqBO) {
        UccLadderPricePO uccLadderPricePO = null;
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getLadderPrice())) {
            for (LadderPriceBO ladderPriceBO : reqBO.getLadderPrice()) {
                uccLadderPricePO = new UccLadderPricePO();
                if (ladderPriceBO.getPrice() != null) {
                    uccLadderPricePO.setPrice(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getPrice()).longValue());
                }
                if (ladderPriceBO.getStartPrice() != null) {
                    uccLadderPricePO.setStart(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getStartPrice()).longValue());
                }
                if (ladderPriceBO.getStopPrice() != null) {
                    uccLadderPricePO.setStop(MoneyUtils.yuanToHao((BigDecimal)ladderPriceBO.getStopPrice()).longValue());
                }
                uccLadderPricePO.setId(this.uccBatchSequence.nextId());
                uccLadderPricePO.setSkuId(reqBO.getSkuId());
                uccLadderPricePO.setSupplierShopId(reqBO.getSupplierShopId());
                uccLadderPricePO.setSkuPriceId(reqBO.getSkuPriceId());
                try {
                    this.uccLadderPriceMapper.insertSelective(uccLadderPricePO);
                }
                catch (Exception e) {
                    LOGGER.error("\u53d1\u5e03\u5ba1\u6279\u9636\u68af\u4ef7\u683c\u6570\u636e\u4fdd\u5b58\u5931\u8d25:\uff0c\u539f\u56e0\uff1a" + e.getMessage());
                    throw new BusinessException("8888", "\u4fdd\u5b58\u9636\u68af\u4ef7\u683c\u5931\u8d25");
                }
            }
        }
    }

    protected void createCommodityPic(UccGenerateCommodityDataReqBO reqBO) {
        try {
            if (CollectionUtils.isNotEmpty((Collection)reqBO.getCommodityPicInfo())) {
                for (CommodityPicBo commodityPicBo : reqBO.getCommodityPicInfo()) {
                    UccCommodityPicPo commodityPicPo = new UccCommodityPicPo();
                    commodityPicPo.setCommodityPicId(this.uccBatchSequence.nextId());
                    commodityPicPo.setCommodityId(reqBO.getCommodityId());
                    commodityPicPo.setCreateTime(new Date());
                    commodityPicPo.setCommodityPicUrl(commodityPicBo.getCommodityPicUrl());
                    commodityPicPo.setCommodityPicType(commodityPicBo.getCommodityPicType());
                    commodityPicPo.setSupplierShopId(reqBO.getSupplierShopId());
                    this.commodityPicMapper.addcommodityPic(commodityPicPo);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e13\u533a\u7f16\u8f91\uff0c\u521b\u5efa\u5546\u54c1\u56fe\u7247\u5931\u8d25,\u539f\u56e0" + e);
            throw new BusinessException("8888", "\u521b\u5efa\u5546\u54c1\u56fe\u7247\u5931\u8d25");
        }
    }

    private void createCommoData(UccGenerateCommodityDataReqBO reqBO) {
        UccCommodityPo commodityPo = null;
        Long commdityId = null;
        try {
            commodityPo = new UccCommodityPo();
            commodityPo.setSupplierShopId(reqBO.getSupplierShopId());
            commodityPo.setCommodityStatus(0);
            commodityPo.setCommodityPcDetailUrl(reqBO.getSkuDesc());
            commodityPo.setCommodityPcDetailChar(reqBO.getSkuDesc());
            try {
                commdityId = this.uccCommdSequence.nextId();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            commodityPo.setCommodityId(commdityId);
            commodityPo.setFreeFhipping(0);
            commodityPo.setViewOrder(0);
            commodityPo.setAgreementId(reqBO.getAgreementId());
            commodityPo.setBrandId(reqBO.getBrandId());
            commodityPo.setBrandName(reqBO.getBrandName());
            commodityPo.setCommodityCode("COMMODITY_CODE");
            commodityPo.setServenRejectAllow(0);
            commodityPo.setCommoditySource(3);
            commodityPo.setCommodityName(reqBO.getSkuName());
            commodityPo.setArrivalTime(reqBO.getArrivalTime());
            List<UccCommodityTypePo> uccCommodityTypePos = null == ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getCatalogId() ? this.commodityTypeMapper.selectByCatId(reqBO.getCatalogId()) : this.commodityTypeMapper.selectByCatId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getCatalogId());
            if (CollectionUtils.isEmpty(uccCommodityTypePos)) {
                throw new BusinessException("8888", "\u5546\u54c1\u7c7b\u578b\u4e0d\u5b58\u5728");
            }
            commodityPo.setCommodityTypeId(uccCommodityTypePos.get(0).getCommodityTypeId());
            commodityPo.setMaterialId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getMaterialId());
            commodityPo.setAgreementDetailsId(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getAgreementDetailsId());
            commodityPo.setVendorShopId(reqBO.getVendorShopId());
            commodityPo.setVendorId(reqBO.getVendorId());
            this.commodityMapper.addcommodity(commodityPo);
        }
        catch (Exception e) {
            LOGGER.error("\u4e13\u533a\u7f16\u8f91\uff0c\u521b\u5efa\u5546\u54c1\u4fe1\u606f\u5931\u8d25,\u539f\u56e0" + e);
            throw new BusinessException("8888", "\u521b\u5efa\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
        }
        reqBO.setCommodityId(commdityId);
        reqBO.setCommodityTypeId(commodityPo.getCommodityTypeId());
    }

    private void createSkuData(UccGenerateCommodityDataReqBO reqBO) {
        UccSkuPo po = new UccSkuPo();
        Long primaryKey = null;
        try {
            primaryKey = this.uccSkuSequence.nextId();
        }
        catch (SQLException e) {
            LOGGER.error("\u65b0\u589e\u5355\u54c1\u4e3b\u4f53\u4fe1\u606f\uff0c\u83b7\u53d6\u5e8f\u5217\u53f7\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
            throw new BusinessException("8888", "\u65b0\u589e\u5355\u54c1\u4e3b\u4f53\u4fe1\u606f\u5931\u8d25");
        }
        EmdmMaterialBO emdmMaterialBO = ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getEmdmMaterialBO();
        if (null == emdmMaterialBO) {
            throw new BusinessException("8888", "\u5546\u54c1\u578b\u53f7\u7b49\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        }
        po.setModel(emdmMaterialBO.getModel());
        po.setSpec(emdmMaterialBO.getSpec());
        po.setTexture(emdmMaterialBO.getTexture());
        po.setFigure(emdmMaterialBO.getFigure());
        po.setMaterialName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getMaterialName());
        if (((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getMaterialId() != null) {
            po.setMaterialId(String.valueOf(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getMaterialId()));
        }
        po.setSkuId(primaryKey);
        po.setSupplierShopId(reqBO.getSupplierShopId());
        po.setCommodityId(reqBO.getCommodityId());
        po.setSkuStatus(0);
        po.setOnShelveWay(reqBO.getOnShelveWay());
        po.setAgreementId(Long.valueOf(reqBO.getAgreementId()));
        po.setAgreementDetailsId(Long.valueOf(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getAgreementDetailsId()));
        po.setBrandId(reqBO.getBrandId());
        po.setBrandName(reqBO.getBrandName());
        po.setCommodityTypeId(reqBO.getCommodityTypeId());
        if (null != ((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getMaterialId()) {
            po.setMaterialId(String.valueOf(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getMaterialId()));
        }
        if (null != reqBO.getMiniOrderNum()) {
            po.setMoq(reqBO.getMiniOrderNum().intValue());
        }
        po.setShopName(reqBO.getShopName());
        po.setSkuCode("sku_code");
        po.setSkuLongName(reqBO.getSkuName());
        po.setSkuName(reqBO.getSkuName());
        po.setSkuPcDetailChar(reqBO.getSkuDesc());
        po.setSkuPcDetailUrl(reqBO.getSkuDesc());
        po.setSkuSource(3);
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getCommodityPackInfo())) {
            po.setWeight(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getWeight());
        }
        po.setIsShopSalesUnit(reqBO.getShowPackUnit());
        if (1 == reqBO.getShowPackUnit()) {
            po.setSalesUnitName(reqBO.getCommodityPackSpecBO().getSaleUnit());
            po.setSalesUnitRate(reqBO.getCommodityPackSpecBO().getUnitConversionValue());
            po.setPackageSpec(reqBO.getCommodityPackSpecBO().getPackageSpec());
            po.setSettlementUnit(reqBO.getCommodityPackSpecBO().getSettlementUnit());
        }
        po.setManufacturer(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getManufacturer());
        po.setAgreementType(reqBO.getAgreementType());
        po.setPreDeliverDay(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getPreDeliverDay());
        po.setMeasureName(((UccGoodsAgreementAndCommodityBO)reqBO.getGoodsAgreementAndCommodityBOS().get(0)).getMeasureName());
        try {
            this.skuMapper.addsku(po);
        }
        catch (Exception e) {
            LOGGER.error("\u521b\u5efa\u5355\u54c1\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
            throw new BusinessException("8888", "\u521b\u5efa\u5355\u54c1\u4fe1\u606f\u5931\u8d25");
        }
        reqBO.setSkuId(primaryKey);
    }

    private void createShopData(UccGenerateCommodityDataReqBO reqBO) {
        List<SupplierShopPo> supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getSupplierId());
        if (CollectionUtils.isEmpty(supplierShopPos)) {
            UccAddSupplierShopBusiReqBO supplierShopBusiReqBO = new UccAddSupplierShopBusiReqBO();
            supplierShopBusiReqBO.setSupplierShopId(Long.valueOf(this.uccBatchSequence.nextId()));
            supplierShopBusiReqBO.setSupplierId(reqBO.getSupplierId());
            supplierShopBusiReqBO.setSupplierName(reqBO.getSupplierName());
            supplierShopBusiReqBO.setShopName(reqBO.getSupplierName());
            supplierShopBusiReqBO.setRelaPhone1("11111111");
            supplierShopBusiReqBO.setContacts("111223");
            supplierShopBusiReqBO.setShopStatus(Integer.valueOf(1));
            supplierShopBusiReqBO.setAddress(reqBO.getAddress());
            reqBO.setSupplierShopId(supplierShopBusiReqBO.getSupplierShopId());
            this.supplierShopMapper.insertSelective(supplierShopBusiReqBO);
        } else {
            reqBO.setSupplierShopId(supplierShopPos.get(0).getSupplierShopId());
        }
    }

    private void createBrandData(UccGenerateCommodityDataReqBO reqBO) {
        UccBrandDealPO uccBrandDealPO = new UccBrandDealPO();
        uccBrandDealPO.setBrandId(reqBO.getBrandId());
        uccBrandDealPO.setBrandName(reqBO.getBrandCode());
        List<UccBrandDealPO> uccBrandDealPOS = this.brandDealMapper.selectBrand(uccBrandDealPO, (Page<UccBrandDealPO>)new Page());
        if (CollectionUtils.isNotEmpty(uccBrandDealPOS)) {
            UccBrandDealPO brandDealPO = uccBrandDealPOS.get(0);
            reqBO.setBrandId(brandDealPO.getBrandId());
            reqBO.setBrandName(brandDealPO.getBrandName());
        } else {
            UccBrandDealPO po = new UccBrandDealPO();
            po.setBrandCode(reqBO.getBrandCode());
            po.setBrandName(reqBO.getBrandCode());
            po.setBrandEnName(reqBO.getBrandCode());
            po.setEffTime(new Date());
            po.setExpTime(DateUtils.strToDateyyyyMMddHHmmss((String)"2099-12-31 00:00:00"));
            po.setBrandStatus(1);
            po.setCreateTime(DateUtils.dateToStrLong((Date)new Date()));
            po.setBrandId(this.uccBatchSequence.nextId());
            this.brandDealMapper.addBrand(po);
            reqBO.setBrandName(po.getBrandName());
            reqBO.setBrandId(po.getBrandId());
        }
    }

    private void createPutCirData(UccGenerateCommodityDataReqBO reqBO) {
        if (2 == reqBO.getOnShelveWay()) {
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setId(this.uccBatchSequence.nextId());
            uccSkuPutCirPo.setState(1);
            uccSkuPutCirPo.setSkuId(reqBO.getSkuId());
            uccSkuPutCirPo.setUpType(reqBO.getOnShelveWay());
            uccSkuPutCirPo.setSupplierShopId(reqBO.getSupplierShopId());
            uccSkuPutCirPo.setCreateTime(new Date());
            uccSkuPutCirPo.setPreUpTime(reqBO.getShelveTime());
            this.putCirMapper.addSkuPutCir(uccSkuPutCirPo);
        }
    }

    protected void createSkuPriceData(UccGenerateCommodityDataReqBO reqBO) {
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        try {
            uccSkuPricePo.setSkuPriceId(this.uccBatchSequence.nextId());
            reqBO.setSkuPriceId(uccSkuPricePo.getSkuPriceId());
            if (0 == reqBO.getShowPackUnit()) {
                uccSkuPricePo.setSkuId(reqBO.getSkuId());
                uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPricePo.setSingleAgreementPrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getCommodityPackSpecBO().getSaleUnitPrice()));
                uccSkuPricePo.setSingleSalePrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getCommodityPackSpecBO().getPurchaseUnitPrice()));
                uccSkuPricePo.setSalePrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getCommodityPackSpecBO().getSaleUnitPrice()).longValue());
                uccSkuPricePo.setAgreementPrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getCommodityPackSpecBO().getPurchaseUnitPrice()).longValue());
                uccSkuPricePo.setCreateTime(new Date());
                uccSkuPricePo.setMarketPrice(reqBO.getMarketPrice() != null ? Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)reqBO.getMarketPrice()).longValue()) : null);
                this.uccSkuPriceMapper.addskuPrice(uccSkuPricePo);
            } else {
                uccSkuPricePo.setSkuId(reqBO.getSkuId());
                uccSkuPricePo.setSupplierShopId(reqBO.getSupplierShopId());
                uccSkuPricePo.setSingleAgreementPrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getCommodityPackSpecBO().getSaleUnitPrice()));
                uccSkuPricePo.setSingleSalePrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getCommodityPackSpecBO().getPurchaseUnitPrice()));
                uccSkuPricePo.setAgreementPrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getCommodityPackSpecBO().getPackagePurchaseUitPrice()).longValue());
                uccSkuPricePo.setSalePrice(MoneyUtils.yuanToHao((BigDecimal)reqBO.getCommodityPackSpecBO().getPackageSaleUnitPrice()).longValue());
                uccSkuPricePo.setCreateTime(new Date());
                uccSkuPricePo.setMarketPrice(reqBO.getMarketPrice() != null ? Long.valueOf(MoneyUtils.yuanToHao((BigDecimal)reqBO.getMarketPrice()).longValue()) : null);
                this.uccSkuPriceMapper.addskuPrice(uccSkuPricePo);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u4e13\u533a\u7f16\u8f91,\u521b\u5efa\u5355\u54c1\u4ef7\u683c\u5931\u8d25,\u539f\u56e0\uff1a" + e);
            throw new BusinessException("8888", "\u521b\u5efa\u5355\u54c1\u4ef7\u683c\u5931\u8d25");
        }
    }

    private void createPackageData(UccGenerateCommodityDataReqBO reqBO) {
        UccCommodityPackagePo commodityPackagePo = new UccCommodityPackagePo();
        if (CollectionUtils.isEmpty((Collection)reqBO.getCommodityPackInfo())) {
            return;
        }
        commodityPackagePo.setPackParam(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getList());
        commodityPackagePo.setInvoiceType(1);
        commodityPackagePo.setCreateTime(new Date());
        commodityPackagePo.setWeight(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getWeight());
        commodityPackagePo.setLength(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getLength());
        commodityPackagePo.setHeight(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getHeight());
        commodityPackagePo.setWidth(((CommodityPackBO)reqBO.getCommodityPackInfo().get(0)).getWidth());
        commodityPackagePo.setCommodityId(reqBO.getCommodityId());
        commodityPackagePo.setSupplierShopId(reqBO.getSupplierShopId());
        try {
            commodityPackagePo.setPackageId(this.uccBatchSequence.nextId());
            this.commodityPackageMapper.addcommodityPackage(commodityPackagePo);
        }
        catch (Exception e) {
            LOGGER.error("\u65b0\u589e\u5546\u54c1\u89c4\u683c\u53c2\u6570\u5931\u8d25\uff1a" + e.getMessage());
            throw new BusinessException("8888", "\u65b0\u589e\u5546\u54c1\u89c4\u683c\u53c2\u6570\u5931\u8d25");
        }
    }

    private void createCommodityType(UccGenerateCommodityDataReqBO reqBO) {
        if (reqBO.getCatalogId() == null) {
            throw new BusinessException("8888", "\u8bf7\u4f20\u5165\u7269\u8d44\u5206\u7c7bID");
        }
        UccEMdmCatalogPO uccEMdmCatalogPO = this.uccEMdmCatalogMapper.queryByCatId(reqBO.getCatalogId());
        reqBO.setCatalogName(uccEMdmCatalogPO.getCatalogName());
        List<UccCommodityTypePo> uccCommodityTypePos = this.commodityTypeMapper.selectByCatId(reqBO.getCatalogId());
        if (CollectionUtils.isEmpty(uccCommodityTypePos)) {
            Long commodityTypeId = null;
            try {
                UccCommodityTypePo uccCommodityTypePo = new UccCommodityTypePo();
                commodityTypeId = this.uccBatchSequence.nextId();
                uccCommodityTypePo.setCommodityTypeId(commodityTypeId);
                uccCommodityTypePo.setCatalogId(reqBO.getCatalogId());
                if (uccEMdmCatalogPO != null) {
                    uccCommodityTypePo.setCommodityTypeName(uccEMdmCatalogPO.getCatalogName());
                }
                uccCommodityTypePo.setCommodityTypeStatus(1);
                uccCommodityTypePo.setRemark("\u521b\u5efa\u5546\u54c1\u540c\u6b65\u521b\u5efa\u5546\u54c1\u7c7b\u578b");
                this.commodityTypeMapper.addCommdType(uccCommodityTypePo);
            }
            catch (Exception e) {
                LOGGER.error("\u65b0\u589e\u5546\u54c1\u7c7b\u578b\u5931\u8d25\uff1a" + e.getMessage());
                throw new BusinessException("8888", "\u65b0\u589e\u5546\u54c1\u7c7b\u578b\u5931\u8d25");
            }
            reqBO.setCommodityTypeId(commodityTypeId);
        }
    }

    private void createMaterial(UccGenerateCommodityDataReqBO reqBO) {
        if (CollectionUtils.isNotEmpty((Collection)reqBO.getGoodsAgreementAndCommodityBOS())) {
            for (UccGoodsAgreementAndCommodityBO uccGoodsAgreementAndCommodityBO : reqBO.getGoodsAgreementAndCommodityBOS()) {
                List<UccEMdmMaterialPO> uccEMdmMaterialPOS = this.uccEMdmMaterialMapper.selectListByMaterialCode(uccGoodsAgreementAndCommodityBO.getMaterialCode(), uccGoodsAgreementAndCommodityBO.getMaterialName());
                if (CollectionUtils.isNotEmpty(uccEMdmMaterialPOS)) {
                    uccGoodsAgreementAndCommodityBO.setMaterialId(uccEMdmMaterialPOS.get(0).getMaterialId());
                    return;
                }
                Long materialId = 0L;
                try {
                    UccEMdmMaterialPO uccEMdmMaterialPO = new UccEMdmMaterialPO();
                    materialId = this.uccBatchSequence.nextId();
                    uccEMdmMaterialPO.setMaterialId(materialId);
                    uccEMdmMaterialPO.setMaterialCode(uccGoodsAgreementAndCommodityBO.getMaterialCode());
                    uccEMdmMaterialPO.setMaterialName(uccGoodsAgreementAndCommodityBO.getMaterialName());
                    uccEMdmMaterialPO.setCatalogId(reqBO.getCatalogId());
                    uccEMdmMaterialPO.setCatalogName(reqBO.getCatalogName());
                    uccEMdmMaterialPO.setSysId(0L);
                    this.uccEMdmMaterialMapper.insert(uccEMdmMaterialPO);
                    uccGoodsAgreementAndCommodityBO.setMaterialId(materialId);
                }
                catch (Exception e) {
                    LOGGER.error("\u65b0\u589e\u7269\u8d44\u4fe1\u606f\u5931\u8d25\uff1a" + e.getMessage());
                    throw new BusinessException("8888", "\u65b0\u589e\u7269\u8d44\u4fe1\u606f\u5931\u8d25");
                }
            }
        }
    }
}

