/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.tydic.commodity.util.ListCloneUtils;
import com.tydic.commodity.util.MoneyUtils;
import com.tydic.uccext.bo.IndexRecommendCommodityBO;
import com.tydic.uccext.bo.UccCommoIndexRecommendReqBO;
import com.tydic.uccext.bo.UccCommoIndexRecommendRspBO;
import com.tydic.uccext.dao.UccCommoRecommendMapper;
import com.tydic.uccext.dao.UccCommoRecommendTitleMapper;
import com.tydic.uccext.dao.po.UccCommoRecommendPO;
import com.tydic.uccext.dao.po.UccCommoRecommendTitlePO;
import com.tydic.uccext.service.UccCommoIndexRecommendBusiService;
import java.math.BigDecimal;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccCommoIndexRecommendBusiService.class)
public class UccCommoIndexRecommendBusiServiceImpl
implements UccCommoIndexRecommendBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommoIndexRecommendBusiServiceImpl.class);
    @Autowired
    private UccCommoRecommendMapper recommendMapper;
    @Autowired
    private UccCommoRecommendTitleMapper recommendTitleMapper;

    public UccCommoIndexRecommendRspBO qryIndexRecommend(UccCommoIndexRecommendReqBO reqBO) {
        List<UccCommoRecommendTitlePO> uccCommoRecommendTitlePOs;
        UccCommoIndexRecommendRspBO rspBO = new UccCommoIndexRecommendRspBO();
        reqBO.setSupplierId(reqBO.getOrgIdIn());
        UccCommoRecommendTitlePO recommendTitlePO = new UccCommoRecommendTitlePO();
        recommendTitlePO.setTitleSource(reqBO.getTitleSource());
        recommendTitlePO.setSupplierId(reqBO.getSupplierId());
        recommendTitlePO.setSupplierShopId(reqBO.getSupplierShopId());
        if (recommendTitlePO.getSupplierId() != null && recommendTitlePO.getSupplierShopId() != null) {
            recommendTitlePO.setSupplierId(null);
        }
        if ((uccCommoRecommendTitlePOs = this.recommendTitleMapper.queryRecommendTitle(recommendTitlePO)) == null || uccCommoRecommendTitlePOs.size() == 0) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u6807\u9898");
            return rspBO;
        }
        UccCommoRecommendPO recommendPO = new UccCommoRecommendPO();
        recommendPO.setColumnCode(uccCommoRecommendTitlePOs.get(0).getId().toString());
        recommendPO.setSupplierId(reqBO.getOrgIdIn());
        List<UccCommoRecommendPO> uccCommoRecommendPOS = this.recommendMapper.queryCategoryRecommend(recommendPO);
        if (CollectionUtils.isEmpty(uccCommoRecommendPOS)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u672a\u67e5\u8be2\u5230\u5546\u54c1\u6570\u636e");
            rspBO.setRecommendCommodityBOS(null);
            return rspBO;
        }
        try {
            List indexRecommendCommodityBOS = ListCloneUtils.clonePOListToBOList(uccCommoRecommendPOS, IndexRecommendCommodityBO.class);
            for (IndexRecommendCommodityBO categoryRecommendCommodityBO : indexRecommendCommodityBOS) {
                if (null == categoryRecommendCommodityBO.getPrice()) continue;
                categoryRecommendCommodityBO.setPrice(MoneyUtils.haoToYuan((BigDecimal)categoryRecommendCommodityBO.getPrice()));
            }
            rspBO.setRecommendCommodityBOS(indexRecommendCommodityBOS);
        }
        catch (Exception e) {
            LOGGER.error("\u9996\u9875\u63a8\u8350\u5546\u54c1\u67e5\u8be2\u5931\u8d25,\u6570\u636e\u8f6c\u6362\u5f02\u5e38");
            rspBO.setRespCode("8888");
            rspBO.setRespDesc("\u5931\u8d25");
            rspBO.setRecommendCommodityBOS(null);
            return rspBO;
        }
        rspBO.setRespDesc("\u6210\u529f");
        rspBO.setRespCode("0000");
        return rspBO;
    }
}

