/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.uccext.busi.impl;

import com.google.common.collect.Lists;
import com.tydic.commodity.bo.busi.UccCommodityUpReqBO;
import com.tydic.commodity.bo.busi.UccCommodityUpRspBO;
import com.tydic.commodity.busi.api.UccCommodityUpBusiService;
import com.tydic.commodity.dao.SupplierShopMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.po.SupplierShopPo;
import com.tydic.commodity.dao.po.UccCommodityPo;
import com.tydic.commodity.dao.po.UccSkuPo;
import com.tydic.commodity.enumType.CommodityStatusEnum;
import com.tydic.uccext.bo.ShelvesDetailBO;
import com.tydic.uccext.bo.ShelvesFailDetailBO;
import com.tydic.uccext.bo.UccCommodityBatchShelvesReqBO;
import com.tydic.uccext.bo.UccCommodityBatchShelvesRspBO;
import com.tydic.uccext.service.UccCommodityBatchShelvesBusiService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.dubbo.config.annotation.Reference;
import org.apache.dubbo.config.annotation.Service;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Service(version="1.0.0", group="UCC_GROUP_TEST", interfaceClass=UccCommodityBatchShelvesBusiService.class)
public class UccCommodityBatchShelvesBusiServiceImpl
implements UccCommodityBatchShelvesBusiService {
    private static final Logger LOGGER = LoggerFactory.getLogger(UccCommodityBatchShelvesBusiServiceImpl.class);
    @Reference(interfaceClass=UccCommodityUpBusiService.class, version="1.0.0", group="UCC_GROUP_DEV")
    private UccCommodityUpBusiService uccCommodityUpBusiService;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private SupplierShopMapper supplierShopMapper;
    private static final String SUCCESS_COUNT = "SUCCESS_COUNT";
    private static final String ERROR_COUNT = "ERROR_COUNT";
    private static final String SHELF_SOURCES = "linkmall";

    public UccCommodityBatchShelvesRspBO batchShelves(UccCommodityBatchShelvesReqBO reqBO) {
        UccCommodityBatchShelvesRspBO uccCommodityBatchShelvesRspBO = new UccCommodityBatchShelvesRspBO();
        List<ShelvesFailDetailBO> shelvesFailDetailBOS = this.shelvesCheck(reqBO.getCommodityId());
        ArrayList shelvesDetailBOS = Lists.newArrayList();
        HashMap<String, MutableInteger> countMap = new HashMap<String, MutableInteger>();
        try {
            for (Long commodityId : reqBO.getCommodityId()) {
                List<UccSkuPo> uccSkuPos;
                List<SupplierShopPo> supplierShopPos;
                MutableInteger initValue = new MutableInteger(1);
                ShelvesDetailBO shelvesDetailBO = new ShelvesDetailBO();
                ShelvesFailDetailBO shelvesFailDetailBO = shelvesFailDetailBOS.stream().filter(s -> s.getCommodityId().equals(commodityId)).findFirst().orElse(null);
                if (shelvesFailDetailBO != null) {
                    shelvesDetailBO.setReason(shelvesFailDetailBO.getReason());
                    shelvesDetailBO.setCommodityId(commodityId);
                    shelvesDetailBO.setDownType(Boolean.valueOf(false));
                    shelvesDetailBOS.add(shelvesDetailBO);
                    MutableInteger oldValue = countMap.put(ERROR_COUNT, initValue);
                    if (oldValue == null) continue;
                    initValue.set(oldValue.get() + 1);
                    continue;
                }
                UccSkuPo uccSkuPo = new UccSkuPo();
                uccSkuPo.setCommodityId(commodityId);
                Long supplierShopId = null;
                if (reqBO.getOrgIdIn() != null && CollectionUtils.isNotEmpty(supplierShopPos = this.supplierShopMapper.selectSupplierShopBySupplierId(reqBO.getOrgIdIn()))) {
                    supplierShopId = supplierShopPos.get(0).getSupplierShopId();
                    uccSkuPo.setSupplierShopId(supplierShopPos.get(0).getSupplierShopId());
                }
                if (CollectionUtils.isEmpty(uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo))) {
                    LOGGER.error("linkmall \u4e0a\u67b6\u5546\u54c1\u5931\u8d25\uff0c\u5355\u54c1\u4e0d\u5b58\u5728\uff0ccommodityId:" + commodityId);
                    shelvesDetailBO.setReason("\u4e0a\u67b6\u5546\u54c1\u5931\u8d25\uff0c\u5355\u54c1\u4e0d\u5b58\u5728");
                    shelvesDetailBO.setCommodityId(commodityId);
                    shelvesDetailBO.setDownType(Boolean.valueOf(false));
                    shelvesDetailBOS.add(shelvesDetailBO);
                    MutableInteger oldValue = countMap.put(ERROR_COUNT, initValue);
                    if (oldValue == null) continue;
                    initValue.set(oldValue.get() + 1);
                    continue;
                }
                UccCommodityUpReqBO uccCommodityUpReqBO = new UccCommodityUpReqBO();
                List skuIdList = uccSkuPos.stream().map(UccSkuPo::getSkuId).collect(Collectors.toList());
                uccCommodityUpReqBO.setSkuIds(skuIdList);
                uccCommodityUpReqBO.setSupplierShopId(uccSkuPos.get(0).getSupplierShopId());
                uccCommodityUpReqBO.setUpType(Integer.valueOf(1));
                uccCommodityUpReqBO.setShelfSource(SHELF_SOURCES);
                UccCommodityUpRspBO uccCommodityUpRspBO = this.uccCommodityUpBusiService.dealCommodityUp(uccCommodityUpReqBO);
                if ("8888".equals(uccCommodityUpRspBO.getRespCode())) {
                    LOGGER.error("\u4e0a\u67b6\u5931\u8d25\uff0cskuIds:" + skuIdList.toString() + "\u539f\u56e0\uff1a" + uccCommodityUpRspBO.getRespDesc());
                    shelvesDetailBO.setReason(uccCommodityUpRspBO.getRespDesc());
                    shelvesDetailBO.setCommodityId(commodityId);
                    shelvesDetailBO.setDownType(Boolean.valueOf(false));
                    shelvesDetailBOS.add(shelvesDetailBO);
                    MutableInteger oldValue = countMap.put(ERROR_COUNT, initValue);
                    if (oldValue == null) continue;
                    initValue.set(oldValue.get() + 1);
                    continue;
                }
                UccCommodityPo uccCommodityPo = new UccCommodityPo();
                uccCommodityPo.setCommodityId(commodityId);
                uccCommodityPo.setCommodityStatus(CommodityStatusEnum.EFFECTIVE_STATUS.getStatus());
                uccCommodityPo.setSupplierShopId(supplierShopId);
                uccCommodityPo.setRemark("");
                try {
                    this.uccCommodityMapper.updateCommodity(uccCommodityPo);
                }
                catch (Exception e) {
                    shelvesDetailBO.setReason("\u4fee\u6539\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
                    shelvesDetailBO.setCommodityId(commodityId);
                    shelvesDetailBO.setDownType(Boolean.valueOf(false));
                    shelvesDetailBOS.add(shelvesDetailBO);
                    MutableInteger oldValue = countMap.put(ERROR_COUNT, initValue);
                    if (oldValue == null) continue;
                    initValue.set(oldValue.get() + 1);
                    continue;
                }
                MutableInteger oldValue = countMap.put(SUCCESS_COUNT, initValue);
                if (oldValue != null) {
                    initValue.set(oldValue.get() + 1);
                }
                shelvesDetailBO.setCommodityId(commodityId);
                shelvesDetailBO.setDownType(Boolean.valueOf(true));
                shelvesDetailBOS.add(shelvesDetailBO);
            }
        }
        catch (Exception e) {
            uccCommodityBatchShelvesRspBO.setRespCode("8888");
            uccCommodityBatchShelvesRspBO.setRespDesc("\u6210\u529f");
            return uccCommodityBatchShelvesRspBO;
        }
        uccCommodityBatchShelvesRspBO.setDownResult((List)shelvesDetailBOS);
        uccCommodityBatchShelvesRspBO.setFail(Integer.valueOf(countMap.get(ERROR_COUNT) == null ? 0 : ((MutableInteger)countMap.get(ERROR_COUNT)).get()));
        uccCommodityBatchShelvesRspBO.setSuccess(Integer.valueOf(countMap.get(SUCCESS_COUNT) == null ? 0 : ((MutableInteger)countMap.get(SUCCESS_COUNT)).get()));
        int errorCount = countMap.get(ERROR_COUNT) == null ? 0 : ((MutableInteger)countMap.get(ERROR_COUNT)).get();
        int successCount = countMap.get(SUCCESS_COUNT) == null ? 0 : ((MutableInteger)countMap.get(SUCCESS_COUNT)).get();
        uccCommodityBatchShelvesRspBO.setTotal(Integer.valueOf(errorCount + successCount));
        uccCommodityBatchShelvesRspBO.setRespCode("0000");
        uccCommodityBatchShelvesRspBO.setRespDesc("\u6210\u529f");
        return uccCommodityBatchShelvesRspBO;
    }

    public List<ShelvesFailDetailBO> shelvesCheck(List<Long> commodityIds) {
        ArrayList shelvesFailDetailBOS = Lists.newArrayList();
        for (Long commodityId : commodityIds) {
            ShelvesFailDetailBO shelvesFailDetailBO = new ShelvesFailDetailBO();
            UccCommodityPo commodityPo = this.uccCommodityMapper.getCommodityById(commodityId);
            if (commodityPo == null) {
                shelvesFailDetailBO.setCommodityId(commodityId);
                shelvesFailDetailBO.setReason("\u5546\u54c1\u4e0d\u5b58\u5728");
                shelvesFailDetailBOS.add(shelvesFailDetailBO);
                continue;
            }
            UccSkuPo uccSkuPo = new UccSkuPo();
            uccSkuPo.setCommodityId(commodityId);
            List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qerySku(uccSkuPo);
            if (CollectionUtils.isEmpty(uccSkuPos)) {
                shelvesFailDetailBO.setCommodityId(commodityId);
                shelvesFailDetailBO.setReason("\u5355\u54c1\u4e0d\u5b58\u5728");
                shelvesFailDetailBOS.add(shelvesFailDetailBO);
                continue;
            }
            if (!CollectionUtils.isNotEmpty(uccSkuPos)) continue;
            if (uccSkuPos.get(0).getSkuStatus() == 7) {
                shelvesFailDetailBO.setCommodityId(commodityId);
                shelvesFailDetailBO.setReason("\u6e20\u9053\u65b9\u7981\u552e");
                shelvesFailDetailBOS.add(shelvesFailDetailBO);
                continue;
            }
            if (uccSkuPos.get(0).getSkuStatus() != 10) continue;
            shelvesFailDetailBO.setCommodityId(commodityId);
            shelvesFailDetailBO.setReason("\u6e20\u9053\u65b9\u5df2\u4e0d\u53ef\u552e\u5356");
            shelvesFailDetailBOS.add(shelvesFailDetailBO);
        }
        return shelvesFailDetailBOS;
    }

    private static final class MutableInteger {
        private int val;

        public MutableInteger(int val) {
            this.val = val;
        }

        public int get() {
            return this.val;
        }

        public void set(int val) {
            this.val = val;
        }

        public String toString() {
            return Integer.toString(this.val);
        }
    }
}

